/* Questao 4 - Prova 1 */
/* Usa as funcoes da questao 3 */

/* item A */
int *Area(int **M, int m, int n) {
    int *resp;
    int i, j;
    int tmp;

    /* o valor maximo da matriz e o numero de figuras */
    int max = MaiorValor(M, m, n);

    /* aloca o vetor resposta */
    resp = (int*)malloc((max+1)*sizeof(int));
    /* numero de elementos da resposta */
    resp[0] = max+1;
    for (i = 1; i <= max; i++) {
        resp[i] = 0;
    }

    /* anda pela matriz */
    for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
            if (M[i][j] != 0) {
                /* soma 1 na area da figura */
                tmp = M[i][j];
                resp[tmp] += 1;
            }
        }
    }

    return resp;
}

/* item B */
int **Bordas(int **M, int m, int n) {
    int **resp;
    int i, j, h;

    int dx[] = {+1, -1,  0,  0};
    int dy[] = { 0,  0, +1, -1};

    resp = AlocaMatriz(m, n);

    for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
            /* inicializa o valor atual como 0 */
            resp[i][j] = 0;
            if (M[i][j] == 0) /* fundo da imagem */
                continue;

            /* olhamos os quatro vizinhos da celula atual */
            for (h = 0; h < 4; h++) {
                /* verifica se o vizinho esta dentro da matriz */
                if (i + dy[h] >= 0 && i + dy[h] < m &&
                    j + dx[h] >= 0 && j + dx[h] < n) {
                    /* se algum vizinho for diferent do valor da celula,
                     * entao a celula e uma borda */
                    if (M[i][j] != M[i+dy[h]][j+dx[h]]) {
                        resp[i][j] = 1;
                    }
                } else {
                    /* nesse caso, a celula nao tem algum dos vizinhos,
                     * entao tambem e borda */
                    resp[i][j] = 1;
                }
            }
        }
    }

    return resp;
}

/* item C */
int *Perimetro(int **M, int m, int n) {
    int **bordas, *resp;
    int max;
    int i, j;
    int pos;

    /* o valor maximo da matriz e o numero de figuras */
    max = MaiorValor(M, m, n);

    /* aloca o vetor resposta */
    resp = (int*)malloc((max+1)*sizeof(int));
    /* numero de elementos da resposta */
    resp[0] = max+1;
    for (i = 1; i <= max; i++) {
        resp[i] = 0;
    }

    /* pegamos a matriz de bordas */
    bordas = Bordas(M, m, n);

    /* agora somamos 1 no perimetro de uma figura
     * para cada celula de borda que essa figura tem */
    for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
            if (bordas[i][j] == 1) {
                /* nesse caso, a posicao (i, j) da matriz e
                 * uma borda. entao somamos 1 no perimetro
                 * do elemento naquela posicao */
                pos = M[i][j];
                resp[pos]++;
            }
        }
    }

    /* libera a memoria usada pela matriz bordas */
    LiberaMatriz(bordas, m);

    return resp;
}
