# Larissa dos Anjos Miyagi nUSP 6818653
# script EP 6 (linguagem utilizada: R)

library(MASS)

rr <- function(t, beta, gama) # função confiança r com dois parâmetros
return ( exp(-(t/gama)^beta) )

w <- function(t, alfa, beta, gama) # função densidade w com 3 parâmetros
return( (beta*(t + alfa)^(beta-1)/gama^beta)*exp(-((t + alfa)/gama)^beta)/rr(alfa,beta,gama) )

r <- function(t, alfa, beta, gama) # função r com 3 parâmetros
return( exp(-((t + alfa)/gama)^beta)/rr(alfa, beta, gama) )

wl <- function(t, alfa, beta, gama) # log de w
return ( log(beta) + (beta-1)*log(t + alfa) - beta*log(gama) - ((t + alfa)/gama)^beta + (alfa/gama)^beta )

rl <- function(t, alfa, beta, gama){ # log de rr
return ( -((t + alfa)/gama)^beta + (alfa/gama)^beta )
}

fl <-function(wl, rl)  #log de verossimilhança
return ( sum(wl) + sum(rl) )

L <- function(alfa, beta, gama, n, m){
W= rep(0,0)
W <- c(w(tw[1], alfa, beta, gama))
R=rep(0,0)
R <- c(r(tr[1], alfa, beta, gama))
for(i in 2:m) W <- c(w(tw[i], alfa, beta, gama))
for(i in 2:n) R <- c(r(tr[i], alfa, beta, gama))
return(prod(W)*prod(R))
}

entrada<-function(){
tabela <-matrix(1:50,ncol=10) # def tabela com dados de entrada
tabela <- read.table("tabela1.txt")
 }

ts <- function(tabela, col, N){
i = 1
j = 1
k = 1
t = rep(0,0)
while(i <=N){
while(k <= col){
t[i] = c(tabela[j,k])
k = k + 1
i = i + 1
}
k = 1
j = j + 1
}
return (t)
}

Tr <-function(t){ # pontos aceitos
tr = rep(0,0)
tr = t
tr = tr[-((n+1):(n+m))]
return(tr)
}

Tw <- function(t){ # pontos no aceitos
tw = rep(0,0)
tw = t
tw = tw[-(1:n)]
return(tw)
}

inicial <-function(alfa,beta,gama){ # coloca os valores iniciais no vetor
x0[1] = alfa
x0[2] = beta
x0[3] = gama
return(x0)
}

imprime <-function(N, M, v, W){ # imprime no arquivo saida.txt os dados finais
cat("N =", N, "\nM =", M,"\n\nv\tW(v)\n", file="saida.txt")
D = data.frame(v,W)
write.table(D, file="saida.txt", append = TRUE, row.names=FALSE, sep="\t", col.names=FALSE)
}

tabela = entrada()
n = 45 # numero de t's aceitos
m = 5 # numero de t's no aceitos
i = j = 0 # contadores
t = ts(tabela, 10, n+m) #lista de todos os t's
tr = Tr(t) # lista de t's aceitos
tw = Tw(t) # lista de t's no aceitos
x <- c(1,3,1) # def o estado inicial alfa = 1, beta = 3, gama = 1
S <- matrix(c(1,0,0,0,1,0,0,0,1), ncol=3) # declarando sigma = matriz identidade
alfa = 1 # valores iniciais escolhidos (dentro do espao paramtrico)
beta = 3
gama = 1
N = 100  # numero de passos aproveitados
Aq = 20 # numero de passos para aquecer
x2 = inicial(alfa,beta,gama)
alfas = x2[1] # inicio dos vetores que guardam os valores de alfa, beta e gama aceitos
betas = x2[2]
gamas = x2[3]

while( i+j <= Aq+N){ # calculando Lj e valores alfas, betas e gamas
x1 <= x2
L1 <- L(x1[1], x1[2], x1[3], n, m) # L1 seria o Lj
z <- mvrnorm(1,c(0,0,0),sigma)
x2 <- x1 + z
while(x2[1] <= 0 || 3 > x2[2] || x2[2] > 4 || x2[3] <= 0){
z <- mvrnorm(1,c(0,0,0),sigma)
x2 <- x1 + z
}
L2 = 0
while(L2 == 'NaN' || L2 == 0){ # calculando novo valor Lj+1
z <- mvrnorm(1,c(0,0,0),sigma)
x2 <- x1 + z
while(x2[1] <= 0 || x2[2] < 3 || x2[2] > 4 || x2[3] <= 0){
z <- mvrnorm(1,c(0,0,0),sigma)
x2 <- x1 + z
}
L2 <- L(x2[1], x2[2], x2[3])
}
if(i <= Aq)
i = i + 1
else{
Alfa = min(1,L2/L1)
u <- runif(1,0,1) # probabilidade de Metropolis (aceita ou no os pontos)
if(u < Alfa){
alfas = c(alfas, x2[1])
betas = c(betas, x2[2])
gamas = c(gamas, x2[3])
L1 <- L2
sigma <- c(var(alfas), cov(alfas,betas), cov(alfas,gamas), cov(betas,alfas), var(betas), cov(vbetas,gamas), cov(gamas,alfas), cov(gamas,betas), var(gamas))
dim(sigma) <- c(3,3)
}
j = j + 1
}
}

max = optim(??)

# calculando a integral pelo metodo da media
soma <- c(L(alfas[1], betas[1], gamas[1]))
for(i in 1:N)
soma = c(soma, L(alfas[i], betas[i], gamas[i]))
I <- (1/N)*(sum(soma)) # I = estimativa da integral

M = 100 # numero de pontos para interpolao
v <- seq(0, max$value, l=M) # valores para interpolao

imprime(N,M,v, W)
