/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.util.Utils;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    protected PopupControl popup;
    public static final String COMBO_BOX_STYLE_CLASS = "combo-box-popup";
    private boolean popupNeedsReconfiguring = true;
    private final ComboBoxBase<T> comboBoxBase;
    private TextField textField;
    private EventHandler<MouseEvent> textFieldMouseEventHandler = event -> {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!event.getTarget().equals(comboBoxBase)) {
            comboBoxBase.fireEvent(event.copyFor(comboBoxBase, comboBoxBase));
            event.consume();
        }
    };
    private EventHandler<DragEvent> textFieldDragEventHandler = event -> {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!event.getTarget().equals(comboBoxBase)) {
            comboBoxBase.fireEvent(event.copyFor(comboBoxBase, comboBoxBase));
            event.consume();
        }
    };
    private String initialTextFieldValue = null;

    public ComboBoxPopupControl(ComboBoxBase<T> comboBoxBase, ComboBoxBaseBehavior<T> behavior) {
        super(comboBoxBase, behavior);
        this.comboBoxBase = comboBoxBase;
        TextField textField = this.textField = this.getEditor() != null ? this.getEditableInputNode() : null;
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        comboBoxBase.focusedProperty().addListener((ov, t, hasFocus) -> {
            if (this.getEditor() != null) {
                ((FakeFocusTextField)this.textField).setFakeFocus((boolean)hasFocus);
                if (!hasFocus.booleanValue()) {
                    this.setTextFromTextFieldIntoComboBoxValue();
                }
            }
        });
        comboBoxBase.addEventFilter(KeyEvent.ANY, ke -> {
            if (this.textField == null || this.getEditor() == null) {
                this.handleKeyEvent((KeyEvent)ke, false);
            } else {
                if (ke.getTarget().equals(this.textField)) {
                    return;
                }
                switch (ke.getCode()) {
                    case ESCAPE: 
                    case F10: {
                        break;
                    }
                    case ENTER: {
                        this.handleKeyEvent((KeyEvent)ke, true);
                        break;
                    }
                    default: {
                        this.textField.fireEvent(ke.copyFor(this.textField, this.textField));
                        ke.consume();
                    }
                }
            }
        });
        if (comboBoxBase.getOnInputMethodTextChanged() == null) {
            comboBoxBase.setOnInputMethodTextChanged(event -> {
                if (this.textField != null && this.getEditor() != null && comboBoxBase.getScene().getFocusOwner() == comboBoxBase && this.textField.getOnInputMethodTextChanged() != null) {
                    this.textField.getOnInputMethodTextChanged().handle((InputMethodEvent)event);
                }
            });
        }
        comboBoxBase.setImpl_traversalEngine(new ParentTraversalEngine(comboBoxBase, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return null;
            }
        }));
        this.updateEditable();
    }

    protected abstract Node getPopupContent();

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node content = this.getPopupContent();
        if (content == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void positionAndShowPopup() {
        PopupControl _popup = this.getPopup();
        _popup.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        this.sizePopup();
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        _popup.show(comboBoxBase.getScene().getWindow(), this.snapPosition(p.getX()), this.snapPosition(p.getY()));
        popupContent.requestFocus();
        this.sizePopup();
    }

    private void sizePopup() {
        Node popupContent = this.getPopupContent();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefHeight = this.snapSize(r.prefHeight(0.0));
            double minHeight = this.snapSize(r.minHeight(0.0));
            double maxHeight = this.snapSize(r.maxHeight(0.0));
            double h = this.snapSize(Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight)));
            double prefWidth = this.snapSize(r.prefWidth(h));
            double minWidth = this.snapSize(r.minWidth(h));
            double maxWidth = this.snapSize(r.maxWidth(h));
            double w = this.snapSize(Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth)));
            popupContent.resize(w, h);
        } else {
            popupContent.autosize();
        }
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin(new Skin<Skinnable>(){

                    @Override
                    public Skinnable getSkinnable() {
                        return ComboBoxPopupControl.this.getSkinnable();
                    }

                    @Override
                    public Node getNode() {
                        return ComboBoxPopupControl.this.getPopupContent();
                    }

                    @Override
                    public void dispose() {
                    }
                });
            }

            @Override
            public Styleable getStyleableParent() {
                return ComboBoxPopupControl.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add(COMBO_BOX_STYLE_CLASS);
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(e -> ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide());
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide());
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, t -> ((ComboBoxBase)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE));
        InvalidationListener layoutPosListener = o -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        };
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).sceneProperty().addListener(o -> {
            if (((ObservableValue)o).getValue() == null) {
                this.hide();
            }
        });
    }

    void reconfigurePopup() {
        double newHeight;
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = currentWidth < minWidth ? minWidth : currentWidth;
        double d = newHeight = currentHeight < minHeight ? minHeight : currentHeight;
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }

    protected abstract TextField getEditor();

    protected abstract StringConverter<T> getConverter();

    protected TextField getEditableInputNode() {
        if (this.textField == null && this.getEditor() != null) {
            this.textField = this.getEditor();
            this.textField.setFocusTraversable(false);
            this.textField.promptTextProperty().bind(this.comboBoxBase.promptTextProperty());
            this.textField.tooltipProperty().bind(this.comboBoxBase.tooltipProperty());
            this.initialTextFieldValue = this.textField.getText();
        }
        return this.textField;
    }

    protected void setTextFromTextFieldIntoComboBoxValue() {
        StringConverter<T> c;
        if (this.getEditor() != null && (c = this.getConverter()) != null) {
            T oldValue;
            T value = oldValue = this.comboBoxBase.getValue();
            String text = this.textField.getText();
            if (oldValue == null && (text == null || text.isEmpty())) {
                value = null;
            } else {
                try {
                    value = c.fromString(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(value == null && oldValue == null || value != null && value.equals(oldValue))) {
                this.comboBoxBase.setValue(value);
            }
            this.updateDisplayNode();
        }
    }

    protected void updateDisplayNode() {
        if (this.textField != null && this.getEditor() != null) {
            T value = this.comboBoxBase.getValue();
            StringConverter<T> c = this.getConverter();
            if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
                this.textField.setText(this.initialTextFieldValue);
                this.initialTextFieldValue = null;
            } else {
                String stringValue = c.toString(value);
                if (value == null || stringValue == null) {
                    this.textField.setText("");
                } else if (!stringValue.equals(this.textField.getText())) {
                    this.textField.setText(stringValue);
                }
            }
        }
    }

    private void handleKeyEvent(KeyEvent ke, boolean doConsume) {
        if (ke.getCode() == KeyCode.ENTER) {
            this.setTextFromTextFieldIntoComboBoxValue();
            if (doConsume && this.comboBoxBase.getOnAction() != null) {
                ke.consume();
            } else {
                this.forwardToParent(ke);
            }
        } else if (ke.getCode() == KeyCode.F4) {
            if (ke.getEventType() == KeyEvent.KEY_RELEASED) {
                if (this.comboBoxBase.isShowing()) {
                    this.comboBoxBase.hide();
                } else {
                    this.comboBoxBase.show();
                }
            }
            ke.consume();
        }
    }

    private void forwardToParent(KeyEvent event) {
        if (this.comboBoxBase.getParent() != null) {
            this.comboBoxBase.getParent().fireEvent(event);
        }
    }

    protected void updateEditable() {
        final TextField newTextField = this.getEditor();
        if (this.getEditor() == null) {
            if (this.textField != null) {
                this.textField.removeEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
                this.textField.removeEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
                this.comboBoxBase.setInputMethodRequests(null);
            }
        } else if (newTextField != null) {
            newTextField.addEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
            newTextField.addEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
            this.comboBoxBase.setInputMethodRequests(new ExtendedInputMethodRequests(){

                @Override
                public Point2D getTextLocation(int offset) {
                    return newTextField.getInputMethodRequests().getTextLocation(offset);
                }

                @Override
                public int getLocationOffset(int x, int y) {
                    return newTextField.getInputMethodRequests().getLocationOffset(x, y);
                }

                @Override
                public void cancelLatestCommittedText() {
                    newTextField.getInputMethodRequests().cancelLatestCommittedText();
                }

                @Override
                public String getSelectedText() {
                    return newTextField.getInputMethodRequests().getSelectedText();
                }

                @Override
                public int getInsertPositionOffset() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getInsertPositionOffset();
                }

                @Override
                public String getCommittedText(int begin, int end) {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedText(begin, end);
                }

                @Override
                public int getCommittedTextLength() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedTextLength();
                }
            });
        }
        this.textField = newTextField;
    }

    public static final class FakeFocusTextField
    extends TextField {
        @Override
        public void requestFocus() {
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        }

        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return this.getParent();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }
}

