/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.pt;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt_PT extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Hora Padr\u00e3o das Ilhas Malvinas",
               "FIST",
               "Hora de Ver\u00e3o das Ilhas Malvinas",
               "FIST",
               "Hora das Ilhas Malvinas",
               "FIT",
            };
        final String[] Iran = new String[] {
               "Hora Padr\u00e3o do Ir\u00e3o",
               "IST",
               "Hora de Ver\u00e3o do Ir\u00e3o",
               "IDT",
               "Hora do Ir\u00e3o",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Hora Padr\u00e3o de Cabo Verde",
               "CVST",
               "Hora de Ver\u00e3o de Cabo Verde",
               "CVST",
               "Hora de Cabo Verde",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Hora do Meridiano de Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Hora Padr\u00e3o de Omsk",
               "OST",
               "Hora de Ver\u00e3o de Omsk",
               "OST",
               "Hora de Omsk",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora Padr\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HAST",
               "Hora de Ver\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HADT",
               "Hora do Hava\u00ed e Ilhas Aleutas",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Mianmar",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Hora Padr\u00e3o de Sacalina",
               "SST",
               "Hora de Ver\u00e3o de Sacalina",
               "SST",
               "Hora de Sacalina",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Hora Padr\u00e3o de Yakutsk",
               "YST",
               "Hora de Ver\u00e3o de Yakutsk",
               "YST",
               "Hora de Yakutsk",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "Hora Padr\u00e3o de Paraguai",
               "PST",
               "Hora de Ver\u00e3o de Paraguai",
               "PST",
               "Hora de Paraguai",
               "PT",
            };
        final String[] Nepal = new String[] {
               "Hora do Nepal",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "Hora das Ilhas Maldivas",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora Padr\u00e3o do Turquemenist\u00e3o",
               "TST",
               "Hora de Ver\u00e3o do Turquemenist\u00e3o",
               "TST",
               "Hora do Turquemenist\u00e3o",
               "TT",
            };
        final String[] Truk = new String[] {
               "Hora de Truk",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Hora Padr\u00e3o do Jap\u00e3o",
               "JST",
               "Hora de Ver\u00e3o do Jap\u00e3o",
               "JDT",
               "Hora do Jap\u00e3o",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Hora Padr\u00e3o de Vladivostok",
               "VST",
               "Hora de Ver\u00e3o de Vladivostok",
               "VST",
               "Hora de Vladivostok",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Hora Padr\u00e3o da Europa Ocidental",
               "WET",
               "Hora de Ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hora da Europa Ocidental",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Hora Padr\u00e3o do Bangladesh",
               "BST",
               "Hora de Ver\u00e3o do Bangladesh",
               "BST",
               "Hora do Bangladesh",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Leste",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Hora Padr\u00e3o da Groenl\u00e2ndia Ocidental",
               "WGST",
               "Hora de Ver\u00e3o da Groenl\u00e2ndia Ocidental",
               "WGST",
               "Hora da Groenl\u00e2ndia Ocidental",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Hora das Marquesas",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "Hora Padr\u00e3o da Col\u00f4mbia",
               "CST",
               "Hora de Ver\u00e3o da Col\u00f4mbia",
               "CST",
               "Hora da Col\u00f4mbia",
               "CT",
            };
        final String[] Wake = new String[] {
               "Hora das Ilhas Wake",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "Hora de Suriname",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "Hora Padr\u00e3o do Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "Hora Padr\u00e3o de Singapura",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Hora Padr\u00e3o de Hovd",
               "HST",
               "Hora de Ver\u00e3o de Hovd",
               "HST",
               "Hora de Hovd",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Hora Padr\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora de Ver\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora do Amazonas",
               "\u2205\u2205\u2205",
            };
        final String[] Tokelau = new String[] {
               "Hora de Toquelau",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora das Ilhas Gilbert",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "Hora Padr\u00e3o do Paquist\u00e3o",
               "PST",
               "Hora de Ver\u00e3o do Paquist\u00e3o",
               "PST",
               "Hora do Paquist\u00e3o",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Hora Padr\u00e3o de Ulan Bator",
               "UBST",
               "Hora de Ver\u00e3o de Ulan Bator",
               "UBST",
               "Hora de Ulan Bator",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "Hora Padr\u00e3o da Nova Caled\u00f3nia",
               "NCST",
               "Hora de Ver\u00e3o da Nova Caled\u00f3nia",
               "NCST",
               "Hora da Nova Caled\u00f3nia",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Hora Padr\u00e3o do Pac\u00edfico",
               "PST",
               "Hora de Ver\u00e3o do Pac\u00edfico",
               "PDT",
               "Hora do Pac\u00edfico",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora Padr\u00e3o da Argentina Ocidental",
               "WAST",
               "Hora de Ver\u00e3o da Argentina Ocidental",
               "WAST",
               "Hora da Argentina Ocidental",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Hora da Guiana Francesa",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora Padr\u00e3o da Groel\u00e2ndia Oriental",
               "EGST",
               "Hora de Ver\u00e3o da Groel\u00e2ndia Oriental",
               "EGST",
               "Hora da Groel\u00e2ndia Oriental",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Hora da Ilha de Natal",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Hora Padr\u00e3o de Volgogrado",
               "VST",
               "Hora de Ver\u00e3o de Volgogrado",
               "VST",
               "Hora de Volgogrado",
               "VT",
            };
        final String[] Korea = new String[] {
               "Hora Padr\u00e3o da Coreia",
               "KST",
               "Hora de Ver\u00e3o da Coreia",
               "KDT",
               "Hora da Coreia",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Hora Padr\u00e3o de Vanuatu",
               "VST",
               "Hora de Ver\u00e3o de Vanuatu",
               "VST",
               "Hora de Vanuatu",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Hora Padr\u00e3o da Argentina",
               "AST",
               "Hora de Ver\u00e3o da Argentina",
               "AST",
               "Hora da Argentina",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Hora Padr\u00e3o de Lord Howe",
               "LHST",
               "Hora de Ver\u00e3o de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "Hora do Quirguizist\u00e3o",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "Hora Padr\u00e3o da Ar\u00e1bia",
               "AST",
               "Hora de Ver\u00e3o da Ar\u00e1bia",
               "ADT",
               "Hora da Ar\u00e1bia",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora Padr\u00e3o da Austr\u00e1lia Oriental",
               "AEST",
               "Hora de Ver\u00e3o da Austr\u00e1lia Oriental",
               "AEDT",
               "Hora da Austr\u00e1lia Oriental",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Hora Padr\u00e3o de Irkutsk",
               "IST",
               "Hora de Ver\u00e3o de Irkutsk",
               "IST",
               "Hora de Irkutsk",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Hora Padr\u00e3o das Ilhas Maur\u00edcias",
               "MST",
               "Hora de Ver\u00e3o das Ilhas Maur\u00edcias",
               "MST",
               "Hora das Ilhas Maur\u00edcias",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora do Oceano \u00cdndico",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Hora Padr\u00e3o de Choibalsan",
               "CST",
               "Hora de Ver\u00e3o de Choibalsan",
               "CST",
               "Hora de Choibalsan",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora Padr\u00e3o Oriental",
               "EST",
               "Hora de Ver\u00e3o Oriental",
               "EDT",
               "Hora Oriental",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Hora Padr\u00e3o da Austr\u00e1lia Ocidental",
               "AWST",
               "Hora de Ver\u00e3o da Austr\u00e1lia Ocidental",
               "AWDT",
               "Hora da Austr\u00e1lia Ocidental",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora Padr\u00e3o da Austr\u00e1lia Central Ocidental",
               "ACWST",
               "Hora de Ver\u00e3o da Austr\u00e1lia Central Ocidental",
               "ACWDT",
               "Hora da Austr\u00e1lia Central Ocidental",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora Padr\u00e3o de Krasnoyarsk",
               "KST",
               "Hora de Ver\u00e3o de Krasnoyarsk",
               "KST",
               "Hora de Krasnoiarsk",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora da Indon\u00e9sia Oriental",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Hora da Venezuela",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "Hora do Bot\u00e3o",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Hora Padr\u00e3o de Fernando de Noronha",
               "FNST",
               "Hora de Ver\u00e3o de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "Hora da Mal\u00e1sia",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora Padr\u00e3o de Novosibirsk",
               "NST",
               "Hora de Ver\u00e3o de Novosibirsk",
               "NST",
               "Hora de Novosibirsk",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Hora Padr\u00e3o da Montanha",
               "MST",
               "Hora de Ver\u00e3o da Montanha",
               "MDT",
               "Hora da Montanha",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Hora da Ilha Norfolque",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Hora Padr\u00e3o do Alasca",
               "AKST",
               "Hora de Ver\u00e3o do Alasca",
               "AKDT",
               "Hora do Alasca",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Hora Padr\u00e3o da Arm\u00e9nia",
               "AST",
               "Hora de Ver\u00e3o da Arm\u00e9nia",
               "AST",
               "Hora da Arm\u00e9nia",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora das Ilhas Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Hora Padr\u00e3o da Austr\u00e1lia Central",
               "ACST",
               "Hora de Ver\u00e3o da Austr\u00e1lia Central",
               "ACDT",
               "Hora da Austr\u00e1lia Central",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Hora Padr\u00e3o dos A\u00e7ores",
               "AZOT",
               "Hora de Ver\u00e3o dos A\u00e7ores",
               "AZOST",
               "Hora dos A\u00e7ores",
               "AZOT",
            };
        final String[] Reunion = new String[] {
               "Hora das Ilhas de Reuni\u00e3o",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Hora da Indochina",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Hora do Equador",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Hora Padr\u00e3o de Magadan",
               "MST",
               "Hora de Ver\u00e3o de Magadan",
               "MST",
               "Hora de Magadan",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Hora Padr\u00e3o de Chatham",
               "CST",
               "Hora de Ver\u00e3o de Chatham",
               "CDT",
               "Hora de Chatham",
               "CT",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Hora Padr\u00e3o de Cuba",
               "CST",
               "Hora de Ver\u00e3o de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora Padr\u00e3o da \u00c1frica Ocidental",
               "WAST",
               "Hora de Ver\u00e3o da \u00c1frica Ocidental",
               "WAST",
               "Hora da \u00c1frica Ocidental",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Hora Padr\u00e3o de Moscovo",
               "MST",
               "Hora de Ver\u00e3o de Moscovo",
               "MST",
               "Hora de Moscovo",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora da Papua Nova Guin\u00e9",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora do Casaquist\u00e3o Oriental",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Hora Padr\u00e3o da Nova Zel\u00e2ndia",
               "NZST",
               "Hora de Ver\u00e3o da Nova Zel\u00e2ndia",
               "NZDT",
               "Hora da Nova Zel\u00e2ndia",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora Padr\u00e3o de Hong Kong",
               "HKST",
               "Hora de Ver\u00e3o de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Hora Padr\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de Ver\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de Bras\u00edlia",
               "\u2205\u2205\u2205",
            };
        final String[] Taipei = new String[] {
               "Hora Padr\u00e3o de Taipei",
               "TST",
               "Hora de Ver\u00e3o de Taipei",
               "TDT",
               "Hora de Taipei",
               "TT",
            };
        final String[] Cocos = new String[] {
               "Hora das Ilhas Cocos",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Hora do Afeganist\u00e3o",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora da Indon\u00e9sia Ocidental",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Hora do Brunei Darussalam",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora das Ilhas F\u00e9nix",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Hora das Ilhas Seicheles",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "Hora da \u00c1frica Central",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "Hora Padr\u00e3o da Ilha de P\u00e1scoa",
               "EIST",
               "Hora de Ver\u00e3o da Ilha de P\u00e1scoa",
               "EIST",
               "Hora da Ilha de P\u00e1scoa",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "Hora da Georgia do Sul",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora da Indon\u00e9sia Central",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "Hora Padr\u00e3o das Filipinas",
               "PST",
               "Hora de Ver\u00e3o das Filipinas",
               "PST",
               "Hora das Filipinas",
               "PT",
            };
        final String[] Georgia = new String[] {
               "Hora Padr\u00e3o da Georgia",
               "GST",
               "Hora de Ver\u00e3o da Georgia",
               "GST",
               "Hora da Ge\u00f3rgia",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Hora da Bol\u00edvia",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Hora Padr\u00e3o de Peru",
               "PST",
               "Hora de Ver\u00e3o de Peru",
               "PST",
               "Hora de Peru",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Hora de Chamarro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Hora Padr\u00e3o da Terra Nova",
               "NST",
               "Hora de Ver\u00e3o da Terra Nova",
               "NDT",
               "Hora da Terra Nova",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Hora das Ilhas Line",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Hora Padr\u00e3o das Ilhas Cook",
               "CIST",
               "Hora Interm\u00e9dia de Ver\u00e3o das Ilhas Cook",
               "CIHST",
               "Hora das Ilhas Cook",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Hora Padr\u00e3o Central",
               "CST",
               "Hora de Ver\u00e3o Central",
               "CDT",
               "Hora Central",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora da \u00c1frica Oriental",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Hora Padr\u00e3o do Arzeibaij\u00e3o",
               "AST",
               "Hora de Ver\u00e3o do Arzeibaij\u00e3o",
               "AST",
               "Hora do Arzeibaij\u00e3o",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora Padr\u00e3o de Ecaterimburgo",
               "YST",
               "Hora de Ver\u00e3o de Ecaterimburgo",
               "YST",
               "Hora de Ecaterimburgo",
               "YT",
            };
        final String[] China = new String[] {
               "Hora Padr\u00e3o da China",
               "CST",
               "Hora de Ver\u00e3o da China",
               "CDT",
               "Hora da China",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Hora Padr\u00e3o da Samoa",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Hora Padr\u00e3o de Tonga",
               "TST",
               "Hora de Ver\u00e3o de Tonga",
               "TST",
               "Hora de Tonga",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Hora das Ilhas Salom\u00e3o",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora da \u00c1frica do Sul",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Hora de Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Hora da Ant\u00e1rtida e dos Territ\u00f3rios Franceses do Sul",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "Hora Padr\u00e3o do Chile",
               "CST",
               "Hora de Ver\u00e3o do Chile",
               "CST",
               "Hora do Chile",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora do Casaquist\u00e3o Ocidental",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Hora Padr\u00e3o de Israel",
               "IST",
               "Hora de Ver\u00e3o de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Hora do Tajiquist\u00e3o",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "Hora do Tahiti",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora Padr\u00e3o de Pierre e Miquelon",
               "PMST",
               "Hora de Ver\u00e3o de Pierre e Miquelon",
               "PMDT",
               "Hora de Pierre e Miquelon",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "Hora Padr\u00e3o das Ilhas Fiji",
               "FST",
               "Hora de Ver\u00e3o das Ilhas Fiji",
               "FST",
               "Hora das Ilhas Fiji",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Hora Padr\u00e3o da Europa Central",
               "CET",
               "Hora de Ver\u00e3o da Europa Central",
               "CEST",
               "Hora da Europa Central",
               "CET",
            };
        final String[] India = new String[] {
               "Hora Padr\u00e3o da \u00cdndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis e Futuna",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora Padr\u00e3o do Uzbequist\u00e3o",
               "UST",
               "Hora de Ver\u00e3o do Uzbequist\u00e3o",
               "UST",
               "Hora do Uzbequist\u00e3o",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora Padr\u00e3o da Europa Oriental",
               "EET",
               "Hora de Ver\u00e3o da Europa Oriental",
               "EEST",
               "Hora da Europa Oriental",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Hora Padr\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hora de Ver\u00e3o do Atl\u00e2ntico",
               "ADT",
               "Hora do Atl\u00e2ntico",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Hora Padr\u00e3o de Uruguai",
               "UST",
               "Hora de Ver\u00e3o de Uruguai",
               "UST",
               "Hora de Uruguai",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
