/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sv;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "falklands\u00f6arnas normaltid",
               "FIST",
               "falklands\u00f6arnas sommartid",
               "FIST",
               "falklands\u00f6arnas tid",
               "FIT",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "IST",
               "iransk sommartid",
               "IDT",
               "iransk tid",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verdenormaltid",
               "CVST",
               "Kap Verdesommartid",
               "CVST",
               "Kap Verdetid",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Greenwichtid",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "Ponapetid",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Omsknormaltid",
               "OST",
               "Omsksommartid",
               "OST",
               "Omsktid",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Kosraetid",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Honolulunormaltid",
               "HAST",
               "Honolulusommartid",
               "HADT",
               "Honolulutid",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "burmesisk tid",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinnormaltid",
               "SST",
               "Sachalinsommartid",
               "SST",
               "Sachalintid",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsknormaltid",
               "YST",
               "Jakutsksommartid",
               "YST",
               "Jakutsktid",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gambiertid",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "PST",
               "paraguayansk sommartid",
               "PST",
               "paraguayansk tid",
               "PT",
            };
        final String[] Nepal = new String[] {
               "nepalesisk tid",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "Maldivernatid",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "TST",
               "turkmensk sommartid",
               "TST",
               "turkmensk tid",
               "TT",
            };
        final String[] Truk = new String[] {
               "Truktid",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Japan, normaltid",
               "JST",
               "Japan, sommartid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoknormaltid",
               "VST",
               "Vladivostoksommartid",
               "VST",
               "Vladivostoktid",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "v\u00e4steuropeisk normaltid",
               "WET",
               "v\u00e4steuropeisk sommartid",
               "WEST",
               "v\u00e4steuropeisk tid",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "BST",
               "bangladeshisk sommartid",
               "BST",
               "bangladeshisk tid",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "\u00f6sttimorisk tid",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "v\u00e4stgr\u00f6nl\u00e4ndsk normaltid",
               "WGST",
               "v\u00e4stgr\u00f6nl\u00e4ndsk sommartid",
               "WGST",
               "v\u00e4stgr\u00f6nl\u00e4ndsk tid",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Marquesastid",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "colombiansk normaltid",
               "CST",
               "colombiansk sommartid",
               "CST",
               "colombiansk tid",
               "CT",
            };
        final String[] Wake = new String[] {
               "Waketid",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "Surinamtid",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "Persiska vikentid",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "Singaporetid",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Hovdnormaltid",
               "HST",
               "Hovdsommartid",
               "HST",
               "Hovdtid",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Amazonasnormaltid",
               "AST",
               "Amazonassommartid",
               "AST",
               "amazonastid",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "Tokelautid",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Kiribatitid",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "PST",
               "pakistansk sommartid",
               "PST",
               "pakistansk tid",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-normaltid",
               "UBST",
               "Ulaanbaatar-sommartid",
               "UBST",
               "Ulaanbaatar-tid",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Palautid",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "Nya Kaledoniennormaltid",
               "NCST",
               "Nya Kaledoniensommartid",
               "NCST",
               "Nya Kaledonientid",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Naurutid",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific, normaltid",
               "PST",
               "Pacific, sommartid",
               "PDT",
               "v\u00e4stnordamerikansk tid",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "v\u00e4stargentinsk normaltid",
               "WAST",
               "v\u00e4stargentinsk sommartid",
               "WAST",
               "v\u00e4stargentinsk tid",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1pagostid",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Franska Guyanatid",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u00f6stgr\u00f6nl\u00e4ndsk normaltid",
               "EGST",
               "\u00f6stgr\u00f6nl\u00e4ndsk sommartid",
               "EGST",
               "\u00f6stgr\u00f6nl\u00e4ndsk tid",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Jul\u00f6ns tid",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Volgogradnormaltid",
               "VST",
               "Volgogradsommartid",
               "VST",
               "Volgogradtid",
               "VT",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "KST",
               "koreansk sommartid",
               "KDT",
               "koreansk tid",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatunormaltid",
               "VST",
               "Vanuatusommartid",
               "VST",
               "Vanuatutid",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u00f6stargentinsk normaltid",
               "AST",
               "\u00f6stargentinsk sommartid",
               "AST",
               "\u00f6stargentinsk tid",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howenormaltid",
               "LHST",
               "Lord Howesommartid",
               "LHDT",
               "Lord Howetid",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Syowatid",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizisk tid",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "saudiarabisk normaltid",
               "AST",
               "saudiarabisk sommartid",
               "ADT",
               "saudiarabisk tid",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f6staustralisk normaltid",
               "AEST",
               "\u00f6staustralisk sommartid",
               "AEDT",
               "\u00f6staustralisk tid",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsknormaltid",
               "IST",
               "Irkutsksommartid",
               "IST",
               "Irkutsktid",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiustid",
               "MST",
               "Mauritiussommartid",
               "MST",
               "Mauritiustid",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Brittiska Indiska ocean\u00f6arnas tid",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Tjojbalsannormaltid",
               "CST",
               "Tjojbalsansommartid",
               "CST",
               "Tjojbalsantid",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern, normaltid",
               "EST",
               "Eastern, sommartid",
               "EDT",
               "\u00f6stnordamerikansk tid",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "v\u00e4staustralisk normaltid",
               "AWST",
               "v\u00e4staustralisk sommartid",
               "AWDT",
               "v\u00e4staustralisk tid",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "v\u00e4stcentralaustralisk normaltid",
               "ACWST",
               "v\u00e4stcentralaustralisk sommartid",
               "ACWDT",
               "v\u00e4stcentralaustralisk tid",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsknormaltid",
               "KST",
               "Krasnojarsksommartid",
               "KST",
               "Krasnojarsktid",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f6stindonesisk tid",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "venezuelansk tid",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairntid",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "bhutansk tid",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhanormaltid",
               "FNST",
               "Fernando de Noronhasommartid",
               "FNST",
               "Fernando de Noronhatid",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "malaysisk tid",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsknormaltid",
               "NST",
               "Novosibirsksommartid",
               "NST",
               "Novosibirsktid",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain, normaltid",
               "MST",
               "Mountain, sommartid",
               "MDT",
               "Klippiga Bergentid",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk\u00f6ns tid",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Niuetid",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "Vostoktid",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Alaska, normaltid",
               "AKST",
               "Alaska, sommartid",
               "AKDT",
               "alaskatid",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "armenisk normaltid",
               "AST",
               "armenisk somartid",
               "AST",
               "armenisk tid",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall\u00f6arnas tid",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "centralaustralisk normaltid",
               "ACST",
               "centralaustralisk sommartid",
               "ACDT",
               "centralaustralisk tid",
               "CAT",
            };
        final String[] Azores = new String[] {
               "azorisk normaltid",
               "AST",
               "azorisk sommartid",
               "AST",
               "azorisk tid",
               "AT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9uniontid",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "ecuadoriansk tid",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Magadannormaltid",
               "MST",
               "Magadansommartid",
               "MST",
               "Magadantid",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Chathamnormaltid",
               "CST",
               "Chathamsommartid",
               "CDT",
               "Chathamtid",
               "CT",
            };
        final String[] Davis = new String[] {
               "Davistid",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "kubansk normaltid",
               "CST",
               "kubansk sommartid",
               "CDT",
               "kubansk tid",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "v\u00e4stafrikansk normaltid",
               "WAST",
               "v\u00e4stafrikansk sommartid",
               "WAST",
               "v\u00e4stafrikansk tid",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Moskvanormaltid",
               "MST",
               "Moskvasommartid",
               "MST",
               "Moskvatid",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nya Guineas tid",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00f6st kazakstansk tid",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "nyzeel\u00e4ndsk normaltid",
               "NZST",
               "nyzeel\u00e4ndsk sommartid",
               "NZDT",
               "nyzeel\u00e4ndsk tid",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongnormaltid",
               "HKST",
               "Hongkongsommartid",
               "HKST",
               "Hongkongtid",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Brasilianormaltid",
               "BST",
               "Brasiliasommartid",
               "BST",
               "brasiliansk tid",
               "BT",
            };
        final String[] Taipei = new String[] {
               "Taipeinormaltid",
               "TST",
               "Taipeisommartid",
               "TDT",
               "Taipeitid",
               "TT",
            };
        final String[] Cocos = new String[] {
               "Keeling\u00f6arnas tid",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "afghansk tid",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "v\u00e4stindonesisk tid",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Bruneitid",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Enderburytid",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Seychellernatid",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "centralafrikansk tid",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "P\u00e5sk\u00f6ns normaltid",
               "EIST",
               "P\u00e5sk\u00f6ns sommartid",
               "EIST",
               "P\u00e5sk\u00f6ns tid",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "sydgeorgisk tid",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "centralindonesisk tid",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "PST",
               "filippinsk sommartid",
               "PST",
               "filippinsk tid",
               "PT",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "GST",
               "georgisk sommartid",
               "GST",
               "georgisk tid",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "boliviansk tid",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "peruansk normalid",
               "PST",
               "peruansk sommartid",
               "PST",
               "peruansk tid",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Chamorrotid",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland, normaltid",
               "NST",
               "Newfoundland, sommartid",
               "NDT",
               "Newfoundlandtid",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Line\u00f6arnas tid",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Cook\u00f6arnas normaltid",
               "CIST",
               "Cook\u00f6arnas sommartid",
               "CIHST",
               "Cook\u00f6arnas tid",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Central, normaltid",
               "CST",
               "Central, sommartid",
               "CDT",
               "centralnordamerikansk tid",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f6stafrikansk tid",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzjansk normaltid",
               "AST",
               "azerbajdzjansk sommartid",
               "AST",
               "azerbajdzjansk tid",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Guyanatid",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgnormaltid",
               "YST",
               "Jekaterinburgsommartid",
               "YST",
               "Jekaterinburgtid",
               "YT",
            };
        final String[] China = new String[] {
               "Kina, normaltid",
               "CST",
               "Kina, sommartid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Samoa = new String[] {
               "samoansk tid",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Tonganormaltid",
               "TST",
               "Tongasommmartid",
               "TST",
               "Tongatid",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Salomon\u00f6arnas tid",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "sydafrikansk tid",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarietid",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Franska Sydterritoriernas tid",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "CST",
               "chilensk sommartid",
               "CST",
               "chilensk tid",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "v\u00e4st kazakstansk tid",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Israel, normaltid",
               "IST",
               "Israel, sommartid",
               "IDT",
               "israelisk tid",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjikistantid",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "Tahititid",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "Mawsontid",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre och Miquelonnormalid",
               "PMST",
               "Pierre och Miquelonsommartid",
               "PMDT",
               "Pierre och Miquelontid",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "Fijinormaltid",
               "FST",
               "Fijisommartid",
               "FST",
               "Fijitid",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Rotheratid",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Centraleuropa, normaltid",
               "CET",
               "Centraleuropa, sommartid",
               "CEST",
               "centraleuropeisk tid",
               "CET",
            };
        final String[] India = new String[] {
               "indisk tid",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u2019Urville-tid",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "Wallis- och Futuna\u00f6arnas tid",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalutid",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekisk normaltid",
               "UST",
               "uzbekisk sommartid",
               "UST",
               "uzbekisk tid",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00d6steuropa, normaltid",
               "EET",
               "\u00d6steuropa, sommartid",
               "EEST",
               "\u00f6steuropeisk tid",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlantic, normaltid",
               "AST",
               "Atlantic, sommartid",
               "ADT",
               "nordamerikansk atlanttid",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "UST",
               "uruguayansk sommartid",
               "UST",
               "uruguayansk tid",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
