/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.InvalidSyntaxException;
import argo.saj.JsonListener;
import argo.saj.PositionTrackingPushbackReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public final class SajParser {
    public void func_27463_a(Reader p_27463_1_, JsonListener p_27463_2_) throws InvalidSyntaxException, IOException {
        PositionTrackingPushbackReader positionTrackingPushbackReader = new PositionTrackingPushbackReader(p_27463_1_);
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        switch (c) {
            case '{': {
                positionTrackingPushbackReader.func_27334_a(c);
                p_27463_2_.func_27195_b();
                this.func_27453_b(positionTrackingPushbackReader, p_27463_2_);
                break;
            }
            case '[': {
                positionTrackingPushbackReader.func_27334_a(c);
                p_27463_2_.func_27195_b();
                this.func_27455_a(positionTrackingPushbackReader, p_27463_2_);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected either [ or { but got [" + c + "].", positionTrackingPushbackReader);
            }
        }
        int n = this.func_27448_l(positionTrackingPushbackReader);
        if (n != -1) {
            throw new InvalidSyntaxException("Got unexpected trailing character [" + (char)n + "].", positionTrackingPushbackReader);
        }
        p_27463_2_.func_27204_c();
    }

    private void func_27455_a(PositionTrackingPushbackReader p_27455_1_, JsonListener p_27455_2_) throws InvalidSyntaxException, IOException {
        char c = (char)this.func_27448_l(p_27455_1_);
        if (c != '[') {
            throw new InvalidSyntaxException("Expected object to start with [ but got [" + c + "].", p_27455_1_);
        }
        p_27455_2_.func_27200_d();
        char c2 = (char)this.func_27448_l(p_27455_1_);
        p_27455_1_.func_27334_a(c2);
        if (c2 != ']') {
            this.func_27464_d(p_27455_1_, p_27455_2_);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c3 = (char)this.func_27448_l(p_27455_1_);
            switch (c3) {
                case ',': {
                    this.func_27464_d(p_27455_1_, p_27455_2_);
                    continue block4;
                }
                case ']': {
                    bl = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or ] but got [" + c3 + "].", p_27455_1_);
        }
        p_27455_2_.func_27197_e();
    }

    private void func_27453_b(PositionTrackingPushbackReader p_27453_1_, JsonListener p_27453_2_) throws InvalidSyntaxException, IOException {
        char c = (char)this.func_27448_l(p_27453_1_);
        if (c != '{') {
            throw new InvalidSyntaxException("Expected object to start with { but got [" + c + "].", p_27453_1_);
        }
        p_27453_2_.func_27194_f();
        char c2 = (char)this.func_27448_l(p_27453_1_);
        p_27453_1_.func_27334_a(c2);
        if (c2 != '}') {
            this.func_27449_c(p_27453_1_, p_27453_2_);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c3 = (char)this.func_27448_l(p_27453_1_);
            switch (c3) {
                case ',': {
                    this.func_27449_c(p_27453_1_, p_27453_2_);
                    continue block4;
                }
                case '}': {
                    bl = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or } but got [" + c3 + "].", p_27453_1_);
        }
        p_27453_2_.func_27203_g();
    }

    private void func_27449_c(PositionTrackingPushbackReader p_27449_1_, JsonListener p_27449_2_) throws InvalidSyntaxException, IOException {
        char c = (char)this.func_27448_l(p_27449_1_);
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected object identifier to begin with [\"] but got [" + c + "].", p_27449_1_);
        }
        p_27449_1_.func_27334_a(c);
        p_27449_2_.func_27205_a(this.func_27452_i(p_27449_1_));
        char c2 = (char)this.func_27448_l(p_27449_1_);
        if (c2 != ':') {
            throw new InvalidSyntaxException("Expected object identifier to be followed by : but got [" + c2 + "].", p_27449_1_);
        }
        this.func_27464_d(p_27449_1_, p_27449_2_);
        p_27449_2_.func_27199_h();
    }

    private void func_27464_d(PositionTrackingPushbackReader p_27464_1_, JsonListener p_27464_2_) throws InvalidSyntaxException, IOException {
        char c = (char)this.func_27448_l(p_27464_1_);
        switch (c) {
            case '\"': {
                p_27464_1_.func_27334_a(c);
                p_27464_2_.func_27198_c(this.func_27452_i(p_27464_1_));
                break;
            }
            case 't': {
                char[] cArray = new char[3];
                int n = p_27464_1_.func_27336_b(cArray);
                if (n != 3 || cArray[0] != 'r' || cArray[1] != 'u' || cArray[2] != 'e') {
                    p_27464_1_.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 't' to be followed by [[r, u, e]], but got [" + Arrays.toString(cArray) + "].", p_27464_1_);
                }
                p_27464_2_.func_27196_i();
                break;
            }
            case 'f': {
                char[] cArray = new char[4];
                int n = p_27464_1_.func_27336_b(cArray);
                if (n != 4 || cArray[0] != 'a' || cArray[1] != 'l' || cArray[2] != 's' || cArray[3] != 'e') {
                    p_27464_1_.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 'f' to be followed by [[a, l, s, e]], but got [" + Arrays.toString(cArray) + "].", p_27464_1_);
                }
                p_27464_2_.func_27193_j();
                break;
            }
            case 'n': {
                char[] cArray = new char[3];
                int n = p_27464_1_.func_27336_b(cArray);
                if (n != 3 || cArray[0] != 'u' || cArray[1] != 'l' || cArray[2] != 'l') {
                    p_27464_1_.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 'n' to be followed by [[u, l, l]], but got [" + Arrays.toString(cArray) + "].", p_27464_1_);
                }
                p_27464_2_.func_27202_k();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                p_27464_1_.func_27334_a(c);
                p_27464_2_.func_27201_b(this.func_27459_a(p_27464_1_));
                break;
            }
            case '{': {
                p_27464_1_.func_27334_a(c);
                this.func_27453_b(p_27464_1_, p_27464_2_);
                break;
            }
            case '[': {
                p_27464_1_.func_27334_a(c);
                this.func_27455_a(p_27464_1_, p_27464_2_);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Invalid character at start of value [" + c + "].", p_27464_1_);
            }
        }
    }

    private String func_27459_a(PositionTrackingPushbackReader p_27459_1_) throws IOException, InvalidSyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27459_1_.func_27333_c();
        if ('-' == c) {
            stringBuilder.append('-');
        } else {
            p_27459_1_.func_27334_a(c);
        }
        stringBuilder.append(this.func_27451_b(p_27459_1_));
        return stringBuilder.toString();
    }

    private String func_27451_b(PositionTrackingPushbackReader p_27451_1_) throws IOException, InvalidSyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27451_1_.func_27333_c();
        if ('0' == c) {
            stringBuilder.append('0');
            stringBuilder.append(this.func_27462_f(p_27451_1_));
            stringBuilder.append(this.func_27454_g(p_27451_1_));
        } else {
            p_27451_1_.func_27334_a(c);
            stringBuilder.append(this.func_27460_c(p_27451_1_));
            stringBuilder.append(this.func_27456_e(p_27451_1_));
            stringBuilder.append(this.func_27462_f(p_27451_1_));
            stringBuilder.append(this.func_27454_g(p_27451_1_));
        }
        return stringBuilder.toString();
    }

    private char func_27460_c(PositionTrackingPushbackReader p_27460_1_) throws IOException, InvalidSyntaxException {
        char c;
        char c2 = (char)p_27460_1_.func_27333_c();
        switch (c2) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c2;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c2 + "].", p_27460_1_);
            }
        }
        return c;
    }

    private char func_27458_d(PositionTrackingPushbackReader p_27458_1_) throws IOException, InvalidSyntaxException {
        char c;
        char c2 = (char)p_27458_1_.func_27333_c();
        switch (c2) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c2;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c2 + "].", p_27458_1_);
            }
        }
        return c;
    }

    private String func_27456_e(PositionTrackingPushbackReader p_27456_1_) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block3: while (!bl) {
            char c = (char)p_27456_1_.func_27333_c();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    stringBuilder.append(c);
                    continue block3;
                }
            }
            bl = true;
            p_27456_1_.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27462_f(PositionTrackingPushbackReader p_27462_1_) throws IOException, InvalidSyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27462_1_.func_27333_c();
        if (c == '.') {
            stringBuilder.append('.');
            stringBuilder.append(this.func_27458_d(p_27462_1_));
            stringBuilder.append(this.func_27456_e(p_27462_1_));
        } else {
            p_27462_1_.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27454_g(PositionTrackingPushbackReader p_27454_1_) throws IOException, InvalidSyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27454_1_.func_27333_c();
        if (c == '.' || c == 'E') {
            stringBuilder.append('E');
            stringBuilder.append(this.func_27461_h(p_27454_1_));
            stringBuilder.append(this.func_27458_d(p_27454_1_));
            stringBuilder.append(this.func_27456_e(p_27454_1_));
        } else {
            p_27454_1_.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27461_h(PositionTrackingPushbackReader p_27461_1_) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27461_1_.func_27333_c();
        if (c == '+' || c == '-') {
            stringBuilder.append(c);
        } else {
            p_27461_1_.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27452_i(PositionTrackingPushbackReader p_27452_1_) throws InvalidSyntaxException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)p_27452_1_.func_27333_c();
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected [\"] but got [" + c + "].", p_27452_1_);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c2 = (char)p_27452_1_.func_27333_c();
            switch (c2) {
                case '\"': {
                    bl = true;
                    continue block4;
                }
                case '\\': {
                    char c3 = this.func_27457_j(p_27452_1_);
                    stringBuilder.append(c3);
                    continue block4;
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private char func_27457_j(PositionTrackingPushbackReader p_27457_1_) throws IOException, InvalidSyntaxException {
        char c;
        char c2 = (char)p_27457_1_.func_27333_c();
        switch (c2) {
            case '\"': {
                c = '\"';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            case '/': {
                c = '/';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'u': {
                c = (char)this.func_27450_k(p_27457_1_);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Unrecognised escape character [" + c2 + "].", p_27457_1_);
            }
        }
        return c;
    }

    private int func_27450_k(PositionTrackingPushbackReader p_27450_1_) throws IOException, InvalidSyntaxException {
        int n;
        char[] cArray = new char[4];
        int n2 = p_27450_1_.func_27336_b(cArray);
        if (n2 != 4) {
            throw new InvalidSyntaxException("Expected a 4 digit hexidecimal number but got only [" + n2 + "], namely [" + String.valueOf(cArray, 0, n2) + "].", p_27450_1_);
        }
        try {
            n = Integer.parseInt(String.valueOf(cArray), 16);
        }
        catch (NumberFormatException numberFormatException) {
            p_27450_1_.func_27335_a(cArray);
            throw new InvalidSyntaxException("Unable to parse [" + String.valueOf(cArray) + "] as a hexidecimal number.", numberFormatException, p_27450_1_);
        }
        return n;
    }

    private int func_27448_l(PositionTrackingPushbackReader p_27448_1_) throws IOException {
        int n;
        boolean bl = false;
        do {
            n = p_27448_1_.func_27333_c();
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        return n;
    }
}

