/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Achievement;
import net.minecraft.src.BaseMod;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BiomeGenEnd;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityEggInfo;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityRendererProxy;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.GenLayerBiome;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IInventory;
import net.minecraft.src.IRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.KeyBinding;
import net.minecraft.src.MLProp;
import net.minecraft.src.ModTextureStatic;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.Profiler;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderPlayer;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatCrafting;
import net.minecraft.src.StatList;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class ModLoader {
    private static final List animList = new LinkedList();
    private static final Map blockModels = new HashMap();
    private static final Map blockSpecialInv = new HashMap();
    private static final File cfgdir = new File(Minecraft.func_6240_b(), "/config/");
    private static final File cfgfile = new File(cfgdir, "ModLoader.cfg");
    public static Level cfgLoggingLevel = Level.FINER;
    private static Map classMap = null;
    private static long clock = 0L;
    public static final boolean DEBUG = false;
    private static Field field_animList = null;
    private static Field field_armorList = null;
    private static Field field_modifiers = null;
    private static Field field_TileEntityRenderers = null;
    private static boolean hasInit = false;
    private static int highestEntityId = 3000;
    private static final Map inGameHooks = new HashMap();
    private static final Map inGUIHooks = new HashMap();
    private static Minecraft instance = null;
    private static int itemSpriteIndex = 0;
    private static int itemSpritesLeft = 0;
    private static final Map keyList = new HashMap();
    private static String langPack = null;
    private static Map localizedStrings = new HashMap();
    private static final File logfile = new File(Minecraft.func_6240_b(), "ModLoader.txt");
    private static final Logger logger = Logger.getLogger("ModLoader");
    private static FileHandler logHandler = null;
    private static Method method_RegisterEntityID = null;
    private static Method method_RegisterTileEntity = null;
    private static final File modDir = new File(Minecraft.func_6240_b(), "/mods/");
    private static final LinkedList modList = new LinkedList();
    private static int nextBlockModelID = 1000;
    private static final Map overrides = new HashMap();
    private static final Map packetChannels = new HashMap();
    public static final Properties props = new Properties();
    private static BiomeGenBase[] standardBiomes;
    private static int terrainSpriteIndex;
    private static int terrainSpritesLeft;
    private static String texPack;
    private static boolean texturesAdded;
    private static final boolean[] usedItemSprites;
    private static final boolean[] usedTerrainSprites;
    public static final String VERSION = "ModLoader 1.2.5";
    private static NetClientHandler netHandler;

    static {
        terrainSpriteIndex = 0;
        terrainSpritesLeft = 0;
        texPack = null;
        texturesAdded = false;
        usedItemSprites = new boolean[256];
        usedTerrainSprites = new boolean[256];
        netHandler = null;
    }

    public static void addAchievementDesc(Achievement achievement, String string, String string2) {
        try {
            if (achievement.func_44020_i().contains(".")) {
                String[] stringArray = achievement.func_44020_i().split("\\.");
                if (stringArray.length == 2) {
                    String string3 = stringArray[1];
                    ModLoader.addLocalization("achievement." + string3, string);
                    ModLoader.addLocalization("achievement." + string3 + ".desc", string2);
                    ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)StatCollector.func_25200_a("achievement." + string3));
                    ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)StatCollector.func_25200_a("achievement." + string3 + ".desc"));
                } else {
                    ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)string);
                    ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)string2);
                }
            } else {
                ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)string);
                ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "AddAchievementDesc", illegalArgumentException);
            ModLoader.throwException(illegalArgumentException);
        }
        catch (SecurityException securityException) {
            logger.throwing("ModLoader", "AddAchievementDesc", securityException);
            ModLoader.throwException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.throwing("ModLoader", "AddAchievementDesc", noSuchFieldException);
            ModLoader.throwException(noSuchFieldException);
        }
    }

    public static int addAllFuel(int n, int n2) {
        logger.finest("Finding fuel for " + n);
        int n3 = 0;
        Iterator iterator = modList.iterator();
        while (iterator.hasNext() && n3 == 0) {
            n3 = ((BaseMod)iterator.next()).addFuel(n, n2);
        }
        if (n3 != 0) {
            logger.finest("Returned " + n3);
        }
        return n3;
    }

    public static void addAllRenderers(Map map) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        for (BaseMod baseMod : modList) {
            baseMod.addRenderer(map);
        }
    }

    public static void addAnimation(TextureFX textureFX) {
        logger.finest("Adding animation " + textureFX.toString());
        for (TextureFX textureFX2 : animList) {
            if (textureFX2.field_1126_b != textureFX.field_1126_b || textureFX2.field_1128_f != textureFX.field_1128_f) continue;
            animList.remove(textureFX);
            break;
        }
        animList.add(textureFX);
    }

    public static int addArmor(String string) {
        try {
            String[] stringArray = (String[])field_armorList.get(null);
            List<String> list = Arrays.asList(stringArray);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(list);
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            int n = arrayList.indexOf(string);
            field_armorList.set(null, arrayList.toArray(new String[0]));
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "AddArmor", illegalArgumentException);
            ModLoader.throwException("An impossible error has occured!", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "AddArmor", illegalAccessException);
            ModLoader.throwException("An impossible error has occured!", illegalAccessException);
        }
        return -1;
    }

    public static void addBiome(BiomeGenBase biomeGenBase) {
        BiomeGenBase[] biomeGenBaseArray = GenLayerBiome.biomeArray;
        List<BiomeGenBase> list = Arrays.asList(biomeGenBaseArray);
        ArrayList<BiomeGenBase> arrayList = new ArrayList<BiomeGenBase>();
        arrayList.addAll(list);
        if (!arrayList.contains(biomeGenBase)) {
            arrayList.add(biomeGenBase);
        }
        GenLayerBiome.biomeArray = arrayList.toArray(new BiomeGenBase[0]);
    }

    public static void addLocalization(String string, String string2) {
        ModLoader.addLocalization(string, "en_US", string2);
    }

    public static void addLocalization(String string, String string2, String string3) {
        Map<String, String> map;
        if (localizedStrings.containsKey(string2)) {
            map = (Map)localizedStrings.get(string2);
        } else {
            map = new HashMap();
            localizedStrings.put(string2, map);
        }
        map.put(string, string3);
    }

    private static void addMod(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz;
            String string2 = string.split("\\.")[0];
            if (string2.contains("$")) {
                return;
            }
            if (props.containsKey(string2) && (props.getProperty(string2).equalsIgnoreCase("no") || props.getProperty(string2).equalsIgnoreCase("off"))) {
                return;
            }
            Package package_ = ModLoader.class.getPackage();
            if (package_ != null) {
                string2 = String.valueOf(package_.getName()) + "." + string2;
            }
            if (!BaseMod.class.isAssignableFrom(clazz = classLoader.loadClass(string2))) {
                return;
            }
            ModLoader.setupProperties(clazz);
            BaseMod baseMod = (BaseMod)clazz.newInstance();
            if (baseMod != null) {
                modList.add(baseMod);
                logger.fine("Mod Initialized: \"" + baseMod.toString() + "\" from " + string);
                System.out.println("Mod Initialized: " + baseMod.toString());
            }
        }
        catch (Throwable throwable) {
            logger.fine("Failed to load mod from \"" + string + "\"");
            System.out.println("Failed to load mod from \"" + string + "\"");
            logger.throwing("ModLoader", "addMod", throwable);
            ModLoader.throwException(throwable);
        }
    }

    public static void addName(Object object, String string) {
        ModLoader.addName(object, "en_US", string);
    }

    public static void addName(Object object, String string, String string2) {
        Object object2;
        String string3 = null;
        if (object instanceof Item) {
            object2 = (Item)object;
            if (((Item)object2).func_20009_a() != null) {
                string3 = String.valueOf(((Item)object2).func_20009_a()) + ".name";
            }
        } else if (object instanceof Block) {
            object2 = (Block)object;
            if (((Block)object2).func_20013_i() != null) {
                string3 = String.valueOf(((Block)object2).func_20013_i()) + ".name";
            }
        } else if (object instanceof ItemStack) {
            object2 = (ItemStack)object;
            String string4 = Item.field_233_c[((ItemStack)object2).field_1617_c].func_21011_b((ItemStack)object2);
            if (string4 != null) {
                string3 = String.valueOf(string4) + ".name";
            }
        } else {
            object2 = new Exception(String.valueOf(object.getClass().getName()) + " cannot have name attached to it!");
            logger.throwing("ModLoader", "AddName", (Throwable)object2);
            ModLoader.throwException((Throwable)object2);
        }
        if (string3 != null) {
            ModLoader.addLocalization(string3, string, string2);
        } else {
            object2 = new Exception(object + " is missing name tag!");
            logger.throwing("ModLoader", "AddName", (Throwable)object2);
            ModLoader.throwException((Throwable)object2);
        }
    }

    public static int addOverride(String string, String string2) {
        try {
            int n = ModLoader.getUniqueSpriteIndex(string);
            ModLoader.addOverride(string, string2, n);
            return n;
        }
        catch (Throwable throwable) {
            logger.throwing("ModLoader", "addOverride", throwable);
            ModLoader.throwException(throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static void addOverride(String string, String string2, int n) {
        int n2 = -1;
        int n3 = 0;
        if (string.equals("/terrain.png")) {
            n2 = 0;
            n3 = terrainSpritesLeft;
        } else if (string.equals("/gui/items.png")) {
            n2 = 1;
            n3 = itemSpritesLeft;
        } else {
            return;
        }
        System.out.println("Overriding " + string + " with " + string2 + " @ " + n + ". " + n3 + " left.");
        logger.finer("addOverride(" + string + "," + string2 + "," + n + "). " + n3 + " left.");
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)overrides.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
            overrides.put(n2, hashMap);
        }
        hashMap.put(string2, n);
    }

    public static void addRecipe(ItemStack itemStack, Object ... objectArray) {
        CraftingManager.func_1120_a().func_1121_a(itemStack, objectArray);
    }

    public static void addShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        CraftingManager.func_1120_a().func_21187_b(itemStack, objectArray);
    }

    public static void addSmelting(int n, ItemStack itemStack) {
        FurnaceRecipes.func_21200_a().func_21199_a(n, itemStack);
    }

    public static void addSpawn(Class clazz, int n, int n2, int n3, EnumCreatureType enumCreatureType) {
        ModLoader.addSpawn(clazz, n, n2, n3, enumCreatureType, null);
    }

    public static void addSpawn(Class clazz, int n, int n2, int n3, EnumCreatureType enumCreatureType, BiomeGenBase ... biomeGenBaseArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (enumCreatureType == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomeGenBaseArray == null) {
            biomeGenBaseArray = standardBiomes;
        }
        int n4 = 0;
        while (n4 < biomeGenBaseArray.length) {
            List list = biomeGenBaseArray[n4].func_25063_a(enumCreatureType);
            if (list != null) {
                boolean bl = false;
                for (SpawnListEntry spawnListEntry : list) {
                    if (spawnListEntry.field_25212_a != clazz) continue;
                    spawnListEntry.field_35590_d = n;
                    spawnListEntry.field_35591_b = n2;
                    spawnListEntry.field_35592_c = n3;
                    bl = true;
                    break;
                }
                if (!bl) {
                    list.add(new SpawnListEntry(clazz, n, n2, n3));
                }
            }
            ++n4;
        }
    }

    public static void addSpawn(String string, int n, int n2, int n3, EnumCreatureType enumCreatureType) {
        ModLoader.addSpawn(string, n, n2, n3, enumCreatureType, null);
    }

    public static void addSpawn(String string, int n, int n2, int n3, EnumCreatureType enumCreatureType, BiomeGenBase ... biomeGenBaseArray) {
        Class clazz = (Class)classMap.get(string);
        if (clazz != null && EntityLiving.class.isAssignableFrom(clazz)) {
            ModLoader.addSpawn(clazz, n, n2, n3, enumCreatureType, biomeGenBaseArray);
        }
    }

    public static boolean dispenseEntity(World world, double d, double d2, double d3, int n, int n2, ItemStack itemStack) {
        boolean bl = false;
        Iterator iterator = modList.iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((BaseMod)iterator.next()).dispenseEntity(world, d, d2, d3, n, n2, itemStack);
        }
        return bl;
    }

    public static void genericContainerRemoval(World world, int n, int n2, int n3) {
        IInventory iInventory = (IInventory)((Object)world.func_603_b(n, n2, n3));
        if (iInventory != null) {
            int n4 = 0;
            while (n4 < iInventory.func_469_c()) {
                ItemStack itemStack = iInventory.func_468_c(n4);
                if (itemStack != null) {
                    double d = world.field_1037_n.nextDouble() * 0.8 + 0.1;
                    double d2 = world.field_1037_n.nextDouble() * 0.8 + 0.1;
                    double d3 = world.field_1037_n.nextDouble() * 0.8 + 0.1;
                    while (itemStack.field_1615_a > 0) {
                        int n5 = world.field_1037_n.nextInt(21) + 10;
                        if (n5 > itemStack.field_1615_a) {
                            n5 = itemStack.field_1615_a;
                        }
                        itemStack.field_1615_a -= n5;
                        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, new ItemStack(itemStack.field_1617_c, n5, itemStack.func_21181_i()));
                        double d4 = 0.05;
                        entityItem.field_608_an = world.field_1037_n.nextGaussian() * d4;
                        entityItem.field_607_ao = world.field_1037_n.nextGaussian() * d4 + 0.2;
                        entityItem.field_606_ap = world.field_1037_n.nextGaussian() * d4;
                        if (itemStack.func_40710_n()) {
                            entityItem.field_801_a.func_40706_d((NBTTagCompound)itemStack.func_40709_o().func_40195_b());
                        }
                        world.func_674_a(entityItem);
                    }
                    iInventory.func_472_a(n4, null);
                }
                ++n4;
            }
        }
    }

    public static List getLoadedMods() {
        return Collections.unmodifiableList(modList);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Minecraft getMinecraftInstance() {
        if (instance == null) {
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                int n = threadGroup.activeCount();
                Thread[] threadArray = new Thread[n];
                threadGroup.enumerate(threadArray);
                int n2 = 0;
                while (n2 < threadArray.length) {
                    System.out.println(threadArray[n2].getName());
                    ++n2;
                }
                n2 = 0;
                while (n2 < threadArray.length) {
                    if (threadArray[n2].getName().equals("Minecraft main thread")) {
                        instance = (Minecraft)ModLoader.getPrivateValue(Thread.class, (Object)threadArray[n2], "target");
                        break;
                    }
                    ++n2;
                }
            }
            catch (SecurityException securityException) {
                logger.throwing("ModLoader", "getMinecraftInstance", securityException);
                throw new RuntimeException(securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                logger.throwing("ModLoader", "getMinecraftInstance", noSuchFieldException);
                throw new RuntimeException(noSuchFieldException);
            }
        }
        return instance;
    }

    public static Object getPrivateValue(Class clazz, Object object, int n) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredFields()[n];
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "getPrivateValue", illegalAccessException);
            ModLoader.throwException("An impossible error has occured!", illegalAccessException);
            return null;
        }
    }

    public static Object getPrivateValue(Class clazz, Object object, String string) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "getPrivateValue", illegalAccessException);
            ModLoader.throwException("An impossible error has occured!", illegalAccessException);
            return null;
        }
    }

    public static int getUniqueBlockModelID(BaseMod baseMod, boolean bl) {
        int n = nextBlockModelID++;
        blockModels.put(n, baseMod);
        blockSpecialInv.put(n, bl);
        return n;
    }

    public static int getUniqueEntityId() {
        return highestEntityId++;
    }

    private static int getUniqueItemSpriteIndex() {
        while (itemSpriteIndex < usedItemSprites.length) {
            if (!usedItemSprites[itemSpriteIndex]) {
                ModLoader.usedItemSprites[ModLoader.itemSpriteIndex] = true;
                --itemSpritesLeft;
                return itemSpriteIndex++;
            }
            ++itemSpriteIndex;
        }
        Exception exception = new Exception("No more empty item sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    public static int getUniqueSpriteIndex(String string) {
        if (string.equals("/gui/items.png")) {
            return ModLoader.getUniqueItemSpriteIndex();
        }
        if (string.equals("/terrain.png")) {
            return ModLoader.getUniqueTerrainSpriteIndex();
        }
        Exception exception = new Exception("No registry for this texture: " + string);
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    private static int getUniqueTerrainSpriteIndex() {
        while (terrainSpriteIndex < usedTerrainSprites.length) {
            if (!usedTerrainSprites[terrainSpriteIndex]) {
                ModLoader.usedTerrainSprites[ModLoader.terrainSpriteIndex] = true;
                --terrainSpritesLeft;
                return terrainSpriteIndex++;
            }
            ++terrainSpriteIndex;
        }
        Exception exception = new Exception("No more empty terrain sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    private static void init() {
        Object object;
        hasInit = true;
        String string = "1111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111110111111111111111000111111111111101111111110000000101111111000000010101111100000000000000110000000000000000000000000000000000000000000000001111111111111111";
        String string2 = "1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111000000001111111100000111111111100000001111111110000001111111111111111111";
        int n = 0;
        while (n < 256) {
            boolean bl = ModLoader.usedItemSprites[n] = string.charAt(n) == '1';
            if (!usedItemSprites[n]) {
                ++itemSpritesLeft;
            }
            boolean bl2 = ModLoader.usedTerrainSprites[n] = string2.charAt(n) == '1';
            if (!usedTerrainSprites[n]) {
                ++terrainSpritesLeft;
            }
            ++n;
        }
        try {
            instance = (Minecraft)ModLoader.getPrivateValue(Minecraft.class, null, 1);
            ModLoader.instance.field_9243_r = new EntityRendererProxy(instance);
            classMap = (Map)ModLoader.getPrivateValue(EntityList.class, null, 0);
            field_modifiers = Field.class.getDeclaredField("modifiers");
            field_modifiers.setAccessible(true);
            field_TileEntityRenderers = TileEntityRenderer.class.getDeclaredFields()[0];
            field_TileEntityRenderers.setAccessible(true);
            field_armorList = RenderPlayer.class.getDeclaredFields()[3];
            field_modifiers.setInt(field_armorList, field_armorList.getModifiers() & 0xFFFFFFEF);
            field_armorList.setAccessible(true);
            field_animList = RenderEngine.class.getDeclaredFields()[6];
            field_animList.setAccessible(true);
            object = BiomeGenBase.class.getDeclaredFields();
            Object object2 = new LinkedList<BiomeGenBase>();
            int n2 = 0;
            while (n2 < ((Field[])object).length) {
                BiomeGenBase biomeGenBase;
                Class<BiomeGenBase> clazz = object[n2].getType();
                if ((object[n2].getModifiers() & 8) != 0 && clazz.isAssignableFrom(BiomeGenBase.class) && !((biomeGenBase = (BiomeGenBase)object[n2].get(null)) instanceof BiomeGenHell) && !(biomeGenBase instanceof BiomeGenEnd)) {
                    object2.add(biomeGenBase);
                }
                ++n2;
            }
            standardBiomes = object2.toArray(new BiomeGenBase[0]);
            try {
                method_RegisterTileEntity = TileEntity.class.getDeclaredMethod("a", Class.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method_RegisterTileEntity = TileEntity.class.getDeclaredMethod("addMapping", Class.class, String.class);
            }
            method_RegisterTileEntity.setAccessible(true);
            try {
                method_RegisterEntityID = EntityList.class.getDeclaredMethod("a", Class.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method_RegisterEntityID = EntityList.class.getDeclaredMethod("addMapping", Class.class, String.class, Integer.TYPE);
            }
            method_RegisterEntityID.setAccessible(true);
        }
        catch (SecurityException securityException) {
            logger.throwing("ModLoader", "init", securityException);
            ModLoader.throwException(securityException);
            throw new RuntimeException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.throwing("ModLoader", "init", noSuchFieldException);
            ModLoader.throwException(noSuchFieldException);
            throw new RuntimeException(noSuchFieldException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.throwing("ModLoader", "init", noSuchMethodException);
            ModLoader.throwException(noSuchMethodException);
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "init", illegalArgumentException);
            ModLoader.throwException(illegalArgumentException);
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "init", illegalAccessException);
            ModLoader.throwException(illegalAccessException);
            throw new RuntimeException(illegalAccessException);
        }
        try {
            ModLoader.loadConfig();
            if (props.containsKey("loggingLevel")) {
                cfgLoggingLevel = Level.parse(props.getProperty("loggingLevel"));
            }
            if (props.containsKey("grassFix")) {
                RenderBlocks.cfgGrassFix = Boolean.parseBoolean(props.getProperty("grassFix"));
            }
            logger.setLevel(cfgLoggingLevel);
            if ((logfile.exists() || logfile.createNewFile()) && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(logHandler);
            }
            logger.fine("ModLoader 1.2.5 Initializing...");
            System.out.println("ModLoader 1.2.5 Initializing...");
            object = new File(ModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            modDir.mkdirs();
            ModLoader.readFromClassPath((File)object);
            ModLoader.readFromModFolder(modDir);
            ModLoader.sortModList();
            for (Object object2 : modList) {
                ((BaseMod)object2).load();
                logger.fine("Mod Loaded: \"" + ((BaseMod)object2).toString() + "\"");
                System.out.println("Mod Loaded: " + ((BaseMod)object2).toString());
                if (props.containsKey(object2.getClass().getSimpleName())) continue;
                props.setProperty(object2.getClass().getSimpleName(), "on");
            }
            for (Object object2 : modList) {
                ((BaseMod)object2).modsLoaded();
            }
            System.out.println("Done.");
            props.setProperty("loggingLevel", cfgLoggingLevel.getName());
            props.setProperty("grassFix", Boolean.toString(RenderBlocks.cfgGrassFix));
            ModLoader.instance.field_6304_y.field_1564_t = ModLoader.registerAllKeys(ModLoader.instance.field_6304_y.field_1564_t);
            ModLoader.instance.field_6304_y.func_6519_a();
            ModLoader.initStats();
            ModLoader.saveConfig();
        }
        catch (Throwable throwable) {
            logger.throwing("ModLoader", "init", throwable);
            ModLoader.throwException("ModLoader has failed to initialize.", throwable);
            if (logHandler != null) {
                logHandler.close();
            }
            throw new RuntimeException(throwable);
        }
    }

    private static void initStats() {
        Object object2;
        int n = 0;
        while (n < Block.field_345_n.length) {
            if (!StatList.field_25169_C.containsKey(0x1000000 + n) && Block.field_345_n[n] != null && Block.field_345_n[n].func_27033_k()) {
                object2 = StatCollector.func_25199_a("stat.mineBlock", Block.field_345_n[n].func_25016_i());
                StatList.field_25159_y[n] = new StatCrafting(0x1000000 + n, (String)object2, n).func_25068_c();
                StatList.field_25185_d.add(StatList.field_25159_y[n]);
            }
            ++n;
        }
        n = 0;
        while (n < Item.field_233_c.length) {
            if (!StatList.field_25169_C.containsKey(0x1020000 + n) && Item.field_233_c[n] != null) {
                object2 = StatCollector.func_25199_a("stat.useItem", Item.field_233_c[n].func_25009_k());
                StatList.field_25172_A[n] = new StatCrafting(0x1020000 + n, (String)object2, n).func_25068_c();
                if (n >= Block.field_345_n.length) {
                    StatList.field_25186_c.add(StatList.field_25172_A[n]);
                }
            }
            if (!StatList.field_25169_C.containsKey(0x1030000 + n) && Item.field_233_c[n] != null && Item.field_233_c[n].func_25007_g()) {
                object2 = StatCollector.func_25199_a("stat.breakItem", Item.field_233_c[n].func_25009_k());
                StatList.field_25170_B[n] = new StatCrafting(0x1030000 + n, (String)object2, n).func_25068_c();
            }
            ++n;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Object object2 : CraftingManager.func_1120_a().func_25193_b()) {
            hashSet.add(((IRecipe)object2).func_25117_b().field_1617_c);
        }
        for (Object object2 : FurnaceRecipes.func_21200_a().func_25194_b().values()) {
            hashSet.add(((ItemStack)object2).field_1617_c);
        }
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (StatList.field_25169_C.containsKey(0x1010000 + n2) || Item.field_233_c[n2] == null) continue;
            String string = StatCollector.func_25199_a("stat.craftItem", Item.field_233_c[n2].func_25009_k());
            StatList.field_25158_z[n2] = new StatCrafting(0x1010000 + n2, string, n2).func_25068_c();
        }
    }

    public static boolean isGUIOpen(Class clazz) {
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (clazz == null) {
            return minecraft.field_6313_p == null;
        }
        if (minecraft.field_6313_p == null && clazz != null) {
            return false;
        }
        return clazz.isInstance(minecraft.field_6313_p);
    }

    public static boolean isModLoaded(String string) {
        for (BaseMod baseMod : modList) {
            if (!string.contentEquals(baseMod.getName())) continue;
            return true;
        }
        return false;
    }

    public static void loadConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(cfgfile);
            props.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
    }

    public static BufferedImage loadImage(RenderEngine renderEngine, String string) throws Exception {
        TexturePackList texturePackList = (TexturePackList)ModLoader.getPrivateValue(RenderEngine.class, (Object)renderEngine, 11);
        InputStream inputStream = texturePackList.field_6534_a.func_6481_a(string);
        if (inputStream == null) {
            throw new Exception("Image not found: " + string);
        }
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            throw new Exception("Image corrupted: " + string);
        }
        return bufferedImage;
    }

    public static void onItemPickup(EntityPlayer entityPlayer, ItemStack itemStack) {
        for (BaseMod baseMod : modList) {
            baseMod.onItemPickup(entityPlayer, itemStack);
        }
    }

    public static void onTick(float f, Minecraft minecraft) {
        Map.Entry entry;
        Profiler.func_40662_b();
        Profiler.func_40662_b();
        Profiler.func_40663_a("modtick");
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        if (texPack == null || minecraft.field_6304_y.field_6524_j != texPack) {
            texturesAdded = false;
            texPack = minecraft.field_6304_y.field_6524_j;
        }
        if (langPack == null || StringTranslate.func_20162_a().func_44024_c() != langPack) {
            Properties properties = null;
            try {
                properties = (Properties)ModLoader.getPrivateValue(StringTranslate.class, (Object)StringTranslate.func_20162_a(), 1);
            }
            catch (SecurityException securityException) {
                logger.throwing("ModLoader", "AddLocalization", securityException);
                ModLoader.throwException(securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                logger.throwing("ModLoader", "AddLocalization", noSuchFieldException);
                ModLoader.throwException(noSuchFieldException);
            }
            langPack = StringTranslate.func_20162_a().func_44024_c();
            if (properties != null) {
                if (localizedStrings.containsKey("en_US")) {
                    properties.putAll((Map<?, ?>)((Map)localizedStrings.get("en_US")));
                }
                if (!langPack.contentEquals("en_US") && localizedStrings.containsKey(langPack)) {
                    properties.putAll((Map<?, ?>)((Map)localizedStrings.get(langPack)));
                }
            }
        }
        if (!texturesAdded && minecraft.field_6315_n != null) {
            ModLoader.registerAllTextureOverrides(minecraft.field_6315_n);
            texturesAdded = true;
        }
        long l = 0L;
        if (minecraft.field_6324_e != null) {
            l = minecraft.field_6324_e.func_22139_r();
            Iterator object2 = inGameHooks.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                if (clock == l && ((Boolean)entry.getValue()).booleanValue() || ((BaseMod)entry.getKey()).onTickInGame(f, minecraft)) continue;
                object2.remove();
            }
        }
        if (minecraft.field_40007_r != null) {
            Iterator iterator = inGUIHooks.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (clock == l && (Boolean)entry.getValue() & minecraft.field_6324_e != null || ((BaseMod)entry.getKey()).onTickInGUI(f, minecraft, minecraft.field_6313_p)) continue;
                iterator.remove();
            }
        }
        if (clock != l) {
            for (Map.Entry entry2 : keyList.entrySet()) {
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    int n = ((KeyBinding)entry3.getKey()).field_1370_b;
                    boolean bl = n < 0 ? Mouse.isButtonDown((int)(n += 100)) : Keyboard.isKeyDown((int)n);
                    boolean[] blArray = (boolean[])entry3.getValue();
                    boolean bl2 = blArray[1];
                    blArray[1] = bl;
                    if (!bl || bl2 && !blArray[0]) continue;
                    ((BaseMod)entry2.getKey()).keyboardEvent((KeyBinding)entry3.getKey());
                }
            }
        }
        clock = l;
        Profiler.func_40662_b();
        Profiler.func_40663_a("render");
        Profiler.func_40663_a("gameRenderer");
    }

    public static void openGUI(EntityPlayer entityPlayer, GuiScreen guiScreen) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (minecraft.field_22009_h != entityPlayer) {
            return;
        }
        if (guiScreen != null) {
            minecraft.func_6272_a(guiScreen);
        }
    }

    public static void populateChunk(IChunkProvider iChunkProvider, int n, int n2, World world) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Random random = new Random(world.func_22138_q());
        long l = random.nextLong() / 2L * 2L + 1L;
        long l2 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)n * l + (long)n2 * l2 ^ world.func_22138_q());
        for (BaseMod baseMod : modList) {
            if (iChunkProvider.func_21109_c().equals("RandomLevelSource")) {
                baseMod.generateSurface(world, random, n << 4, n2 << 4);
                continue;
            }
            if (!iChunkProvider.func_21109_c().equals("HellRandomLevelSource")) continue;
            baseMod.generateNether(world, random, n << 4, n2 << 4);
        }
    }

    private static void readFromClassPath(File file) throws FileNotFoundException, IOException {
        logger.finer("Adding mods from " + file.getCanonicalPath());
        ClassLoader classLoader = ModLoader.class.getClassLoader();
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            logger.finer("Zip found.");
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (zipEntry.isDirectory() || !string.startsWith("mod_") || !string.endsWith(".class")) continue;
                ModLoader.addMod(classLoader, string);
            }
            ((InputStream)fileInputStream).close();
        } else if (file.isDirectory()) {
            File[] fileArray;
            Package package_ = ModLoader.class.getPackage();
            if (package_ != null) {
                fileArray = package_.getName().replace('.', File.separatorChar);
                file = new File(file, (String)fileArray);
            }
            logger.finer("Directory found.");
            fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    String string = fileArray[n].getName();
                    if (fileArray[n].isFile() && string.startsWith("mod_") && string.endsWith(".class")) {
                        ModLoader.addMod(classLoader, string);
                    }
                    ++n;
                }
            }
        }
    }

    private static void readFromModFolder(File file) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object object;
        int n;
        ClassLoader classLoader = Minecraft.class.getClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("folder must be a Directory.");
        }
        Object[] objectArray = file.listFiles();
        Arrays.sort(objectArray);
        if (classLoader instanceof URLClassLoader) {
            n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                if (((File)object).isDirectory() || ((File)object).isFile() && (((File)object).getName().endsWith(".jar") || ((File)object).getName().endsWith(".zip"))) {
                    method.invoke((Object)classLoader, ((File)object).toURI().toURL());
                }
                ++n;
            }
        }
        n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (((File)object).isDirectory() || ((File)object).isFile() && (((File)object).getName().endsWith(".jar") || ((File)object).getName().endsWith(".zip"))) {
                String string;
                File[] fileArray;
                Object object2;
                logger.finer("Adding mods from " + ((File)object).getCanonicalPath());
                if (((File)object).isFile()) {
                    logger.finer("Zip found.");
                    object2 = new FileInputStream((File)object);
                    fileArray = new ZipInputStream((InputStream)object2);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = fileArray.getNextEntry()) != null) {
                        string = zipEntry.getName();
                        if (zipEntry.isDirectory() || !string.startsWith("mod_") || !string.endsWith(".class")) continue;
                        ModLoader.addMod(classLoader, string);
                    }
                    fileArray.close();
                    ((InputStream)object2).close();
                } else if (((File)object).isDirectory()) {
                    object2 = ModLoader.class.getPackage();
                    if (object2 != null) {
                        fileArray = ((Package)object2).getName().replace('.', File.separatorChar);
                        object = new File((File)object, (String)fileArray);
                    }
                    logger.finer("Directory found.");
                    fileArray = ((File)object).listFiles();
                    if (fileArray != null) {
                        int n2 = 0;
                        while (n2 < fileArray.length) {
                            string = fileArray[n2].getName();
                            if (fileArray[n2].isFile() && string.startsWith("mod_") && string.endsWith(".class")) {
                                ModLoader.addMod(classLoader, string);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public static void receivePacket(Packet250CustomPayload packet250CustomPayload) {
        BaseMod baseMod;
        if (packetChannels.containsKey(packet250CustomPayload.field_44012_a) && (baseMod = (BaseMod)packetChannels.get(packet250CustomPayload.field_44012_a)) != null) {
            baseMod.receiveCustomPacket(packet250CustomPayload);
        }
    }

    public static KeyBinding[] registerAllKeys(KeyBinding[] keyBindingArray) {
        LinkedList<KeyBinding> linkedList = new LinkedList<KeyBinding>();
        linkedList.addAll(Arrays.asList(keyBindingArray));
        for (Map map : keyList.values()) {
            linkedList.addAll(map.keySet());
        }
        return linkedList.toArray(new KeyBinding[0]);
    }

    public static void registerAllTextureOverrides(RenderEngine renderEngine) {
        animList.clear();
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        for (BaseMod object : modList) {
            object.registerAnimation(minecraft);
        }
        for (TextureFX textureFX : animList) {
            renderEngine.func_1066_a(textureFX);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                String string = (String)entry2.getKey();
                int n = (Integer)entry2.getValue();
                int n2 = (Integer)entry.getKey();
                try {
                    BufferedImage bufferedImage = ModLoader.loadImage(renderEngine, string);
                    ModTextureStatic modTextureStatic = new ModTextureStatic(n, n2, bufferedImage);
                    renderEngine.func_1066_a(modTextureStatic);
                }
                catch (Exception exception) {
                    logger.throwing("ModLoader", "RegisterAllTextureOverrides", exception);
                    ModLoader.throwException(exception);
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static void registerBlock(Block block) {
        ModLoader.registerBlock(block, null);
    }

    public static void registerBlock(Block block, Class clazz) {
        try {
            if (block == null) {
                throw new IllegalArgumentException("block parameter cannot be null.");
            }
            int n = block.field_376_bc;
            ItemBlock itemBlock = null;
            itemBlock = clazz != null ? (ItemBlock)clazz.getConstructor(Integer.TYPE).newInstance(n - 256) : new ItemBlock(n - 256);
            if (Block.field_345_n[n] != null && Item.field_233_c[n] == null) {
                Item.field_233_c[n] = itemBlock;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "RegisterBlock", illegalArgumentException);
            ModLoader.throwException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "RegisterBlock", illegalAccessException);
            ModLoader.throwException(illegalAccessException);
        }
        catch (SecurityException securityException) {
            logger.throwing("ModLoader", "RegisterBlock", securityException);
            ModLoader.throwException(securityException);
        }
        catch (InstantiationException instantiationException) {
            logger.throwing("ModLoader", "RegisterBlock", instantiationException);
            ModLoader.throwException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.throwing("ModLoader", "RegisterBlock", invocationTargetException);
            ModLoader.throwException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.throwing("ModLoader", "RegisterBlock", noSuchMethodException);
            ModLoader.throwException(noSuchMethodException);
        }
    }

    public static void registerEntityID(Class clazz, String string, int n) {
        try {
            method_RegisterEntityID.invoke(null, clazz, string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "RegisterEntityID", illegalArgumentException);
            ModLoader.throwException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "RegisterEntityID", illegalAccessException);
            ModLoader.throwException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.throwing("ModLoader", "RegisterEntityID", invocationTargetException);
            ModLoader.throwException(invocationTargetException);
        }
    }

    public static void registerEntityID(Class clazz, String string, int n, int n2, int n3) {
        ModLoader.registerEntityID(clazz, string, n);
        EntityList.field_44041_a.put(n, new EntityEggInfo(n, n2, n3));
    }

    public static void registerKey(BaseMod baseMod, KeyBinding keyBinding, boolean bl) {
        HashMap<KeyBinding, boolean[]> hashMap = (HashMap<KeyBinding, boolean[]>)keyList.get(baseMod);
        if (hashMap == null) {
            hashMap = new HashMap<KeyBinding, boolean[]>();
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = bl;
        hashMap.put(keyBinding, blArray);
        keyList.put(baseMod, hashMap);
    }

    public static void registerPacketChannel(BaseMod baseMod, String string) {
        if (string.length() >= 16) {
            throw new RuntimeException(String.format("Invalid channel name: %s. Must be less than 16 characters.", string));
        }
        packetChannels.put(string, baseMod);
    }

    public static void registerTileEntity(Class clazz, String string) {
        ModLoader.registerTileEntity(clazz, string, null);
    }

    public static void registerTileEntity(Class clazz, String string, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        try {
            method_RegisterTileEntity.invoke(null, clazz, string);
            if (tileEntitySpecialRenderer != null) {
                TileEntityRenderer tileEntityRenderer = TileEntityRenderer.field_1554_a;
                Map map = (Map)field_TileEntityRenderers.get(tileEntityRenderer);
                map.put(clazz, tileEntitySpecialRenderer);
                tileEntitySpecialRenderer.func_928_a(tileEntityRenderer);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.throwing("ModLoader", "RegisterTileEntity", illegalArgumentException);
            ModLoader.throwException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "RegisterTileEntity", illegalAccessException);
            ModLoader.throwException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.throwing("ModLoader", "RegisterTileEntity", invocationTargetException);
            ModLoader.throwException(invocationTargetException);
        }
    }

    public static void removeBiome(BiomeGenBase biomeGenBase) {
        BiomeGenBase[] biomeGenBaseArray = GenLayerBiome.biomeArray;
        List<BiomeGenBase> list = Arrays.asList(biomeGenBaseArray);
        ArrayList<BiomeGenBase> arrayList = new ArrayList<BiomeGenBase>();
        arrayList.addAll(list);
        if (arrayList.contains(biomeGenBase)) {
            arrayList.remove(biomeGenBase);
        }
        GenLayerBiome.biomeArray = arrayList.toArray(new BiomeGenBase[0]);
    }

    public static void removeSpawn(Class clazz, EnumCreatureType enumCreatureType) {
        ModLoader.removeSpawn(clazz, enumCreatureType, null);
    }

    public static void removeSpawn(Class clazz, EnumCreatureType enumCreatureType, BiomeGenBase ... biomeGenBaseArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (enumCreatureType == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomeGenBaseArray == null) {
            biomeGenBaseArray = standardBiomes;
        }
        int n = 0;
        while (n < biomeGenBaseArray.length) {
            List list = biomeGenBaseArray[n].func_25063_a(enumCreatureType);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SpawnListEntry spawnListEntry = (SpawnListEntry)iterator.next();
                    if (spawnListEntry.field_25212_a != clazz) continue;
                    iterator.remove();
                }
            }
            ++n;
        }
    }

    public static void removeSpawn(String string, EnumCreatureType enumCreatureType) {
        ModLoader.removeSpawn(string, enumCreatureType, null);
    }

    public static void removeSpawn(String string, EnumCreatureType enumCreatureType, BiomeGenBase ... biomeGenBaseArray) {
        Class clazz = (Class)classMap.get(string);
        if (clazz != null && EntityLiving.class.isAssignableFrom(clazz)) {
            ModLoader.removeSpawn(clazz, enumCreatureType, biomeGenBaseArray);
        }
    }

    public static boolean renderBlockIsItemFull3D(int n) {
        if (!blockSpecialInv.containsKey(n)) {
            return n == 16;
        }
        return (Boolean)blockSpecialInv.get(n);
    }

    public static void renderInvBlock(RenderBlocks renderBlocks, Block block, int n, int n2) {
        BaseMod baseMod = (BaseMod)blockModels.get(n2);
        if (baseMod == null) {
            return;
        }
        baseMod.renderInvBlock(renderBlocks, block, n, n2);
    }

    public static boolean renderWorldBlock(RenderBlocks renderBlocks, IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4) {
        BaseMod baseMod = (BaseMod)blockModels.get(n4);
        if (baseMod == null) {
            return false;
        }
        return baseMod.renderWorldBlock(renderBlocks, iBlockAccess, n, n2, n3, block, n4);
    }

    public static void saveConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canWrite()) {
            FileOutputStream fileOutputStream = new FileOutputStream(cfgfile);
            props.store(fileOutputStream, "ModLoader Config");
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void serverChat(String string) {
        for (BaseMod baseMod : modList) {
            baseMod.receiveChatPacket(string);
        }
    }

    public static void serverConnect(NetClientHandler netClientHandler, Packet1Login packet1Login) {
        netHandler = netClientHandler;
        if (packetChannels.size() > 0) {
            Object object = new Packet250CustomPayload();
            ((Packet250CustomPayload)object).field_44012_a = "REGISTER";
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = packetChannels.keySet().iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\u0000");
                stringBuilder.append((String)iterator.next());
            }
            ((Packet250CustomPayload)object).field_44011_c = stringBuilder.toString().getBytes(Charset.forName("UTF8"));
            ((Packet250CustomPayload)object).field_44010_b = ((Packet250CustomPayload)object).field_44011_c.length;
            ModLoader.sendPacket((Packet)object);
        }
        for (Object object : modList) {
            ((BaseMod)object).serverConnect(netHandler);
        }
    }

    public static void serverDisconnect() {
        for (BaseMod baseMod : modList) {
            baseMod.serverDisconnect();
        }
        netHandler = null;
    }

    public static void sendPacket(Packet packet) {
        if (netHandler != null) {
            netHandler.func_847_a(packet);
        }
    }

    public static void setInGameHook(BaseMod baseMod, boolean bl, boolean bl2) {
        if (bl) {
            inGameHooks.put(baseMod, bl2);
        } else {
            inGameHooks.remove(baseMod);
        }
    }

    public static void setInGUIHook(BaseMod baseMod, boolean bl, boolean bl2) {
        if (bl) {
            inGUIHooks.put(baseMod, bl2);
        } else {
            inGUIHooks.remove(baseMod);
        }
    }

    public static void setPrivateValue(Class clazz, Object object, int n, Object object2) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredFields()[n];
            field.setAccessible(true);
            int n2 = field_modifiers.getInt(field);
            if ((n2 & 0x10) != 0) {
                field_modifiers.setInt(field, n2 & 0xFFFFFFEF);
            }
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "setPrivateValue", illegalAccessException);
            ModLoader.throwException("An impossible error has occured!", illegalAccessException);
        }
    }

    public static void setPrivateValue(Class clazz, Object object, String string, Object object2) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(string);
            int n = field_modifiers.getInt(field);
            if ((n & 0x10) != 0) {
                field_modifiers.setInt(field, n & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.throwing("ModLoader", "setPrivateValue", illegalAccessException);
            ModLoader.throwException("An impossible error has occured!", illegalAccessException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setupProperties(Class clazz) throws IllegalArgumentException, IllegalAccessException, IOException, SecurityException, NoSuchFieldException, NoSuchAlgorithmException, DigestException {
        Object object;
        Object object2;
        void field;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Properties properties = new Properties();
        int n = 0;
        int n2 = 0;
        File file = new File(cfgdir, String.valueOf(clazz.getSimpleName()) + ".cfg");
        if (file.exists() && file.canRead()) {
            properties.load(new FileInputStream(file));
        }
        if (properties.containsKey("checksum")) {
            n2 = Integer.parseInt(properties.getProperty("checksum"), 36);
        }
        Object object3 = clazz.getDeclaredFields();
        int n3 = ((Field[])object3).length;
        boolean n4 = false;
        while (field < n3) {
            object2 = object3[field];
            if ((((Field)object2).getModifiers() & 8) != 0 && ((AccessibleObject)object2).isAnnotationPresent(MLProp.class)) {
                linkedList.add(object2);
                object = ((Field)object2).get(null);
                n += object.hashCode();
            }
            ++field;
        }
        object2 = new StringBuilder();
        for (Field field2 : linkedList) {
            if ((field2.getModifiers() & 8) == 0 || !field2.isAnnotationPresent(MLProp.class)) continue;
            object3 = field2.getType();
            object = field2.getAnnotation(MLProp.class);
            String string = object.name().length() == 0 ? field2.getName() : object.name();
            Object object4 = field2.get(null);
            StringBuilder stringBuilder = new StringBuilder();
            if (object.min() != Double.NEGATIVE_INFINITY) {
                stringBuilder.append(String.format(",>=%.1f", object.min()));
            }
            if (object.max() != Double.POSITIVE_INFINITY) {
                stringBuilder.append(String.format(",<=%.1f", object.max()));
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (object.info().length() > 0) {
                stringBuilder2.append(" -- ");
                stringBuilder2.append(object.info());
            }
            ((StringBuilder)object2).append(String.format("%s (%s:%s%s)%s\n", string, ((Class)object3).getName(), object4, stringBuilder, stringBuilder2));
            if (n2 == n && properties.containsKey(string)) {
                String string2 = properties.getProperty(string);
                Object object5 = null;
                if (((Class)object3).isAssignableFrom(String.class)) {
                    object5 = string2;
                } else if (((Class)object3).isAssignableFrom(Integer.TYPE)) {
                    object5 = Integer.parseInt(string2);
                } else if (((Class)object3).isAssignableFrom(Short.TYPE)) {
                    object5 = Short.parseShort(string2);
                } else if (((Class)object3).isAssignableFrom(Byte.TYPE)) {
                    object5 = Byte.parseByte(string2);
                } else if (((Class)object3).isAssignableFrom(Boolean.TYPE)) {
                    object5 = Boolean.parseBoolean(string2);
                } else if (((Class)object3).isAssignableFrom(Float.TYPE)) {
                    object5 = Float.valueOf(Float.parseFloat(string2));
                } else if (((Class)object3).isAssignableFrom(Double.TYPE)) {
                    object5 = Double.parseDouble(string2);
                }
                if (object5 == null) continue;
                if (object5 instanceof Number) {
                    double d = ((Number)object5).doubleValue();
                    if (object.min() != Double.NEGATIVE_INFINITY && d < object.min() || object.max() != Double.POSITIVE_INFINITY && d > object.max()) continue;
                }
                logger.finer(String.valueOf(string) + " set to " + object5);
                if (object5.equals(object4)) continue;
                field2.set(null, object5);
                continue;
            }
            logger.finer(String.valueOf(string) + " not in config, using default: " + object4);
            properties.setProperty(string, object4.toString());
        }
        properties.put("checksum", Integer.toString(n, 36));
        if (!properties.isEmpty() && (file.exists() || file.createNewFile()) && file.canWrite()) {
            properties.store(new FileOutputStream(file), ((StringBuilder)object2).toString());
        }
    }

    private static void sortModList() throws Exception {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object2 : ModLoader.getLoadedMods()) {
            hashMap.put(object2.getClass().getSimpleName(), object2);
        }
        object2 = new LinkedList();
        int n = 0;
        while (((LinkedList)object2).size() != modList.size()) {
            if (n > 10) break;
            block2: for (BaseMod baseMod : modList) {
                if (((LinkedList)object2).contains(baseMod)) continue;
                String string = baseMod.getPriorities();
                if (string == null || string.length() == 0 || string.indexOf(58) == -1) {
                    ((LinkedList)object2).add(baseMod);
                    continue;
                }
                if (n <= 0) continue;
                int n2 = -1;
                int n3 = Integer.MIN_VALUE;
                int n4 = Integer.MAX_VALUE;
                String[] stringArray = string.indexOf(59) > 0 ? string.split(";") : new String[]{string};
                int n5 = 0;
                while (n5 < stringArray.length) {
                    String string2 = stringArray[n5];
                    if (string2.indexOf(58) != -1) {
                        String[] stringArray2 = string2.split(":");
                        String string3 = stringArray2[0];
                        String string4 = stringArray2[1];
                        if (string3.contentEquals("required-before") || string3.contentEquals("before") || string3.contentEquals("after") || string3.contentEquals("required-after")) {
                            if (string4.contentEquals("*")) {
                                if (string3.contentEquals("required-before") || string3.contentEquals("before")) {
                                    n2 = 0;
                                    break;
                                }
                                if (!string3.contentEquals("required-after") && !string3.contentEquals("after")) break;
                                n2 = ((LinkedList)object2).size();
                                break;
                            }
                            if ((string3.contentEquals("required-before") || string3.contentEquals("required-after")) && !hashMap.containsKey(string4)) {
                                throw new Exception(String.format("%s is missing dependency: %s", baseMod, string4));
                            }
                            BaseMod baseMod2 = (BaseMod)hashMap.get(string4);
                            if (!((LinkedList)object2).contains(baseMod2)) continue block2;
                            int n6 = ((LinkedList)object2).indexOf(baseMod2);
                            if (string3.contentEquals("required-before") || string3.contentEquals("before")) {
                                n2 = n6;
                                if (n2 < n4) {
                                    n4 = n2;
                                } else {
                                    n2 = n4;
                                }
                            } else if (string3.contentEquals("required-after") || string3.contentEquals("after")) {
                                n2 = n6 + 1;
                                if (n2 > n3) {
                                    n3 = n2;
                                } else {
                                    n2 = n3;
                                }
                            }
                        }
                    }
                    ++n5;
                }
                if (n2 == -1) continue;
                ((LinkedList)object2).add(n2, baseMod);
            }
            ++n;
        }
        modList.clear();
        modList.addAll(object2);
    }

    public static void takenFromCrafting(EntityPlayer entityPlayer, ItemStack itemStack, IInventory iInventory) {
        for (BaseMod baseMod : modList) {
            baseMod.takenFromCrafting(entityPlayer, itemStack, iInventory);
        }
    }

    public static void takenFromFurnace(EntityPlayer entityPlayer, ItemStack itemStack) {
        for (BaseMod baseMod : modList) {
            baseMod.takenFromFurnace(entityPlayer, itemStack);
        }
    }

    public static void throwException(String string, Throwable throwable) {
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (minecraft == null) {
            throw new RuntimeException(throwable);
        }
        minecraft.func_4007_a(new UnexpectedThrowable(string, throwable));
    }

    private static void throwException(Throwable throwable) {
        ModLoader.throwException("Exception occured in ModLoader", throwable);
    }

    private ModLoader() {
    }
}

