/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.src.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] field_22213_a = new byte[4096];
    private final File field_22212_b;
    private RandomAccessFile field_22219_c;
    private final int[] field_22218_d = new int[1024];
    private final int[] field_22217_e = new int[1024];
    private ArrayList field_22216_f;
    private int field_22215_g;
    private long field_22214_h = 0L;

    public RegionFile(File p_i442_1_) {
        this.field_22212_b = p_i442_1_;
        this.func_22204_b("REGION LOAD " + this.field_22212_b);
        this.field_22215_g = 0;
        try {
            int n;
            int n2;
            int n3;
            if (p_i442_1_.exists()) {
                this.field_22214_h = p_i442_1_.lastModified();
            }
            this.field_22219_c = new RandomAccessFile(p_i442_1_, "rw");
            if (this.field_22219_c.length() < 4096L) {
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_22219_c.writeInt(0);
                }
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_22219_c.writeInt(0);
                }
                this.field_22215_g += 8192;
            }
            if ((this.field_22219_c.length() & 0xFFFL) != 0L) {
                n3 = 0;
                while ((long)n3 < (this.field_22219_c.length() & 0xFFFL)) {
                    this.field_22219_c.write(0);
                    ++n3;
                }
            }
            n3 = (int)this.field_22219_c.length() / 4096;
            this.field_22216_f = new ArrayList(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.field_22216_f.add(true);
            }
            this.field_22216_f.set(0, false);
            this.field_22216_f.set(1, false);
            this.field_22219_c.seek(0L);
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_22218_d[n2] = n = this.field_22219_c.readInt();
                if (n == 0 || (n >> 8) + (n & 0xFF) > this.field_22216_f.size()) continue;
                for (int i = 0; i < (n & 0xFF); ++i) {
                    this.field_22216_f.set((n >> 8) + i, false);
                }
            }
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_22217_e[n2] = n = this.field_22219_c.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_22211_a(String p_22211_1_) {
    }

    private void func_22204_b(String p_22204_1_) {
        this.func_22211_a(p_22204_1_ + "\n");
    }

    private void func_22199_a(String p_22199_1_, int p_22199_2_, int p_22199_3_, String p_22199_4_) {
        this.func_22211_a("REGION " + p_22199_1_ + " " + this.field_22212_b.getName() + "[" + p_22199_2_ + "," + p_22199_3_ + "] = " + p_22199_4_);
    }

    private void func_22197_a(String p_22197_1_, int p_22197_2_, int p_22197_3_, int p_22197_4_, String p_22197_5_) {
        this.func_22211_a("REGION " + p_22197_1_ + " " + this.field_22212_b.getName() + "[" + p_22197_2_ + "," + p_22197_3_ + "] " + p_22197_4_ + "B = " + p_22197_5_);
    }

    private void func_22201_b(String p_22201_1_, int p_22201_2_, int p_22201_3_, String p_22201_4_) {
        this.func_22199_a(p_22201_1_, p_22201_2_, p_22201_3_, p_22201_4_ + "\n");
    }

    public synchronized DataInputStream func_22210_a(int p_22210_1_, int p_22210_2_) {
        if (this.func_22206_d(p_22210_1_, p_22210_2_)) {
            this.func_22201_b("READ", p_22210_1_, p_22210_2_, "out of bounds");
            return null;
        }
        try {
            int n = this.func_22207_e(p_22210_1_, p_22210_2_);
            if (n == 0) {
                return null;
            }
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            if (n2 + n3 > this.field_22216_f.size()) {
                this.func_22201_b("READ", p_22210_1_, p_22210_2_, "invalid sector");
                return null;
            }
            this.field_22219_c.seek(n2 * 4096);
            int n4 = this.field_22219_c.readInt();
            if (n4 > 4096 * n3) {
                this.func_22201_b("READ", p_22210_1_, p_22210_2_, "invalid length: " + n4 + " > 4096 * " + n3);
                return null;
            }
            if (n4 <= 0) {
                this.func_22201_b("READ", p_22210_1_, p_22210_2_, "invalid length: " + n4 + " < 1");
                return null;
            }
            byte by = this.field_22219_c.readByte();
            if (by == 1) {
                byte[] byArray = new byte[n4 - 1];
                this.field_22219_c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            if (by == 2) {
                byte[] byArray = new byte[n4 - 1];
                this.field_22219_c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            this.func_22201_b("READ", p_22210_1_, p_22210_2_, "unknown version " + by);
            return null;
        }
        catch (IOException iOException) {
            this.func_22201_b("READ", p_22210_1_, p_22210_2_, "exception");
            return null;
        }
    }

    public DataOutputStream func_22205_b(int p_22205_1_, int p_22205_2_) {
        if (this.func_22206_d(p_22205_1_, p_22205_2_)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, p_22205_1_, p_22205_2_)));
    }

    protected synchronized void func_22203_a(int p_22203_1_, int p_22203_2_, byte[] p_22203_3_, int p_22203_4_) {
        try {
            int n = this.func_22207_e(p_22203_1_, p_22203_2_);
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            int n4 = (p_22203_4_ + 5) / 4096 + 1;
            if (n4 >= 256) {
                return;
            }
            if (n2 != 0 && n3 == n4) {
                this.func_22197_a("SAVE", p_22203_1_, p_22203_2_, p_22203_4_, "rewrite");
                this.func_22200_a(n2, p_22203_3_, p_22203_4_);
            } else {
                int n5;
                int n6;
                for (n6 = 0; n6 < n3; ++n6) {
                    this.field_22216_f.set(n2 + n6, true);
                }
                n6 = this.field_22216_f.indexOf(true);
                int n7 = 0;
                if (n6 != -1) {
                    for (n5 = n6; n5 < this.field_22216_f.size(); ++n5) {
                        if (n7 != 0) {
                            n7 = ((Boolean)this.field_22216_f.get(n5)).booleanValue() ? ++n7 : 0;
                        } else if (((Boolean)this.field_22216_f.get(n5)).booleanValue()) {
                            n6 = n5;
                            n7 = 1;
                        }
                        if (n7 >= n4) break;
                    }
                }
                if (n7 >= n4) {
                    this.func_22197_a("SAVE", p_22203_1_, p_22203_2_, p_22203_4_, "reuse");
                    n2 = n6;
                    this.func_22198_a(p_22203_1_, p_22203_2_, n2 << 8 | n4);
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.field_22216_f.set(n2 + n5, false);
                    }
                    this.func_22200_a(n2, p_22203_3_, p_22203_4_);
                } else {
                    this.func_22197_a("SAVE", p_22203_1_, p_22203_2_, p_22203_4_, "grow");
                    this.field_22219_c.seek(this.field_22219_c.length());
                    n2 = this.field_22216_f.size();
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.field_22219_c.write(field_22213_a);
                        this.field_22216_f.add(false);
                    }
                    this.field_22215_g += 4096 * n4;
                    this.func_22200_a(n2, p_22203_3_, p_22203_4_);
                    this.func_22198_a(p_22203_1_, p_22203_2_, n2 << 8 | n4);
                }
            }
            this.func_22208_b(p_22203_1_, p_22203_2_, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_22200_a(int p_22200_1_, byte[] p_22200_2_, int p_22200_3_) throws IOException {
        this.func_22204_b(" " + p_22200_1_);
        this.field_22219_c.seek(p_22200_1_ * 4096);
        this.field_22219_c.writeInt(p_22200_3_ + 1);
        this.field_22219_c.writeByte(2);
        this.field_22219_c.write(p_22200_2_, 0, p_22200_3_);
    }

    private boolean func_22206_d(int p_22206_1_, int p_22206_2_) {
        return p_22206_1_ < 0 || p_22206_1_ >= 32 || p_22206_2_ < 0 || p_22206_2_ >= 32;
    }

    private int func_22207_e(int p_22207_1_, int p_22207_2_) {
        return this.field_22218_d[p_22207_1_ + p_22207_2_ * 32];
    }

    public boolean func_22202_c(int p_22202_1_, int p_22202_2_) {
        return this.func_22207_e(p_22202_1_, p_22202_2_) != 0;
    }

    private void func_22198_a(int p_22198_1_, int p_22198_2_, int p_22198_3_) throws IOException {
        this.field_22218_d[p_22198_1_ + p_22198_2_ * 32] = p_22198_3_;
        this.field_22219_c.seek((p_22198_1_ + p_22198_2_ * 32) * 4);
        this.field_22219_c.writeInt(p_22198_3_);
    }

    private void func_22208_b(int p_22208_1_, int p_22208_2_, int p_22208_3_) throws IOException {
        this.field_22217_e[p_22208_1_ + p_22208_2_ * 32] = p_22208_3_;
        this.field_22219_c.seek(4096 + (p_22208_1_ + p_22208_2_ * 32) * 4);
        this.field_22219_c.writeInt(p_22208_3_);
    }

    public void func_22196_b() throws IOException {
        this.field_22219_c.close();
    }
}

