/*
 * Decompiled with CFR 0.152.
 */
package argo.format;

import argo.format.JsonEscapedString;
import argo.format.JsonFormatter;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeSet;

public final class CompactJsonFormatter
implements JsonFormatter {
    @Override
    public String format(JsonRootNode par1JsonRootNode) {
        StringWriter stringwriter = new StringWriter();
        try {
            this.format(par1JsonRootNode, stringwriter);
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Coding failure in Argo:  StringWriter gave an IOException", ioexception);
        }
        return stringwriter.toString();
    }

    public void format(JsonRootNode par1JsonRootNode, Writer par2Writer) throws IOException {
        this.formatJsonNode(par1JsonRootNode, par2Writer);
    }

    private void formatJsonNode(JsonNode par1JsonNode, Writer par2Writer) throws IOException {
        boolean flag = true;
        switch (par1JsonNode.getType()) {
            case ARRAY: {
                par2Writer.append('[');
                for (JsonNode jsonnode : par1JsonNode.getElements()) {
                    if (!flag) {
                        par2Writer.append(',');
                    }
                    flag = false;
                    this.formatJsonNode(jsonnode, par2Writer);
                }
                par2Writer.append(']');
                break;
            }
            case OBJECT: {
                par2Writer.append('{');
                for (JsonStringNode jsonstringnode : new TreeSet(par1JsonNode.getFields().keySet())) {
                    if (!flag) {
                        par2Writer.append(',');
                    }
                    flag = false;
                    this.formatJsonNode(jsonstringnode, par2Writer);
                    par2Writer.append(':');
                    this.formatJsonNode((JsonNode)par1JsonNode.getFields().get(jsonstringnode), par2Writer);
                }
                par2Writer.append('}');
                break;
            }
            case STRING: {
                par2Writer.append('\"').append(new JsonEscapedString(par1JsonNode.getText()).toString()).append('\"');
                break;
            }
            case NUMBER: {
                par2Writer.append(par1JsonNode.getText());
                break;
            }
            case FALSE: {
                par2Writer.append("false");
                break;
            }
            case TRUE: {
                par2Writer.append("true");
                break;
            }
            case NULL: {
                par2Writer.append("null");
                break;
            }
            default: {
                throw new RuntimeException("Coding failure in Argo:  Attempt to format a JsonNode of unknown type [" + (Object)((Object)par1JsonNode.getType()) + "];");
            }
        }
    }
}

