/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.ThingWithPosition;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

final class PositionTrackingPushbackReader
implements ThingWithPosition {
    private final PushbackReader pushbackReader;
    private int characterCount = 0;
    private int lineCount = 1;
    private boolean lastCharacterWasCarriageReturn = false;

    public PositionTrackingPushbackReader(Reader par1Reader) {
        this.pushbackReader = new PushbackReader(par1Reader);
    }

    public void unread(char par1) throws IOException {
        --this.characterCount;
        if (this.characterCount < 0) {
            this.characterCount = 0;
        }
        this.pushbackReader.unread(par1);
    }

    public void uncount(char[] par1ArrayOfCharacter) {
        this.characterCount -= par1ArrayOfCharacter.length;
        if (this.characterCount < 0) {
            this.characterCount = 0;
        }
    }

    public int read() throws IOException {
        int i = this.pushbackReader.read();
        this.updateCharacterAndLineCounts(i);
        return i;
    }

    public int read(char[] par1ArrayOfCharacter) throws IOException {
        int i = this.pushbackReader.read(par1ArrayOfCharacter);
        for (char c : par1ArrayOfCharacter) {
            this.updateCharacterAndLineCounts(c);
        }
        return i;
    }

    private void updateCharacterAndLineCounts(int par1) {
        if (13 == par1) {
            this.characterCount = 0;
            ++this.lineCount;
            this.lastCharacterWasCarriageReturn = true;
        } else {
            if (10 == par1 && !this.lastCharacterWasCarriageReturn) {
                this.characterCount = 0;
                ++this.lineCount;
            } else {
                ++this.characterCount;
            }
            this.lastCharacterWasCarriageReturn = false;
        }
    }

    @Override
    public int getColumn() {
        return this.characterCount;
    }

    @Override
    public int getRow() {
        return this.lineCount;
    }
}

