/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.InvalidSyntaxException;
import argo.saj.JsonListener;
import argo.saj.PositionTrackingPushbackReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public final class SajParser {
    public void parse(Reader par1Reader, JsonListener par2JsonListener) throws InvalidSyntaxException, IOException {
        PositionTrackingPushbackReader positiontrackingpushbackreader = new PositionTrackingPushbackReader(par1Reader);
        char c = (char)positiontrackingpushbackreader.read();
        switch (c) {
            case '{': {
                positiontrackingpushbackreader.unread(c);
                par2JsonListener.startDocument();
                this.objectString(positiontrackingpushbackreader, par2JsonListener);
                break;
            }
            case '[': {
                positiontrackingpushbackreader.unread(c);
                par2JsonListener.startDocument();
                this.arrayString(positiontrackingpushbackreader, par2JsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected either [ or { but got [" + c + "].", positiontrackingpushbackreader);
            }
        }
        int i = this.readNextNonWhitespaceChar(positiontrackingpushbackreader);
        if (i != -1) {
            throw new InvalidSyntaxException("Got unexpected trailing character [" + (char)i + "].", positiontrackingpushbackreader);
        }
        par2JsonListener.endDocument();
    }

    private void arrayString(PositionTrackingPushbackReader par1PositionTrackingPushbackReader, JsonListener par2JsonListener) throws InvalidSyntaxException, IOException {
        char c = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        if (c != '[') {
            throw new InvalidSyntaxException("Expected object to start with [ but got [" + c + "].", par1PositionTrackingPushbackReader);
        }
        par2JsonListener.startArray();
        char c1 = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        par1PositionTrackingPushbackReader.unread(c1);
        if (c1 != ']') {
            this.aJsonValue(par1PositionTrackingPushbackReader, par2JsonListener);
        }
        boolean flag = false;
        block4: while (!flag) {
            char c2 = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
            switch (c2) {
                case ',': {
                    this.aJsonValue(par1PositionTrackingPushbackReader, par2JsonListener);
                    continue block4;
                }
                case ']': {
                    flag = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or ] but got [" + c2 + "].", par1PositionTrackingPushbackReader);
        }
        par2JsonListener.endArray();
    }

    private void objectString(PositionTrackingPushbackReader par1PositionTrackingPushbackReader, JsonListener par2JsonListener) throws InvalidSyntaxException, IOException {
        char c = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        if (c != '{') {
            throw new InvalidSyntaxException("Expected object to start with { but got [" + c + "].", par1PositionTrackingPushbackReader);
        }
        par2JsonListener.startObject();
        char c1 = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        par1PositionTrackingPushbackReader.unread(c1);
        if (c1 != '}') {
            this.aFieldToken(par1PositionTrackingPushbackReader, par2JsonListener);
        }
        boolean flag = false;
        block4: while (!flag) {
            char c2 = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
            switch (c2) {
                case ',': {
                    this.aFieldToken(par1PositionTrackingPushbackReader, par2JsonListener);
                    continue block4;
                }
                case '}': {
                    flag = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or } but got [" + c2 + "].", par1PositionTrackingPushbackReader);
        }
        par2JsonListener.endObject();
    }

    private void aFieldToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader, JsonListener par2JsonListener) throws InvalidSyntaxException, IOException {
        char c = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected object identifier to begin with [\"] but got [" + c + "].", par1PositionTrackingPushbackReader);
        }
        par1PositionTrackingPushbackReader.unread(c);
        par2JsonListener.startField(this.stringToken(par1PositionTrackingPushbackReader));
        char c1 = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        if (c1 != ':') {
            throw new InvalidSyntaxException("Expected object identifier to be followed by : but got [" + c1 + "].", par1PositionTrackingPushbackReader);
        }
        this.aJsonValue(par1PositionTrackingPushbackReader, par2JsonListener);
        par2JsonListener.endField();
    }

    private void aJsonValue(PositionTrackingPushbackReader par1PositionTrackingPushbackReader, JsonListener par2JsonListener) throws InvalidSyntaxException, IOException {
        char c = (char)this.readNextNonWhitespaceChar(par1PositionTrackingPushbackReader);
        switch (c) {
            case '\"': {
                par1PositionTrackingPushbackReader.unread(c);
                par2JsonListener.stringValue(this.stringToken(par1PositionTrackingPushbackReader));
                break;
            }
            case 't': {
                char[] ac = new char[3];
                int i = par1PositionTrackingPushbackReader.read(ac);
                if (i != 3 || ac[0] != 'r' || ac[1] != 'u' || ac[2] != 'e') {
                    par1PositionTrackingPushbackReader.uncount(ac);
                    throw new InvalidSyntaxException("Expected 't' to be followed by [[r, u, e]], but got [" + Arrays.toString(ac) + "].", par1PositionTrackingPushbackReader);
                }
                par2JsonListener.trueValue();
                break;
            }
            case 'f': {
                char[] ac1 = new char[4];
                int j = par1PositionTrackingPushbackReader.read(ac1);
                if (j != 4 || ac1[0] != 'a' || ac1[1] != 'l' || ac1[2] != 's' || ac1[3] != 'e') {
                    par1PositionTrackingPushbackReader.uncount(ac1);
                    throw new InvalidSyntaxException("Expected 'f' to be followed by [[a, l, s, e]], but got [" + Arrays.toString(ac1) + "].", par1PositionTrackingPushbackReader);
                }
                par2JsonListener.falseValue();
                break;
            }
            case 'n': {
                char[] ac2 = new char[3];
                int k = par1PositionTrackingPushbackReader.read(ac2);
                if (k != 3 || ac2[0] != 'u' || ac2[1] != 'l' || ac2[2] != 'l') {
                    par1PositionTrackingPushbackReader.uncount(ac2);
                    throw new InvalidSyntaxException("Expected 'n' to be followed by [[u, l, l]], but got [" + Arrays.toString(ac2) + "].", par1PositionTrackingPushbackReader);
                }
                par2JsonListener.nullValue();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                par1PositionTrackingPushbackReader.unread(c);
                par2JsonListener.numberValue(this.numberToken(par1PositionTrackingPushbackReader));
                break;
            }
            case '{': {
                par1PositionTrackingPushbackReader.unread(c);
                this.objectString(par1PositionTrackingPushbackReader, par2JsonListener);
                break;
            }
            case '[': {
                par1PositionTrackingPushbackReader.unread(c);
                this.arrayString(par1PositionTrackingPushbackReader, par2JsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Invalid character at start of value [" + c + "].", par1PositionTrackingPushbackReader);
            }
        }
    }

    private String numberToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if ('-' == c) {
            stringbuilder.append('-');
        } else {
            par1PositionTrackingPushbackReader.unread(c);
        }
        stringbuilder.append(this.nonNegativeNumberToken(par1PositionTrackingPushbackReader));
        return stringbuilder.toString();
    }

    private String nonNegativeNumberToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if ('0' == c) {
            stringbuilder.append('0');
            stringbuilder.append(this.possibleFractionalComponent(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.possibleExponent(par1PositionTrackingPushbackReader));
        } else {
            par1PositionTrackingPushbackReader.unread(c);
            stringbuilder.append(this.nonZeroDigitToken(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.digitString(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.possibleFractionalComponent(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.possibleExponent(par1PositionTrackingPushbackReader));
        }
        return stringbuilder.toString();
    }

    private char nonZeroDigitToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        char c;
        char c1 = (char)par1PositionTrackingPushbackReader.read();
        switch (c1) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c1;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c1 + "].", par1PositionTrackingPushbackReader);
            }
        }
        return c;
    }

    private char digitToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        char c;
        char c1 = (char)par1PositionTrackingPushbackReader.read();
        switch (c1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c1;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c1 + "].", par1PositionTrackingPushbackReader);
            }
        }
        return c;
    }

    private String digitString(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException {
        StringBuilder stringbuilder = new StringBuilder();
        boolean flag = false;
        block3: while (!flag) {
            char c = (char)par1PositionTrackingPushbackReader.read();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    stringbuilder.append(c);
                    continue block3;
                }
            }
            flag = true;
            par1PositionTrackingPushbackReader.unread(c);
        }
        return stringbuilder.toString();
    }

    private String possibleFractionalComponent(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if (c == '.') {
            stringbuilder.append('.');
            stringbuilder.append(this.digitToken(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.digitString(par1PositionTrackingPushbackReader));
        } else {
            par1PositionTrackingPushbackReader.unread(c);
        }
        return stringbuilder.toString();
    }

    private String possibleExponent(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if (c == '.' || c == 'E') {
            stringbuilder.append('E');
            stringbuilder.append(this.possibleSign(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.digitToken(par1PositionTrackingPushbackReader));
            stringbuilder.append(this.digitString(par1PositionTrackingPushbackReader));
        } else {
            par1PositionTrackingPushbackReader.unread(c);
        }
        return stringbuilder.toString();
    }

    private String possibleSign(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if (c == '+' || c == '-') {
            stringbuilder.append(c);
        } else {
            par1PositionTrackingPushbackReader.unread(c);
        }
        return stringbuilder.toString();
    }

    private String stringToken(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws InvalidSyntaxException, IOException {
        StringBuilder stringbuilder = new StringBuilder();
        char c = (char)par1PositionTrackingPushbackReader.read();
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected [\"] but got [" + c + "].", par1PositionTrackingPushbackReader);
        }
        boolean flag = false;
        block4: while (!flag) {
            char c1 = (char)par1PositionTrackingPushbackReader.read();
            switch (c1) {
                case '\"': {
                    flag = true;
                    continue block4;
                }
                case '\\': {
                    char c2 = this.escapedStringChar(par1PositionTrackingPushbackReader);
                    stringbuilder.append(c2);
                    continue block4;
                }
            }
            stringbuilder.append(c1);
        }
        return stringbuilder.toString();
    }

    private char escapedStringChar(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        char c;
        char c1 = (char)par1PositionTrackingPushbackReader.read();
        switch (c1) {
            case '\"': {
                c = '\"';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            case '/': {
                c = '/';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'u': {
                c = (char)this.hexadecimalNumber(par1PositionTrackingPushbackReader);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Unrecognised escape character [" + c1 + "].", par1PositionTrackingPushbackReader);
            }
        }
        return c;
    }

    private int hexadecimalNumber(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException, InvalidSyntaxException {
        int j;
        char[] ac = new char[4];
        int i = par1PositionTrackingPushbackReader.read(ac);
        if (i != 4) {
            throw new InvalidSyntaxException("Expected a 4 digit hexidecimal number but got only [" + i + "], namely [" + String.valueOf(ac, 0, i) + "].", par1PositionTrackingPushbackReader);
        }
        try {
            j = Integer.parseInt(String.valueOf(ac), 16);
        }
        catch (NumberFormatException numberformatexception) {
            par1PositionTrackingPushbackReader.uncount(ac);
            throw new InvalidSyntaxException("Unable to parse [" + String.valueOf(ac) + "] as a hexidecimal number.", numberformatexception, par1PositionTrackingPushbackReader);
        }
        return j;
    }

    private int readNextNonWhitespaceChar(PositionTrackingPushbackReader par1PositionTrackingPushbackReader) throws IOException {
        int i;
        boolean flag = false;
        do {
            i = par1PositionTrackingPushbackReader.read();
            switch (i) {
                default: {
                    flag = true;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
        } while (!flag);
        return i;
    }
}

