/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class ActiveRenderInfo {
    public static float objectX = 0.0f;
    public static float objectY = 0.0f;
    public static float objectZ = 0.0f;
    private static IntBuffer viewport = GLAllocation.createDirectIntBuffer(16);
    private static FloatBuffer modelview = GLAllocation.createDirectFloatBuffer(16);
    private static FloatBuffer projection = GLAllocation.createDirectFloatBuffer(16);
    private static FloatBuffer objectCoords = GLAllocation.createDirectFloatBuffer(3);
    public static float rotationX;
    public static float rotationXZ;
    public static float rotationZ;
    public static float rotationYZ;
    public static float rotationXY;

    public static void updateRenderInfo(EntityPlayer par0EntityPlayer, boolean par1) {
        GL11.glGetFloat((int)2982, (FloatBuffer)modelview);
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        GL11.glGetInteger((int)2978, (IntBuffer)viewport);
        float f = (viewport.get(0) + viewport.get(2)) / 2;
        float f1 = (viewport.get(1) + viewport.get(3)) / 2;
        GLU.gluUnProject((float)f, (float)f1, (float)0.0f, (FloatBuffer)modelview, (FloatBuffer)projection, (IntBuffer)viewport, (FloatBuffer)objectCoords);
        objectX = objectCoords.get(0);
        objectY = objectCoords.get(1);
        objectZ = objectCoords.get(2);
        int i = par1 ? 1 : 0;
        float f2 = par0EntityPlayer.rotationPitch;
        float f3 = par0EntityPlayer.rotationYaw;
        rotationX = MathHelper.cos(f3 * (float)Math.PI / 180.0f) * (float)(1 - i * 2);
        rotationZ = MathHelper.sin(f3 * (float)Math.PI / 180.0f) * (float)(1 - i * 2);
        rotationYZ = -rotationZ * MathHelper.sin(f2 * (float)Math.PI / 180.0f) * (float)(1 - i * 2);
        rotationXY = rotationX * MathHelper.sin(f2 * (float)Math.PI / 180.0f) * (float)(1 - i * 2);
        rotationXZ = MathHelper.cos(f2 * (float)Math.PI / 180.0f);
    }

    public static Vec3D projectViewFromEntity(EntityLiving par0EntityLiving, double par1) {
        double d = par0EntityLiving.prevPosX + (par0EntityLiving.posX - par0EntityLiving.prevPosX) * par1;
        double d1 = par0EntityLiving.prevPosY + (par0EntityLiving.posY - par0EntityLiving.prevPosY) * par1 + (double)par0EntityLiving.getEyeHeight();
        double d2 = par0EntityLiving.prevPosZ + (par0EntityLiving.posZ - par0EntityLiving.prevPosZ) * par1;
        double d3 = d + (double)(objectX * 1.0f);
        double d4 = d1 + (double)(objectY * 1.0f);
        double d5 = d2 + (double)(objectZ * 1.0f);
        return Vec3D.createVector(d3, d4, d5);
    }

    public static int getBlockIdAtEntityViewpoint(World par0World, EntityLiving par1EntityLiving, float par2) {
        float f;
        float f1;
        Vec3D vec3d = ActiveRenderInfo.projectViewFromEntity(par1EntityLiving, par2);
        ChunkPosition chunkposition = new ChunkPosition(vec3d);
        int i = par0World.getBlockId(chunkposition.x, chunkposition.y, chunkposition.z);
        if (i != 0 && Block.blocksList[i].blockMaterial.isLiquid() && vec3d.yCoord >= (double)(f1 = (float)(chunkposition.y + 1) - (f = BlockFluid.getFluidHeightPercent(par0World.getBlockMetadata(chunkposition.x, chunkposition.y, chunkposition.z)) - 0.1111111f))) {
            i = par0World.getBlockId(chunkposition.x, chunkposition.y + 1, chunkposition.z);
        }
        return i;
    }
}

