/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.src.AnvilChunkLoaderPending;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityList;
import net.minecraft.src.ExtendedBlockStorage;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IThreadedFileIO;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.NextTickListEntry;
import net.minecraft.src.NibbleArray;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.ThreadedFileIOBase;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class AnvilChunkLoader
implements IThreadedFileIO,
IChunkLoader {
    private List field_48451_a = new ArrayList();
    private Set field_48449_b = new HashSet();
    private Object field_48450_c = new Object();
    private final File chunkSaveLocation;

    public AnvilChunkLoader(File par1File) {
        this.chunkSaveLocation = par1File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk loadChunk(World par1World, int par2, int par3) throws IOException {
        NBTTagCompound nbttagcompound = null;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(par2, par3);
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48449_b.contains(chunkcoordintpair)) {
                for (int i = 0; i < this.field_48451_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48427_a.equals(chunkcoordintpair)) continue;
                    nbttagcompound = ((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48426_b;
                    break;
                }
            }
        }
        if (nbttagcompound == null) {
            DataInputStream datainputstream = RegionFileCache.getChunkInputStream(this.chunkSaveLocation, par2, par3);
            if (datainputstream != null) {
                nbttagcompound = CompressedStreamTools.read(datainputstream);
            } else {
                return null;
            }
        }
        return this.func_48443_a(par1World, par2, par3, nbttagcompound);
    }

    protected Chunk func_48443_a(World par1World, int par2, int par3, NBTTagCompound par4NBTTagCompound) {
        if (!par4NBTTagCompound.hasKey("Level")) {
            System.out.println("Chunk file at " + par2 + "," + par3 + " is missing level data, skipping");
            return null;
        }
        if (!par4NBTTagCompound.getCompoundTag("Level").hasKey("Sections")) {
            System.out.println("Chunk file at " + par2 + "," + par3 + " is missing block data, skipping");
            return null;
        }
        Chunk chunk = this.readChunkFromNBT(par1World, par4NBTTagCompound.getCompoundTag("Level"));
        if (!chunk.isAtLocation(par2, par3)) {
            System.out.println("Chunk file at " + par2 + "," + par3 + " is in the wrong location; relocating. (Expected " + par2 + ", " + par3 + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
            par4NBTTagCompound.setInteger("xPos", par2);
            par4NBTTagCompound.setInteger("zPos", par3);
            chunk = this.readChunkFromNBT(par1World, par4NBTTagCompound.getCompoundTag("Level"));
        }
        chunk.removeUnknownBlocks();
        return chunk;
    }

    @Override
    public void saveChunk(World par1World, Chunk par2Chunk) throws IOException {
        par1World.checkSessionLock();
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.setTag("Level", nbttagcompound1);
            this.writeChunkToNBT(par2Chunk, par1World, nbttagcompound1);
            this.func_48446_a(par2Chunk.getChunkCoordIntPair(), nbttagcompound);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_48446_a(ChunkCoordIntPair par1ChunkCoordIntPair, NBTTagCompound par2NBTTagCompound) {
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48449_b.contains(par1ChunkCoordIntPair)) {
                for (int i = 0; i < this.field_48451_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48427_a.equals(par1ChunkCoordIntPair)) continue;
                    this.field_48451_a.set(i, new AnvilChunkLoaderPending(par1ChunkCoordIntPair, par2NBTTagCompound));
                    return;
                }
            }
            this.field_48451_a.add(new AnvilChunkLoaderPending(par1ChunkCoordIntPair, par2NBTTagCompound));
            this.field_48449_b.add(par1ChunkCoordIntPair);
            ThreadedFileIOBase.threadedIOInstance.queueIO(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeNextIO() {
        AnvilChunkLoaderPending anvilchunkloaderpending = null;
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48451_a.size() <= 0) {
                return false;
            }
            anvilchunkloaderpending = (AnvilChunkLoaderPending)this.field_48451_a.remove(0);
            this.field_48449_b.remove(anvilchunkloaderpending.field_48427_a);
        }
        if (anvilchunkloaderpending != null) {
            try {
                this.func_48447_a(anvilchunkloaderpending);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    private void func_48447_a(AnvilChunkLoaderPending par1AnvilChunkLoaderPending) throws IOException {
        DataOutputStream dataoutputstream = RegionFileCache.getChunkOutputStream(this.chunkSaveLocation, par1AnvilChunkLoaderPending.field_48427_a.chunkXPos, par1AnvilChunkLoaderPending.field_48427_a.chunkZPosition);
        CompressedStreamTools.write(par1AnvilChunkLoaderPending.field_48426_b, dataoutputstream);
        dataoutputstream.close();
    }

    @Override
    public void saveExtraChunkData(World world, Chunk chunk) throws IOException {
    }

    @Override
    public void chunkTick() {
    }

    @Override
    public void saveExtraData() {
    }

    private void writeChunkToNBT(Chunk par1Chunk, World par2World, NBTTagCompound par3NBTTagCompound) {
        par2World.checkSessionLock();
        par3NBTTagCompound.setInteger("xPos", par1Chunk.xPosition);
        par3NBTTagCompound.setInteger("zPos", par1Chunk.zPosition);
        par3NBTTagCompound.setLong("LastUpdate", par2World.getWorldTime());
        par3NBTTagCompound.func_48183_a("HeightMap", par1Chunk.heightMap);
        par3NBTTagCompound.setBoolean("TerrainPopulated", par1Chunk.isTerrainPopulated);
        ExtendedBlockStorage[] aextendedblockstorage = par1Chunk.getBlockStorageArray();
        NBTTagList nbttaglist = new NBTTagList("Sections");
        for (ExtendedBlockStorage extendedblockstorage : aextendedblockstorage) {
            if (extendedblockstorage == null || extendedblockstorage.func_48700_f() == 0) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Y", (byte)(extendedblockstorage.getYLocation() >> 4 & 0xFF));
            nbttagcompound.setByteArray("Blocks", extendedblockstorage.func_48692_g());
            if (extendedblockstorage.getBlockMSBArray() != null) {
                nbttagcompound.setByteArray("Add", extendedblockstorage.getBlockMSBArray().data);
            }
            nbttagcompound.setByteArray("Data", extendedblockstorage.func_48697_j().data);
            nbttagcompound.setByteArray("SkyLight", extendedblockstorage.getSkylightArray().data);
            nbttagcompound.setByteArray("BlockLight", extendedblockstorage.getBlocklightArray().data);
            nbttaglist.appendTag(nbttagcompound);
        }
        par3NBTTagCompound.setTag("Sections", nbttaglist);
        par3NBTTagCompound.setByteArray("Biomes", par1Chunk.getBiomeArray());
        par1Chunk.hasEntities = false;
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int j = 0; j < par1Chunk.entityLists.length; ++j) {
            for (Entity entity : par1Chunk.entityLists[j]) {
                par1Chunk.hasEntities = true;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                if (!entity.addEntityID(nbttagcompound1)) continue;
                nbttaglist1.appendTag(nbttagcompound1);
            }
        }
        par3NBTTagCompound.setTag("Entities", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (TileEntity tileentity : par1Chunk.chunkTileEntityMap.values()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            tileentity.writeToNBT(nbttagcompound2);
            nbttaglist2.appendTag(nbttagcompound2);
        }
        par3NBTTagCompound.setTag("TileEntities", nbttaglist2);
        List list = par2World.getPendingBlockUpdates(par1Chunk, false);
        if (list != null) {
            long l = par2World.getWorldTime();
            NBTTagList nbttaglist3 = new NBTTagList();
            for (NextTickListEntry nextticklistentry : list) {
                NBTTagCompound nbttagcompound3 = new NBTTagCompound();
                nbttagcompound3.setInteger("i", nextticklistentry.blockID);
                nbttagcompound3.setInteger("x", nextticklistentry.xCoord);
                nbttagcompound3.setInteger("y", nextticklistentry.yCoord);
                nbttagcompound3.setInteger("z", nextticklistentry.zCoord);
                nbttagcompound3.setInteger("t", (int)(nextticklistentry.scheduledTime - l));
                nbttaglist3.appendTag(nbttagcompound3);
            }
            par3NBTTagCompound.setTag("TileTicks", nbttaglist3);
        }
    }

    private Chunk readChunkFromNBT(World par1World, NBTTagCompound par2NBTTagCompound) {
        NBTTagList nbttaglist3;
        NBTTagList nbttaglist2;
        NBTTagList nbttaglist1;
        int i = par2NBTTagCompound.getInteger("xPos");
        int j = par2NBTTagCompound.getInteger("zPos");
        Chunk chunk = new Chunk(par1World, i, j);
        chunk.heightMap = par2NBTTagCompound.func_48182_l("HeightMap");
        chunk.isTerrainPopulated = par2NBTTagCompound.getBoolean("TerrainPopulated");
        NBTTagList nbttaglist = par2NBTTagCompound.getTagList("Sections");
        int byte0 = 16;
        ExtendedBlockStorage[] aextendedblockstorage = new ExtendedBlockStorage[byte0];
        for (int k = 0; k < nbttaglist.tagCount(); ++k) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(k);
            byte byte1 = nbttagcompound.getByte("Y");
            ExtendedBlockStorage extendedblockstorage = new ExtendedBlockStorage(byte1 << 4);
            extendedblockstorage.setBlockLSBArray(nbttagcompound.getByteArray("Blocks"));
            if (nbttagcompound.hasKey("Add")) {
                extendedblockstorage.setBlockMSBArray(new NibbleArray(nbttagcompound.getByteArray("Add"), 4));
            }
            extendedblockstorage.setBlockMetadataArray(new NibbleArray(nbttagcompound.getByteArray("Data"), 4));
            extendedblockstorage.setSkylightArray(new NibbleArray(nbttagcompound.getByteArray("SkyLight"), 4));
            extendedblockstorage.setBlocklightArray(new NibbleArray(nbttagcompound.getByteArray("BlockLight"), 4));
            extendedblockstorage.func_48708_d();
            aextendedblockstorage[byte1] = extendedblockstorage;
        }
        chunk.setStorageArrays(aextendedblockstorage);
        if (par2NBTTagCompound.hasKey("Biomes")) {
            chunk.setBiomeArray(par2NBTTagCompound.getByteArray("Biomes"));
        }
        if ((nbttaglist1 = par2NBTTagCompound.getTagList("Entities")) != null) {
            for (int l = 0; l < nbttaglist1.tagCount(); ++l) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist1.tagAt(l);
                Entity entity = EntityList.createEntityFromNBT(nbttagcompound1, par1World);
                chunk.hasEntities = true;
                if (entity == null) continue;
                chunk.addEntity(entity);
            }
        }
        if ((nbttaglist2 = par2NBTTagCompound.getTagList("TileEntities")) != null) {
            for (int i1 = 0; i1 < nbttaglist2.tagCount(); ++i1) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist2.tagAt(i1);
                TileEntity tileentity = TileEntity.createAndLoadEntity(nbttagcompound2);
                if (tileentity == null) continue;
                chunk.addTileEntity(tileentity);
            }
        }
        if (par2NBTTagCompound.hasKey("TileTicks") && (nbttaglist3 = par2NBTTagCompound.getTagList("TileTicks")) != null) {
            for (int j1 = 0; j1 < nbttaglist3.tagCount(); ++j1) {
                NBTTagCompound nbttagcompound3 = (NBTTagCompound)nbttaglist3.tagAt(j1);
                par1World.scheduleBlockUpdateFromLoad(nbttagcompound3.getInteger("x"), nbttagcompound3.getInteger("y"), nbttagcompound3.getInteger("z"), nbttagcompound3.getInteger("i"), nbttagcompound3.getInteger("t"));
            }
        }
        return chunk;
    }
}

