/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AnvilConverterData;
import net.minecraft.src.AnvilSaveConverterFileFilter;
import net.minecraft.src.AnvilSaveHandler;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.RegionFile;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveFormatOld;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldType;

public class AnvilSaveConverter
extends SaveFormatOld {
    public AnvilSaveConverter(File par1File) {
        super(par1File);
    }

    @Override
    public String getFormatName() {
        return "Anvil";
    }

    @Override
    public List getSaveList() {
        File[] afile;
        ArrayList<SaveFormatComparator> arraylist = new ArrayList<SaveFormatComparator>();
        for (File file : afile = this.savesDirectory.listFiles()) {
            String s;
            WorldInfo worldinfo;
            if (!file.isDirectory() || (worldinfo = this.getWorldInfo(s = file.getName())) == null || worldinfo.getSaveVersion() != 19132 && worldinfo.getSaveVersion() != 19133) continue;
            boolean flag = worldinfo.getSaveVersion() != this.func_48431_c();
            String s1 = worldinfo.getWorldName();
            if (s1 == null || MathHelper.stringNullOrLengthZero(s1)) {
                s1 = s;
            }
            long l = 0L;
            arraylist.add(new SaveFormatComparator(s, s1, worldinfo.getLastTimePlayed(), l, worldinfo.getGameType(), flag, worldinfo.isHardcoreModeEnabled()));
        }
        return arraylist;
    }

    protected int func_48431_c() {
        return 19133;
    }

    @Override
    public void flushCache() {
        RegionFileCache.clearRegionFileReferences();
    }

    @Override
    public ISaveHandler getSaveLoader(String par1Str, boolean par2) {
        return new AnvilSaveHandler(this.savesDirectory, par1Str, par2);
    }

    @Override
    public boolean isOldMapFormat(String par1Str) {
        WorldInfo worldinfo = this.getWorldInfo(par1Str);
        return worldinfo != null && worldinfo.getSaveVersion() != this.func_48431_c();
    }

    @Override
    public boolean convertMapFormat(String par1Str, IProgressUpdate par2IProgressUpdate) {
        par2IProgressUpdate.setLoadingProgress(0);
        ArrayList arraylist = new ArrayList();
        ArrayList arraylist1 = new ArrayList();
        ArrayList arraylist2 = new ArrayList();
        File file = new File(this.savesDirectory, par1Str);
        File file1 = new File(file, "DIM-1");
        File file2 = new File(file, "DIM1");
        System.out.println("Scanning folders...");
        this.func_48432_a(file, arraylist);
        if (file1.exists()) {
            this.func_48432_a(file1, arraylist1);
        }
        if (file2.exists()) {
            this.func_48432_a(file2, arraylist2);
        }
        int i = arraylist.size() + arraylist1.size() + arraylist2.size();
        System.out.println("Total conversion count is " + i);
        WorldInfo worldinfo = this.getWorldInfo(par1Str);
        WorldChunkManager obj = null;
        obj = worldinfo.getTerrainType() == WorldType.FLAT ? new WorldChunkManagerHell(BiomeGenBase.plains, 0.5f, 0.5f) : new WorldChunkManager(worldinfo.getSeed(), worldinfo.getTerrainType());
        this.func_48428_a(new File(file, "region"), arraylist, obj, 0, i, par2IProgressUpdate);
        this.func_48428_a(new File(file1, "region"), arraylist1, new WorldChunkManagerHell(BiomeGenBase.hell, 1.0f, 0.0f), arraylist.size(), i, par2IProgressUpdate);
        this.func_48428_a(new File(file2, "region"), arraylist2, new WorldChunkManagerHell(BiomeGenBase.sky, 0.5f, 0.0f), arraylist.size() + arraylist1.size(), i, par2IProgressUpdate);
        worldinfo.setSaveVersion(19133);
        if (worldinfo.getTerrainType() == WorldType.DEFAULT_1_1) {
            worldinfo.setTerrainType(WorldType.DEFAULT);
        }
        this.func_48429_d(par1Str);
        ISaveHandler isavehandler = this.getSaveLoader(par1Str, false);
        isavehandler.saveWorldInfo(worldinfo);
        return true;
    }

    private void func_48429_d(String par1Str) {
        File file = new File(this.savesDirectory, par1Str);
        if (!file.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file1 = new File(file, "level.dat");
        if (!file1.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file2 = new File(file, "level.dat_mcr");
        if (!file1.renameTo(file2)) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
        }
    }

    private void func_48428_a(File par1File, ArrayList par2ArrayList, WorldChunkManager par3WorldChunkManager, int par4, int par5, IProgressUpdate par6IProgressUpdate) {
        for (File file : par2ArrayList) {
            this.func_48430_a(par1File, file, par3WorldChunkManager, par4, par5, par6IProgressUpdate);
            int i = (int)Math.round(100.0 * (double)(++par4) / (double)par5);
            par6IProgressUpdate.setLoadingProgress(i);
        }
    }

    private void func_48430_a(File par1File, File par2File, WorldChunkManager par3WorldChunkManager, int par4, int par5, IProgressUpdate par6IProgressUpdate) {
        try {
            String s = par2File.getName();
            RegionFile regionfile = new RegionFile(par2File);
            RegionFile regionfile1 = new RegionFile(new File(par1File, s.substring(0, s.length() - ".mcr".length()) + ".mca"));
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    if (!regionfile.isChunkSaved(i, j) || regionfile1.isChunkSaved(i, j)) continue;
                    DataInputStream datainputstream = regionfile.getChunkDataInputStream(i, j);
                    if (datainputstream == null) {
                        System.out.println("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound nbttagcompound = CompressedStreamTools.read(datainputstream);
                    datainputstream.close();
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Level");
                    AnvilConverterData anvilconverterdata = ChunkLoader.load(nbttagcompound1);
                    NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                    NBTTagCompound nbttagcompound3 = new NBTTagCompound();
                    nbttagcompound2.setTag("Level", nbttagcompound3);
                    ChunkLoader.convertToAnvilFormat(anvilconverterdata, nbttagcompound3, par3WorldChunkManager);
                    DataOutputStream dataoutputstream = regionfile1.getChunkDataOutputStream(i, j);
                    CompressedStreamTools.write(nbttagcompound2, dataoutputstream);
                    dataoutputstream.close();
                }
                int k = (int)Math.round(100.0 * (double)(par4 * 1024) / (double)(par5 * 1024));
                int l = (int)Math.round(100.0 * (double)((i + 1) * 32 + par4 * 1024) / (double)(par5 * 1024));
                if (l <= k) continue;
                par6IProgressUpdate.setLoadingProgress(l);
            }
            regionfile.close();
            regionfile1.close();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void func_48432_a(File par1File, ArrayList par2ArrayList) {
        File file = new File(par1File, "region");
        File[] afile = file.listFiles(new AnvilSaveConverterFileFilter(this));
        if (afile != null) {
            for (File file1 : afile) {
                par2ArrayList.add(file1);
            }
        }
    }
}

