/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeDecorator;
import net.minecraft.src.BiomeGenBeach;
import net.minecraft.src.BiomeGenDesert;
import net.minecraft.src.BiomeGenEnd;
import net.minecraft.src.BiomeGenForest;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.BiomeGenHills;
import net.minecraft.src.BiomeGenJungle;
import net.minecraft.src.BiomeGenMushroomIsland;
import net.minecraft.src.BiomeGenOcean;
import net.minecraft.src.BiomeGenPlains;
import net.minecraft.src.BiomeGenRiver;
import net.minecraft.src.BiomeGenSnow;
import net.minecraft.src.BiomeGenSwamp;
import net.minecraft.src.BiomeGenTaiga;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityEnderman;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntitySquid;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenBigTree;
import net.minecraft.src.WorldGenForest;
import net.minecraft.src.WorldGenSwamp;
import net.minecraft.src.WorldGenTallGrass;
import net.minecraft.src.WorldGenTrees;
import net.minecraft.src.WorldGenerator;

public abstract class BiomeGenBase {
    public static final BiomeGenBase[] biomeList = new BiomeGenBase[256];
    public static final BiomeGenBase ocean = new BiomeGenOcean(0).setColor(112).setBiomeName("Ocean").setMinMaxHeight(-1.0f, 0.4f);
    public static final BiomeGenBase plains = new BiomeGenPlains(1).setColor(9286496).setBiomeName("Plains").setTemperatureRainfall(0.8f, 0.4f);
    public static final BiomeGenBase desert = new BiomeGenDesert(2).setColor(16421912).setBiomeName("Desert").setDisableRain().setTemperatureRainfall(2.0f, 0.0f).setMinMaxHeight(0.1f, 0.2f);
    public static final BiomeGenBase extremeHills = new BiomeGenHills(3).setColor(0x606060).setBiomeName("Extreme Hills").setMinMaxHeight(0.2f, 1.3f).setTemperatureRainfall(0.2f, 0.3f);
    public static final BiomeGenBase forest = new BiomeGenForest(4).setColor(353825).setBiomeName("Forest").func_4124_a(5159473).setTemperatureRainfall(0.7f, 0.8f);
    public static final BiomeGenBase taiga = new BiomeGenTaiga(5).setColor(747097).setBiomeName("Taiga").func_4124_a(5159473).setEnableSnow().setTemperatureRainfall(0.05f, 0.8f).setMinMaxHeight(0.1f, 0.4f);
    public static final BiomeGenBase swampland = new BiomeGenSwamp(6).setColor(522674).setBiomeName("Swampland").func_4124_a(9154376).setMinMaxHeight(-0.2f, 0.1f).setTemperatureRainfall(0.8f, 0.9f);
    public static final BiomeGenBase river = new BiomeGenRiver(7).setColor(255).setBiomeName("River").setMinMaxHeight(-0.5f, 0.0f);
    public static final BiomeGenBase hell = new BiomeGenHell(8).setColor(0xFF0000).setBiomeName("Hell").setDisableRain().setTemperatureRainfall(2.0f, 0.0f);
    public static final BiomeGenBase sky = new BiomeGenEnd(9).setColor(0x8080FF).setBiomeName("Sky").setDisableRain();
    public static final BiomeGenBase frozenOcean = new BiomeGenOcean(10).setColor(0x9090A0).setBiomeName("FrozenOcean").setEnableSnow().setMinMaxHeight(-1.0f, 0.5f).setTemperatureRainfall(0.0f, 0.5f);
    public static final BiomeGenBase frozenRiver = new BiomeGenRiver(11).setColor(0xA0A0FF).setBiomeName("FrozenRiver").setEnableSnow().setMinMaxHeight(-0.5f, 0.0f).setTemperatureRainfall(0.0f, 0.5f);
    public static final BiomeGenBase icePlains = new BiomeGenSnow(12).setColor(0xFFFFFF).setBiomeName("Ice Plains").setEnableSnow().setTemperatureRainfall(0.0f, 0.5f);
    public static final BiomeGenBase iceMountains = new BiomeGenSnow(13).setColor(0xA0A0A0).setBiomeName("Ice Mountains").setEnableSnow().setMinMaxHeight(0.2f, 1.2f).setTemperatureRainfall(0.0f, 0.5f);
    public static final BiomeGenBase mushroomIsland = new BiomeGenMushroomIsland(14).setColor(0xFF00FF).setBiomeName("MushroomIsland").setTemperatureRainfall(0.9f, 1.0f).setMinMaxHeight(0.2f, 1.0f);
    public static final BiomeGenBase mushroomIslandShore = new BiomeGenMushroomIsland(15).setColor(0xA000FF).setBiomeName("MushroomIslandShore").setTemperatureRainfall(0.9f, 1.0f).setMinMaxHeight(-1.0f, 0.1f);
    public static final BiomeGenBase beach = new BiomeGenBeach(16).setColor(16440917).setBiomeName("Beach").setTemperatureRainfall(0.8f, 0.4f).setMinMaxHeight(0.0f, 0.1f);
    public static final BiomeGenBase desertHills = new BiomeGenDesert(17).setColor(13786898).setBiomeName("DesertHills").setDisableRain().setTemperatureRainfall(2.0f, 0.0f).setMinMaxHeight(0.2f, 0.7f);
    public static final BiomeGenBase forestHills = new BiomeGenForest(18).setColor(2250012).setBiomeName("ForestHills").func_4124_a(5159473).setTemperatureRainfall(0.7f, 0.8f).setMinMaxHeight(0.2f, 0.6f);
    public static final BiomeGenBase taigaHills = new BiomeGenTaiga(19).setColor(1456435).setBiomeName("TaigaHills").setEnableSnow().func_4124_a(5159473).setTemperatureRainfall(0.05f, 0.8f).setMinMaxHeight(0.2f, 0.7f);
    public static final BiomeGenBase extremeHillsEdge = new BiomeGenHills(20).setColor(7501978).setBiomeName("Extreme Hills Edge").setMinMaxHeight(0.2f, 0.8f).setTemperatureRainfall(0.2f, 0.3f);
    public static final BiomeGenBase jungle = new BiomeGenJungle(21).setColor(5470985).setBiomeName("Jungle").func_4124_a(5470985).setTemperatureRainfall(1.2f, 0.9f).setMinMaxHeight(0.2f, 0.4f);
    public static final BiomeGenBase jungleHills = new BiomeGenJungle(22).setColor(2900485).setBiomeName("JungleHills").func_4124_a(5470985).setTemperatureRainfall(1.2f, 0.9f).setMinMaxHeight(1.8f, 0.2f);
    public String biomeName;
    public int color;
    public byte topBlock;
    public byte fillerBlock;
    public int field_6502_q;
    public float minHeight;
    public float maxHeight;
    public float temperature;
    public float rainfall;
    public int waterColorMultiplier;
    public BiomeDecorator biomeDecorator;
    protected List spawnableMonsterList;
    protected List spawnableCreatureList;
    protected List spawnableWaterCreatureList;
    private boolean enableSnow;
    private boolean enableRain;
    public final int biomeID;
    protected WorldGenTrees worldGenTrees;
    protected WorldGenBigTree worldGenBigTree;
    protected WorldGenForest worldGenForest;
    protected WorldGenSwamp worldGenSwamp;

    protected BiomeGenBase(int par1) {
        this.topBlock = (byte)Block.grass.blockID;
        this.fillerBlock = (byte)Block.dirt.blockID;
        this.field_6502_q = 5169201;
        this.minHeight = 0.1f;
        this.maxHeight = 0.3f;
        this.temperature = 0.5f;
        this.rainfall = 0.5f;
        this.waterColorMultiplier = 0xFFFFFF;
        this.spawnableMonsterList = new ArrayList();
        this.spawnableCreatureList = new ArrayList();
        this.spawnableWaterCreatureList = new ArrayList();
        this.enableRain = true;
        this.worldGenTrees = new WorldGenTrees(false);
        this.worldGenBigTree = new WorldGenBigTree(false);
        this.worldGenForest = new WorldGenForest(false);
        this.worldGenSwamp = new WorldGenSwamp();
        this.biomeID = par1;
        BiomeGenBase.biomeList[par1] = this;
        this.biomeDecorator = this.createBiomeDecorator();
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
    }

    protected BiomeDecorator createBiomeDecorator() {
        return new BiomeDecorator(this);
    }

    private BiomeGenBase setTemperatureRainfall(float par1, float par2) {
        if (par1 > 0.1f && par1 < 0.2f) {
            throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
        }
        this.temperature = par1;
        this.rainfall = par2;
        return this;
    }

    private BiomeGenBase setMinMaxHeight(float par1, float par2) {
        this.minHeight = par1;
        this.maxHeight = par2;
        return this;
    }

    private BiomeGenBase setDisableRain() {
        this.enableRain = false;
        return this;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random par1Random) {
        if (par1Random.nextInt(10) == 0) {
            return this.worldGenBigTree;
        }
        return this.worldGenTrees;
    }

    public WorldGenerator func_48410_b(Random par1Random) {
        return new WorldGenTallGrass(Block.tallGrass.blockID, 1);
    }

    protected BiomeGenBase setEnableSnow() {
        this.enableSnow = true;
        return this;
    }

    protected BiomeGenBase setBiomeName(String par1Str) {
        this.biomeName = par1Str;
        return this;
    }

    protected BiomeGenBase func_4124_a(int par1) {
        this.field_6502_q = par1;
        return this;
    }

    protected BiomeGenBase setColor(int par1) {
        this.color = par1;
        return this;
    }

    public int getSkyColorByTemp(float par1) {
        if ((par1 /= 3.0f) < -1.0f) {
            par1 = -1.0f;
        }
        if (par1 > 1.0f) {
            par1 = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - par1 * 0.05f, 0.5f + par1 * 0.1f, 1.0f).getRGB();
    }

    public List getSpawnableList(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            return this.spawnableMonsterList;
        }
        if (par1EnumCreatureType == EnumCreatureType.creature) {
            return this.spawnableCreatureList;
        }
        if (par1EnumCreatureType == EnumCreatureType.waterCreature) {
            return this.spawnableWaterCreatureList;
        }
        return null;
    }

    public boolean getEnableSnow() {
        return this.enableSnow;
    }

    public boolean canSpawnLightningBolt() {
        if (this.enableSnow) {
            return false;
        }
        return this.enableRain;
    }

    public boolean isHighHumidity() {
        return this.rainfall > 0.85f;
    }

    public float getSpawningChance() {
        return 0.1f;
    }

    public final int getIntRainfall() {
        return (int)(this.rainfall * 65536.0f);
    }

    public final int getIntTemperature() {
        return (int)(this.temperature * 65536.0f);
    }

    public final float getFloatRainfall() {
        return this.rainfall;
    }

    public final float getFloatTemperature() {
        return this.temperature;
    }

    public void decorate(World par1World, Random par2Random, int par3, int par4) {
        this.biomeDecorator.decorate(par1World, par2Random, par3, par4);
    }

    public int getBiomeGrassColor() {
        double d = MathHelper.clamp_float(this.getFloatTemperature(), 0.0f, 1.0f);
        double d1 = MathHelper.clamp_float(this.getFloatRainfall(), 0.0f, 1.0f);
        return ColorizerGrass.getGrassColor(d, d1);
    }

    public int getBiomeFoliageColor() {
        double d = MathHelper.clamp_float(this.getFloatTemperature(), 0.0f, 1.0f);
        double d1 = MathHelper.clamp_float(this.getFloatRainfall(), 0.0f, 1.0f);
        return ColorizerFoliage.getFoliageColor(d, d1);
    }
}

