/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityOcelot;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenHugeTrees;
import net.minecraft.src.WorldGenShrub;
import net.minecraft.src.WorldGenTallGrass;
import net.minecraft.src.WorldGenTrees;
import net.minecraft.src.WorldGenVines;
import net.minecraft.src.WorldGenerator;

public class BiomeGenJungle
extends BiomeGenBase {
    public BiomeGenJungle(int par1) {
        super(par1);
        this.biomeDecorator.treesPerChunk = 50;
        this.biomeDecorator.grassPerChunk = 25;
        this.biomeDecorator.flowersPerChunk = 4;
        this.spawnableMonsterList.add(new SpawnListEntry(EntityOcelot.class, 2, 1, 1));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
    }

    @Override
    public WorldGenerator getRandomWorldGenForTrees(Random par1Random) {
        if (par1Random.nextInt(10) == 0) {
            return this.worldGenBigTree;
        }
        if (par1Random.nextInt(2) == 0) {
            return new WorldGenShrub(3, 0);
        }
        if (par1Random.nextInt(3) == 0) {
            return new WorldGenHugeTrees(false, 10 + par1Random.nextInt(20), 3, 3);
        }
        return new WorldGenTrees(false, 4 + par1Random.nextInt(7), 3, 3, true);
    }

    @Override
    public WorldGenerator func_48410_b(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass(Block.tallGrass.blockID, 2);
        }
        return new WorldGenTallGrass(Block.tallGrass.blockID, 1);
    }

    @Override
    public void decorate(World par1World, Random par2Random, int par3, int par4) {
        super.decorate(par1World, par2Random, par3, par4);
        WorldGenVines worldgenvines = new WorldGenVines();
        for (int i = 0; i < 50; ++i) {
            int j = par3 + par2Random.nextInt(16) + 8;
            int byte0 = 64;
            int k = par4 + par2Random.nextInt(16) + 8;
            worldgenvines.generate(par1World, par2Random, j, byte0, k);
        }
    }
}

