/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockDirectional;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Direction;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumStatus;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockBed
extends BlockDirectional {
    public static final int[][] headBlockToFootBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockBed(int par1) {
        super(par1, 134, Material.cloth);
        this.setBounds();
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        EnumStatus enumstatus;
        if (par1World.isRemote) {
            return true;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (!BlockBed.isBlockFootOfBed(i)) {
            int j = BlockBed.getDirection(i);
            if (par1World.getBlockId(par2 += headBlockToFootBlockMap[j][0], par3, par4 += headBlockToFootBlockMap[j][1]) != this.blockID) {
                return true;
            }
            i = par1World.getBlockMetadata(par2, par3, par4);
        }
        if (!par1World.worldProvider.canRespawnHere()) {
            double d = (double)par2 + 0.5;
            double d1 = (double)par3 + 0.5;
            double d2 = (double)par4 + 0.5;
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            int k = BlockBed.getDirection(i);
            if (par1World.getBlockId(par2 += headBlockToFootBlockMap[k][0], par3, par4 += headBlockToFootBlockMap[k][1]) == this.blockID) {
                par1World.setBlockWithNotify(par2, par3, par4, 0);
                d = (d + (double)par2 + 0.5) / 2.0;
                d1 = (d1 + (double)par3 + 0.5) / 2.0;
                d2 = (d2 + (double)par4 + 0.5) / 2.0;
            }
            par1World.newExplosion(null, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, 5.0f, true);
            return true;
        }
        if (BlockBed.isBedOccupied(i)) {
            EntityPlayer entityplayer = null;
            for (EntityPlayer entityplayer1 : par1World.playerEntities) {
                if (!entityplayer1.isPlayerSleeping()) continue;
                ChunkCoordinates chunkcoordinates = entityplayer1.playerLocation;
                if (chunkcoordinates.posX != par2 || chunkcoordinates.posY != par3 || chunkcoordinates.posZ != par4) continue;
                entityplayer = entityplayer1;
            }
            if (entityplayer == null) {
                BlockBed.setBedOccupied(par1World, par2, par3, par4, false);
            } else {
                par5EntityPlayer.addChatMessage("tile.bed.occupied");
                return true;
            }
        }
        if ((enumstatus = par5EntityPlayer.sleepInBedAt(par2, par3, par4)) == EnumStatus.OK) {
            BlockBed.setBedOccupied(par1World, par2, par3, par4, true);
            return true;
        }
        if (enumstatus == EnumStatus.NOT_POSSIBLE_NOW) {
            par5EntityPlayer.addChatMessage("tile.bed.noSleep");
        } else if (enumstatus == EnumStatus.NOT_SAFE) {
            par5EntityPlayer.addChatMessage("tile.bed.notSafe");
        }
        return true;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par1 == 0) {
            return Block.planks.blockIndexInTexture;
        }
        int i = BlockBed.getDirection(par2);
        int j = Direction.bedDirection[i][par1];
        if (BlockBed.isBlockFootOfBed(par2)) {
            if (j == 2) {
                return this.blockIndexInTexture + 2 + 16;
            }
            if (j == 5 || j == 4) {
                return this.blockIndexInTexture + 1 + 16;
            }
            return this.blockIndexInTexture + 1;
        }
        if (j == 3) {
            return this.blockIndexInTexture - 1 + 16;
        }
        if (j == 5 || j == 4) {
            return this.blockIndexInTexture + 16;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public int getRenderType() {
        return 14;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBounds();
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = BlockBed.getDirection(i);
        if (BlockBed.isBlockFootOfBed(i)) {
            if (par1World.getBlockId(par2 - headBlockToFootBlockMap[j][0], par3, par4 - headBlockToFootBlockMap[j][1]) != this.blockID) {
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            }
        } else if (par1World.getBlockId(par2 + headBlockToFootBlockMap[j][0], par3, par4 + headBlockToFootBlockMap[j][1]) != this.blockID) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            if (!par1World.isRemote) {
                this.dropBlockAsItem(par1World, par2, par3, par4, i, 0);
            }
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        if (BlockBed.isBlockFootOfBed(par1)) {
            return 0;
        }
        return Item.bed.shiftedIndex;
    }

    private void setBounds() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static boolean isBlockFootOfBed(int par0) {
        return (par0 & 8) != 0;
    }

    public static boolean isBedOccupied(int par0) {
        return (par0 & 4) != 0;
    }

    public static void setBedOccupied(World par0World, int par1, int par2, int par3, boolean par4) {
        int i = par0World.getBlockMetadata(par1, par2, par3);
        i = par4 ? (i |= 4) : (i &= 0xFFFFFFFB);
        par0World.setBlockMetadataWithNotify(par1, par2, par3, i);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World par0World, int par1, int par2, int par3, int par4) {
        int i = par0World.getBlockMetadata(par1, par2, par3);
        int j = BlockDirectional.getDirection(i);
        for (int k = 0; k <= 1; ++k) {
            int l = par1 - headBlockToFootBlockMap[j][0] * k - 1;
            int i1 = par3 - headBlockToFootBlockMap[j][1] * k - 1;
            int j1 = l + 2;
            int k1 = i1 + 2;
            for (int l1 = l; l1 <= j1; ++l1) {
                for (int i2 = i1; i2 <= k1; ++i2) {
                    if (!par0World.isBlockNormalCube(l1, par2 - 1, i2) || !par0World.isAirBlock(l1, par2, i2) || !par0World.isAirBlock(l1, par2 + 1, i2)) continue;
                    if (par4 > 0) {
                        --par4;
                        continue;
                    }
                    return new ChunkCoordinates(l1, par2, i2);
                }
            }
        }
        return null;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (!BlockBed.isBlockFootOfBed(par5)) {
            super.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, par6, 0);
        }
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

