/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.World;

public class BlockBrewingStand
extends BlockContainer {
    private Random rand = new Random();

    public BlockBrewingStand(int par1) {
        super(par1, Material.iron);
        this.blockIndexInTexture = 157;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 25;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityBrewingStand();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        this.setBlockBounds(0.4375f, 0.0f, 0.4375f, 0.5625f, 0.875f, 0.5625f);
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        this.setBlockBoundsForItemRender();
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        TileEntityBrewingStand tileentitybrewingstand = (TileEntityBrewingStand)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitybrewingstand != null) {
            par5EntityPlayer.displayGUIBrewingStand(tileentitybrewingstand);
        }
        return true;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        double d = (float)par2 + 0.4f + par5Random.nextFloat() * 0.2f;
        double d1 = (float)par3 + 0.7f + par5Random.nextFloat() * 0.3f;
        double d2 = (float)par4 + 0.4f + par5Random.nextFloat() * 0.2f;
        par1World.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        TileEntity tileentity = par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentity != null && tileentity instanceof TileEntityBrewingStand) {
            TileEntityBrewingStand tileentitybrewingstand = (TileEntityBrewingStand)tileentity;
            for (int i = 0; i < tileentitybrewingstand.getSizeInventory(); ++i) {
                ItemStack itemstack = tileentitybrewingstand.getStackInSlot(i);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int j = this.rand.nextInt(21) + 10;
                    if (j > itemstack.stackSize) {
                        j = itemstack.stackSize;
                    }
                    itemstack.stackSize -= j;
                    EntityItem entityitem = new EntityItem(par1World, (float)par2 + f, (float)par3 + f1, (float)par4 + f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                    par1World.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.brewingStand.shiftedIndex;
    }
}

