/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockCactus
extends Block {
    protected BlockCactus(int par1, int par2) {
        super(par1, par2, Material.cactus);
        this.setTickRandomly(true);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isAirBlock(par2, par3 + 1, par4)) {
            int i = 1;
            while (par1World.getBlockId(par2, par3 - i, par4) == this.blockID) {
                ++i;
            }
            if (i < 3) {
                int j = par1World.getBlockMetadata(par2, par3, par4);
                if (j == 15) {
                    par1World.setBlockWithNotify(par2, par3 + 1, par4, this.blockID);
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, 0);
                } else {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, j + 1);
                }
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, (float)(par3 + 1) - f, (float)(par4 + 1) - f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, par3 + 1, (float)(par4 + 1) - f);
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 13;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (!super.canPlaceBlockAt(par1World, par2, par3, par4)) {
            return false;
        }
        return this.canBlockStay(par1World, par2, par3, par4);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockMaterial(par2 - 1, par3, par4).isSolid()) {
            return false;
        }
        if (par1World.getBlockMaterial(par2 + 1, par3, par4).isSolid()) {
            return false;
        }
        if (par1World.getBlockMaterial(par2, par3, par4 - 1).isSolid()) {
            return false;
        }
        if (par1World.getBlockMaterial(par2, par3, par4 + 1).isSolid()) {
            return false;
        }
        int i = par1World.getBlockId(par2, par3 - 1, par4);
        return i == Block.cactus.blockID || i == Block.sand.blockID;
    }

    @Override
    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        par5Entity.attackEntityFrom(DamageSource.cactus, 1);
    }
}

