/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockCake
extends Block {
    protected BlockCake(int par1, int par2) {
        super(par1, par2, Material.cake);
        this.setTickRandomly(true);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        float f = 0.0625f;
        float f1 = (float)(1 + i * 2) / 16.0f;
        float f2 = 0.5f;
        this.setBlockBounds(f1, 0.0f, f, 1.0f - f, f2, 1.0f - f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.0625f;
        float f1 = 0.5f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, f1, 1.0f - f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        float f = 0.0625f;
        float f1 = (float)(1 + i * 2) / 16.0f;
        float f2 = 0.5f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f1, par3, (float)par4 + f, (float)(par2 + 1) - f, (float)par3 + f2 - f, (float)(par4 + 1) - f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        float f = 0.0625f;
        float f1 = (float)(1 + i * 2) / 16.0f;
        float f2 = 0.5f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f1, par3, (float)par4 + f, (float)(par2 + 1) - f, (float)par3 + f2, (float)(par4 + 1) - f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par1 == 1) {
            return this.blockIndexInTexture;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture + 3;
        }
        if (par2 > 0 && par1 == 4) {
            return this.blockIndexInTexture + 2;
        }
        return this.blockIndexInTexture + 1;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 1) {
            return this.blockIndexInTexture;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture + 3;
        }
        return this.blockIndexInTexture + 1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.eatCakeSlice(par1World, par2, par3, par4, par5EntityPlayer);
        return true;
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.eatCakeSlice(par1World, par2, par3, par4, par5EntityPlayer);
    }

    private void eatCakeSlice(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par5EntityPlayer.canEat(false)) {
            par5EntityPlayer.getFoodStats().addStats(2, 0.1f);
            int i = par1World.getBlockMetadata(par2, par3, par4) + 1;
            if (i >= 6) {
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            } else {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
                par1World.markBlockAsNeedsUpdate(par2, par3, par4);
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (!super.canPlaceBlockAt(par1World, par2, par3, par4)) {
            return false;
        }
        return this.canBlockStay(par1World, par2, par3, par4);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        return par1World.getBlockMaterial(par2, par3 - 1, par4).isSolid();
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }
}

