/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.EntityItem;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class BlockCrops
extends BlockFlower {
    protected BlockCrops(int par1, int par2) {
        super(par1, par2);
        this.blockIndexInTexture = par2;
        this.setTickRandomly(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int par1) {
        return par1 == Block.tilledField.blockID;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        float f;
        int i;
        super.updateTick(par1World, par2, par3, par4, par5Random);
        if (par1World.getBlockLightValue(par2, par3 + 1, par4) >= 9 && (i = par1World.getBlockMetadata(par2, par3, par4)) < 7 && par5Random.nextInt((int)(25.0f / (f = this.getGrowthRate(par1World, par2, par3, par4))) + 1) == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, ++i);
        }
    }

    public void fertilize(World par1World, int par2, int par3, int par4) {
        par1World.setBlockMetadataWithNotify(par2, par3, par4, 7);
    }

    private float getGrowthRate(World par1World, int par2, int par3, int par4) {
        float f = 1.0f;
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        int i1 = par1World.getBlockId(par2 - 1, par3, par4 - 1);
        int j1 = par1World.getBlockId(par2 + 1, par3, par4 - 1);
        int k1 = par1World.getBlockId(par2 + 1, par3, par4 + 1);
        int l1 = par1World.getBlockId(par2 - 1, par3, par4 + 1);
        boolean flag = k == this.blockID || l == this.blockID;
        boolean flag1 = i == this.blockID || j == this.blockID;
        boolean flag2 = i1 == this.blockID || j1 == this.blockID || k1 == this.blockID || l1 == this.blockID;
        for (int i2 = par2 - 1; i2 <= par2 + 1; ++i2) {
            for (int j2 = par4 - 1; j2 <= par4 + 1; ++j2) {
                int k2 = par1World.getBlockId(i2, par3 - 1, j2);
                float f1 = 0.0f;
                if (k2 == Block.tilledField.blockID) {
                    f1 = 1.0f;
                    if (par1World.getBlockMetadata(i2, par3 - 1, j2) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != par2 || j2 != par4) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par2 < 0) {
            par2 = 7;
        }
        return this.blockIndexInTexture + par2;
    }

    @Override
    public int getRenderType() {
        return 6;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        super.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, par6, 0);
        if (par1World.isRemote) {
            return;
        }
        int i = 3 + par7;
        for (int j = 0; j < i; ++j) {
            if (par1World.rand.nextInt(15) > par5) continue;
            float f = 0.7f;
            float f1 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            float f2 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            float f3 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(par1World, (float)par2 + f1, (float)par3 + f2, (float)par4 + f3, new ItemStack(Item.seeds));
            entityitem.delayBeforeCanPickup = 10;
            par1World.spawnEntityInWorld(entityitem);
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        if (par1 == 7) {
            return Item.wheat.shiftedIndex;
        }
        return -1;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 1;
    }
}

