/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockRail;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;

public class BlockDetectorRail
extends BlockRail {
    public BlockDetectorRail(int par1, int par2) {
        super(par1, par2, true);
        this.setTickRandomly(true);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) != 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(par1World, par2, par3, par4, i);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) == 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(par1World, par2, par3, par4, i);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) != 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        if ((par1World.getBlockMetadata(par2, par3, par4) & 8) == 0) {
            return false;
        }
        return par5 == 1;
    }

    private void setStateIfMinecartInteractsWithRail(World par1World, int par2, int par3, int par4, int par5) {
        boolean flag = (par5 & 8) != 0;
        boolean flag1 = false;
        float f = 0.125f;
        List list = par1World.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, (float)(par3 + 1) - f, (float)(par4 + 1) - f));
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, par5 | 8);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        }
        if (!flag1 && flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, par5 & 7);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        }
        if (flag1) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
        }
    }
}

