/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockDragonEgg
extends Block {
    public BlockDragonEgg(int par1, int par2) {
        super(par1, par2, Material.dragonEgg);
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.fallIfPossible(par1World, par2, par3, par4);
    }

    private void fallIfPossible(World par1World, int par2, int par3, int par4) {
        int i = par2;
        int j = par3;
        int k = par4;
        if (BlockSand.canFallBelow(par1World, i, j - 1, k) && j >= 0) {
            int byte0 = 32;
            if (BlockSand.fallInstantly || !par1World.checkChunksExist(par2 - byte0, par3 - byte0, par4 - byte0, par2 + byte0, par3 + byte0, par4 + byte0)) {
                par1World.setBlockWithNotify(par2, par3, par4, 0);
                while (BlockSand.canFallBelow(par1World, par2, par3 - 1, par4) && par3 > 0) {
                    --par3;
                }
                if (par3 > 0) {
                    par1World.setBlockWithNotify(par2, par3, par4, this.blockID);
                }
            } else {
                EntityFallingSand entityfallingsand = new EntityFallingSand(par1World, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, this.blockID);
                par1World.spawnEntityInWorld(entityfallingsand);
            }
        }
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.teleportNearby(par1World, par2, par3, par4);
        return true;
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.teleportNearby(par1World, par2, par3, par4);
    }

    private void teleportNearby(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockId(par2, par3, par4) != this.blockID) {
            return;
        }
        if (par1World.isRemote) {
            return;
        }
        for (int i = 0; i < 1000; ++i) {
            int l;
            int k;
            int j = par2 + par1World.rand.nextInt(16) - par1World.rand.nextInt(16);
            if (par1World.getBlockId(j, k = par3 + par1World.rand.nextInt(8) - par1World.rand.nextInt(8), l = par4 + par1World.rand.nextInt(16) - par1World.rand.nextInt(16)) != 0) continue;
            par1World.setBlockAndMetadataWithNotify(j, k, l, this.blockID, par1World.getBlockMetadata(par2, par3, par4));
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            int c = 128;
            for (int i1 = 0; i1 < c; ++i1) {
                double d = par1World.rand.nextDouble();
                float f = (par1World.rand.nextFloat() - 0.5f) * 0.2f;
                float f1 = (par1World.rand.nextFloat() - 0.5f) * 0.2f;
                float f2 = (par1World.rand.nextFloat() - 0.5f) * 0.2f;
                double d1 = (double)j + (double)(par2 - j) * d + (par1World.rand.nextDouble() - 0.5) * 1.0 + 0.5;
                double d2 = (double)k + (double)(par3 - k) * d + par1World.rand.nextDouble() * 1.0 - 0.5;
                double d3 = (double)l + (double)(par4 - l) * d + (par1World.rand.nextDouble() - 0.5) * 1.0 + 0.5;
                par1World.spawnParticle("portal", d1, d2, d3, f, f1, f2);
            }
            return;
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return super.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 27;
    }
}

