/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFlowing
extends BlockFluid {
    int numAdjacentSources = 0;
    boolean[] isOptimalFlowDirection = new boolean[4];
    int[] flowCost = new int[4];

    protected BlockFlowing(int par1, Material par2Material) {
        super(par1, par2Material);
    }

    private void updateFlow(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        par1World.setBlockAndMetadata(par2, par3, par4, this.blockID + 1, i);
        par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        par1World.markBlockNeedsUpdate(par2, par3, par4);
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.blockMaterial != Material.lava;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = this.getFlowDecay(par1World, par2, par3, par4);
        int byte0 = 1;
        if (this.blockMaterial == Material.lava && !par1World.worldProvider.isHellWorld) {
            byte0 = 2;
        }
        boolean flag = true;
        if (i > 0) {
            int j = -100;
            this.numAdjacentSources = 0;
            j = this.getSmallestFlowDecay(par1World, par2 - 1, par3, par4, j);
            j = this.getSmallestFlowDecay(par1World, par2 + 1, par3, par4, j);
            j = this.getSmallestFlowDecay(par1World, par2, par3, par4 - 1, j);
            int k = (j = this.getSmallestFlowDecay(par1World, par2, par3, par4 + 1, j)) + byte0;
            if (k >= 8 || j < 0) {
                k = -1;
            }
            if (this.getFlowDecay(par1World, par2, par3 + 1, par4) >= 0) {
                int i1 = this.getFlowDecay(par1World, par2, par3 + 1, par4);
                k = i1 >= 8 ? i1 : i1 + 8;
            }
            if (this.numAdjacentSources >= 2 && this.blockMaterial == Material.water) {
                if (par1World.getBlockMaterial(par2, par3 - 1, par4).isSolid()) {
                    k = 0;
                } else if (par1World.getBlockMaterial(par2, par3 - 1, par4) == this.blockMaterial && par1World.getBlockMetadata(par2, par3, par4) == 0) {
                    k = 0;
                }
            }
            if (this.blockMaterial == Material.lava && i < 8 && k < 8 && k > i && par5Random.nextInt(4) != 0) {
                k = i;
                flag = false;
            }
            if (k != i) {
                i = k;
                if (i < 0) {
                    par1World.setBlockWithNotify(par2, par3, par4, 0);
                } else {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
                    par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
                    par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
                }
            } else if (flag) {
                this.updateFlow(par1World, par2, par3, par4);
            }
        } else {
            this.updateFlow(par1World, par2, par3, par4);
        }
        if (this.liquidCanDisplaceBlock(par1World, par2, par3 - 1, par4)) {
            if (this.blockMaterial == Material.lava && par1World.getBlockMaterial(par2, par3 - 1, par4) == Material.water) {
                par1World.setBlockWithNotify(par2, par3 - 1, par4, Block.stone.blockID);
                this.triggerLavaMixEffects(par1World, par2, par3 - 1, par4);
                return;
            }
            if (i >= 8) {
                par1World.setBlockAndMetadataWithNotify(par2, par3 - 1, par4, this.blockID, i);
            } else {
                par1World.setBlockAndMetadataWithNotify(par2, par3 - 1, par4, this.blockID, i + 8);
            }
        } else if (i >= 0 && (i == 0 || this.blockBlocksFlow(par1World, par2, par3 - 1, par4))) {
            boolean[] aflag = this.getOptimalFlowDirections(par1World, par2, par3, par4);
            int l = i + byte0;
            if (i >= 8) {
                l = 1;
            }
            if (l >= 8) {
                return;
            }
            if (aflag[0]) {
                this.flowIntoBlock(par1World, par2 - 1, par3, par4, l);
            }
            if (aflag[1]) {
                this.flowIntoBlock(par1World, par2 + 1, par3, par4, l);
            }
            if (aflag[2]) {
                this.flowIntoBlock(par1World, par2, par3, par4 - 1, l);
            }
            if (aflag[3]) {
                this.flowIntoBlock(par1World, par2, par3, par4 + 1, l);
            }
        }
    }

    private void flowIntoBlock(World par1World, int par2, int par3, int par4, int par5) {
        if (this.liquidCanDisplaceBlock(par1World, par2, par3, par4)) {
            int i = par1World.getBlockId(par2, par3, par4);
            if (i > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.triggerLavaMixEffects(par1World, par2, par3, par4);
                } else {
                    Block.blocksList[i].dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
                }
            }
            par1World.setBlockAndMetadataWithNotify(par2, par3, par4, this.blockID, par5);
        }
    }

    private int calculateFlowCost(World par1World, int par2, int par3, int par4, int par5, int par6) {
        int i = 1000;
        for (int j = 0; j < 4; ++j) {
            int j1;
            if (j == 0 && par6 == 1 || j == 1 && par6 == 0 || j == 2 && par6 == 3 || j == 3 && par6 == 2) continue;
            int k = par2;
            int l = par3;
            int i1 = par4;
            if (j == 0) {
                --k;
            }
            if (j == 1) {
                ++k;
            }
            if (j == 2) {
                --i1;
            }
            if (j == 3) {
                ++i1;
            }
            if (this.blockBlocksFlow(par1World, k, l, i1) || par1World.getBlockMaterial(k, l, i1) == this.blockMaterial && par1World.getBlockMetadata(k, l, i1) == 0) continue;
            if (!this.blockBlocksFlow(par1World, k, l - 1, i1)) {
                return par5;
            }
            if (par5 >= 4 || (j1 = this.calculateFlowCost(par1World, k, l, i1, par5 + 1, j)) >= i) continue;
            i = j1;
        }
        return i;
    }

    private boolean[] getOptimalFlowDirections(World par1World, int par2, int par3, int par4) {
        for (int i = 0; i < 4; ++i) {
            this.flowCost[i] = 1000;
            int k = par2;
            int j1 = par3;
            int k1 = par4;
            if (i == 0) {
                --k;
            }
            if (i == 1) {
                ++k;
            }
            if (i == 2) {
                --k1;
            }
            if (i == 3) {
                ++k1;
            }
            if (this.blockBlocksFlow(par1World, k, j1, k1) || par1World.getBlockMaterial(k, j1, k1) == this.blockMaterial && par1World.getBlockMetadata(k, j1, k1) == 0) continue;
            this.flowCost[i] = !this.blockBlocksFlow(par1World, k, j1 - 1, k1) ? 0 : this.calculateFlowCost(par1World, k, j1, k1, 1, i);
        }
        int j = this.flowCost[0];
        for (int l = 1; l < 4; ++l) {
            if (this.flowCost[l] >= j) continue;
            j = this.flowCost[l];
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            this.isOptimalFlowDirection[i1] = this.flowCost[i1] == j;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockBlocksFlow(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockId(par2, par3, par4);
        if (i == Block.doorWood.blockID || i == Block.doorSteel.blockID || i == Block.signPost.blockID || i == Block.ladder.blockID || i == Block.reed.blockID) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        Material material = Block.blocksList[i].blockMaterial;
        if (material == Material.portal) {
            return true;
        }
        return material.blocksMovement();
    }

    protected int getSmallestFlowDecay(World par1World, int par2, int par3, int par4, int par5) {
        int i = this.getFlowDecay(par1World, par2, par3, par4);
        if (i < 0) {
            return par5;
        }
        if (i == 0) {
            ++this.numAdjacentSources;
        }
        if (i >= 8) {
            i = 0;
        }
        return par5 >= 0 && i >= par5 ? par5 : i;
    }

    private boolean liquidCanDisplaceBlock(World par1World, int par2, int par3, int par4) {
        Material material = par1World.getBlockMaterial(par2, par3, par4);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.blockBlocksFlow(par1World, par2, par3, par4);
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        if (par1World.getBlockId(par2, par3, par4) == this.blockID) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
        }
    }
}

