/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class BlockFluid
extends Block {
    protected BlockFluid(int par1, Material par2Material) {
        super(par1, (par2Material != Material.lava ? 12 : 14) * 16 + 13, par2Material);
        float f = 0.0f;
        float f1 = 0.0f;
        this.setBlockBounds(0.0f + f1, 0.0f + f, 0.0f + f1, 1.0f + f1, 1.0f + f, 1.0f + f1);
        this.setTickRandomly(true);
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.blockMaterial != Material.lava;
    }

    @Override
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.blockMaterial == Material.water) {
            int i = 0;
            int j = 0;
            int k = 0;
            for (int l = -1; l <= 1; ++l) {
                for (int i1 = -1; i1 <= 1; ++i1) {
                    int j1 = par1IBlockAccess.getBiomeGenForCoords((int)(par2 + i1), (int)(par4 + l)).waterColorMultiplier;
                    i += (j1 & 0xFF0000) >> 16;
                    j += (j1 & 0xFF00) >> 8;
                    k += j1 & 0xFF;
                }
            }
            return (i / 9 & 0xFF) << 16 | (j / 9 & 0xFF) << 8 | k / 9 & 0xFF;
        }
        return 0xFFFFFF;
    }

    public static float getFluidHeightPercent(int par0) {
        if (par0 >= 8) {
            par0 = 0;
        }
        float f = (float)(par0 + 1) / 9.0f;
        return f;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 0 || par1 == 1) {
            return this.blockIndexInTexture;
        }
        return this.blockIndexInTexture + 1;
    }

    protected int getFlowDecay(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockMaterial(par2, par3, par4) != this.blockMaterial) {
            return -1;
        }
        return par1World.getBlockMetadata(par2, par3, par4);
    }

    protected int getEffectiveFlowDecay(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (par1IBlockAccess.getBlockMaterial(par2, par3, par4) != this.blockMaterial) {
            return -1;
        }
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (i >= 8) {
            i = 0;
        }
        return i;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int par1, boolean par2) {
        return par2 && par1 == 0;
    }

    @Override
    public boolean isBlockSolid(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Material material = par1IBlockAccess.getBlockMaterial(par2, par3, par4);
        if (material == this.blockMaterial) {
            return false;
        }
        if (par5 == 1) {
            return true;
        }
        if (material == Material.ice) {
            return false;
        }
        return super.isBlockSolid(par1IBlockAccess, par2, par3, par4, par5);
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Material material = par1IBlockAccess.getBlockMaterial(par2, par3, par4);
        if (material == this.blockMaterial) {
            return false;
        }
        if (par5 == 1) {
            return true;
        }
        if (material == Material.ice) {
            return false;
        }
        return super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public int getRenderType() {
        return 4;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    private Vec3D getFlowVector(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int i = this.getEffectiveFlowDecay(par1IBlockAccess, par2, par3, par4);
        for (int j = 0; j < 4; ++j) {
            int j1;
            int k = par2;
            int l = par3;
            int i1 = par4;
            if (j == 0) {
                --k;
            }
            if (j == 1) {
                --i1;
            }
            if (j == 2) {
                ++k;
            }
            if (j == 3) {
                ++i1;
            }
            if ((j1 = this.getEffectiveFlowDecay(par1IBlockAccess, k, l, i1)) < 0) {
                if (par1IBlockAccess.getBlockMaterial(k, l, i1).blocksMovement() || (j1 = this.getEffectiveFlowDecay(par1IBlockAccess, k, l - 1, i1)) < 0) continue;
                int k1 = j1 - (i - 8);
                vec3d = vec3d.addVector((k - par2) * k1, (l - par3) * k1, (i1 - par4) * k1);
                continue;
            }
            if (j1 < 0) continue;
            int l1 = j1 - i;
            vec3d = vec3d.addVector((k - par2) * l1, (l - par3) * l1, (i1 - par4) * l1);
        }
        if (par1IBlockAccess.getBlockMetadata(par2, par3, par4) >= 8) {
            boolean flag = false;
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3, par4 - 1, 2)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3, par4 + 1, 3)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 - 1, par3, par4, 4)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 + 1, par3, par4, 5)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3 + 1, par4 - 1, 2)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3 + 1, par4 + 1, 3)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 - 1, par3 + 1, par4, 4)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 + 1, par3 + 1, par4, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.normalize();
        return vec3d;
    }

    @Override
    public void velocityToAddToEntity(World par1World, int par2, int par3, int par4, Entity par5Entity, Vec3D par6Vec3D) {
        Vec3D vec3d = this.getFlowVector(par1World, par2, par3, par4);
        par6Vec3D.xCoord += vec3d.xCoord;
        par6Vec3D.yCoord += vec3d.yCoord;
        par6Vec3D.zCoord += vec3d.zCoord;
    }

    @Override
    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    @Override
    public int getMixedBrightnessForBlock(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getLightBrightnessForSkyBlocks(par2, par3, par4, 0);
        int j = par1IBlockAccess.getLightBrightnessForSkyBlocks(par2, par3 + 1, par4, 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k <= l ? l : k) | (i1 <= j1 ? j1 : i1) << 16;
    }

    @Override
    public float getBlockBrightness(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        float f1;
        float f = par1IBlockAccess.getLightBrightness(par2, par3, par4);
        return f <= (f1 = par1IBlockAccess.getLightBrightness(par2, par3 + 1, par4)) ? f1 : f;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.updateTick(par1World, par2, par3, par4, par5Random);
    }

    @Override
    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        int k;
        if (this.blockMaterial == Material.water) {
            int i;
            if (par5Random.nextInt(10) == 0 && ((i = par1World.getBlockMetadata(par2, par3, par4)) <= 0 || i >= 8)) {
                par1World.spawnParticle("suspended", (float)par2 + par5Random.nextFloat(), (float)par3 + par5Random.nextFloat(), (float)par4 + par5Random.nextFloat(), 0.0, 0.0, 0.0);
            }
            for (int j = 0; j < 0; ++j) {
                int l = par5Random.nextInt(4);
                int i1 = par2;
                int j1 = par4;
                if (l == 0) {
                    --i1;
                }
                if (l == 1) {
                    ++i1;
                }
                if (l == 2) {
                    --j1;
                }
                if (l == 3) {
                    ++j1;
                }
                if (par1World.getBlockMaterial(i1, par3, j1) != Material.air || !par1World.getBlockMaterial(i1, par3 - 1, j1).blocksMovement() && !par1World.getBlockMaterial(i1, par3 - 1, j1).isLiquid()) continue;
                float f = 0.0625f;
                double d6 = (float)par2 + par5Random.nextFloat();
                double d7 = (float)par3 + par5Random.nextFloat();
                double d8 = (float)par4 + par5Random.nextFloat();
                if (l == 0) {
                    d6 = (float)par2 - f;
                }
                if (l == 1) {
                    d6 = (float)(par2 + 1) + f;
                }
                if (l == 2) {
                    d8 = (float)par4 - f;
                }
                if (l == 3) {
                    d8 = (float)(par4 + 1) + f;
                }
                double d9 = 0.0;
                double d10 = 0.0;
                if (l == 0) {
                    d9 = -f;
                }
                if (l == 1) {
                    d9 = f;
                }
                if (l == 2) {
                    d10 = -f;
                }
                if (l == 3) {
                    d10 = f;
                }
                par1World.spawnParticle("splash", d6, d7, d8, d9, 0.0, d10);
            }
        }
        if (this.blockMaterial == Material.water && par5Random.nextInt(64) == 0 && (k = par1World.getBlockMetadata(par2, par3, par4)) > 0 && k < 8) {
            par1World.playSoundEffect((float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, "liquid.water", par5Random.nextFloat() * 0.25f + 0.75f, par5Random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && par1World.getBlockMaterial(par2, par3 + 1, par4) == Material.air && !par1World.isBlockOpaqueCube(par2, par3 + 1, par4)) {
            if (par5Random.nextInt(100) == 0) {
                double d = (float)par2 + par5Random.nextFloat();
                double d2 = (double)par3 + this.maxY;
                double d4 = (float)par4 + par5Random.nextFloat();
                par1World.spawnParticle("lava", d, d2, d4, 0.0, 0.0, 0.0);
                par1World.playSoundEffect(d, d2, d4, "liquid.lavapop", 0.2f + par5Random.nextFloat() * 0.2f, 0.9f + par5Random.nextFloat() * 0.15f);
            }
            if (par5Random.nextInt(200) == 0) {
                par1World.playSoundEffect(par2, par3, par4, "liquid.lava", 0.2f + par5Random.nextFloat() * 0.2f, 0.9f + par5Random.nextFloat() * 0.15f);
            }
        }
        if (par5Random.nextInt(10) == 0 && par1World.isBlockNormalCube(par2, par3 - 1, par4) && !par1World.getBlockMaterial(par2, par3 - 2, par4).blocksMovement()) {
            double d1 = (float)par2 + par5Random.nextFloat();
            double d3 = (double)par3 - 1.05;
            double d5 = (float)par4 + par5Random.nextFloat();
            if (this.blockMaterial == Material.water) {
                par1World.spawnParticle("dripWater", d1, d3, d5, 0.0, 0.0, 0.0);
            } else {
                par1World.spawnParticle("dripLava", d1, d3, d5, 0.0, 0.0, 0.0);
            }
        }
    }

    public static double func_293_a(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, Material par4Material) {
        Vec3D vec3d = null;
        if (par4Material == Material.water) {
            vec3d = ((BlockFluid)Block.waterMoving).getFlowVector(par0IBlockAccess, par1, par2, par3);
        }
        if (par4Material == Material.lava) {
            vec3d = ((BlockFluid)Block.lavaMoving).getFlowVector(par0IBlockAccess, par1, par2, par3);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        this.checkForHarden(par1World, par2, par3, par4);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        this.checkForHarden(par1World, par2, par3, par4);
    }

    private void checkForHarden(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockId(par2, par3, par4) != this.blockID) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            boolean flag = false;
            if (flag || par1World.getBlockMaterial(par2, par3, par4 - 1) == Material.water) {
                flag = true;
            }
            if (flag || par1World.getBlockMaterial(par2, par3, par4 + 1) == Material.water) {
                flag = true;
            }
            if (flag || par1World.getBlockMaterial(par2 - 1, par3, par4) == Material.water) {
                flag = true;
            }
            if (flag || par1World.getBlockMaterial(par2 + 1, par3, par4) == Material.water) {
                flag = true;
            }
            if (flag || par1World.getBlockMaterial(par2, par3 + 1, par4) == Material.water) {
                flag = true;
            }
            if (flag) {
                int i = par1World.getBlockMetadata(par2, par3, par4);
                if (i == 0) {
                    par1World.setBlockWithNotify(par2, par3, par4, Block.obsidian.blockID);
                } else if (i <= 4) {
                    par1World.setBlockWithNotify(par2, par3, par4, Block.cobblestone.blockID);
                }
                this.triggerLavaMixEffects(par1World, par2, par3, par4);
            }
        }
    }

    protected void triggerLavaMixEffects(World par1World, int par2, int par3, int par4) {
        par1World.playSoundEffect((float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, "random.fizz", 0.5f, 2.6f + (par1World.rand.nextFloat() - par1World.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            par1World.spawnParticle("largesmoke", (double)par2 + Math.random(), (double)par3 + 1.2, (double)par4 + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

