/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRecordPlayer;
import net.minecraft.src.World;

public class BlockJukeBox
extends BlockContainer {
    protected BlockJukeBox(int par1, int par2) {
        super(par1, par2, Material.wood);
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return this.blockIndexInTexture + (par1 != 1 ? 0 : 1);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.getBlockMetadata(par2, par3, par4) == 0) {
            return false;
        }
        this.ejectRecord(par1World, par2, par3, par4);
        return true;
    }

    public void insertRecord(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.isRemote) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentityrecordplayer == null) {
            return;
        }
        tileentityrecordplayer.record = par5;
        tileentityrecordplayer.onInventoryChanged();
        par1World.setBlockMetadataWithNotify(par2, par3, par4, 1);
    }

    public void ejectRecord(World par1World, int par2, int par3, int par4) {
        if (par1World.isRemote) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentityrecordplayer == null) {
            return;
        }
        int i = tileentityrecordplayer.record;
        if (i == 0) {
            return;
        }
        par1World.playAuxSFX(1005, par2, par3, par4, 0);
        par1World.playRecord(null, par2, par3, par4);
        tileentityrecordplayer.record = 0;
        tileentityrecordplayer.onInventoryChanged();
        par1World.setBlockMetadataWithNotify(par2, par3, par4, 0);
        int j = i;
        float f = 0.7f;
        double d = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
        double d2 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(par1World, (double)par2 + d, (double)par3 + d1, (double)par4 + d2, new ItemStack(j, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        par1World.spawnEntityInWorld(entityitem);
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        this.ejectRecord(par1World, par2, par3, par4);
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (par1World.isRemote) {
            return;
        }
        super.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, par6, 0);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityRecordPlayer();
    }
}

