/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.BlockPistonMoving;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Facing;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.World;

public class BlockPistonBase
extends Block {
    private boolean isSticky;
    private static boolean ignoreUpdates;

    public BlockPistonBase(int par1, int par2, boolean par3) {
        super(par1, par2, Material.piston);
        this.isSticky = par3;
        this.setStepSound(soundStoneFootstep);
        this.setHardness(0.5f);
    }

    public int getPistonExtensionTexture() {
        return !this.isSticky ? 107 : 106;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        int i = BlockPistonBase.getOrientation(par2);
        if (i > 5) {
            return this.blockIndexInTexture;
        }
        if (par1 == i) {
            if (BlockPistonBase.isExtended(par2) || this.minX > 0.0 || this.minY > 0.0 || this.minZ > 0.0 || this.maxX < 1.0 || this.maxY < 1.0 || this.maxZ < 1.0) {
                return 110;
            }
            return this.blockIndexInTexture;
        }
        return par1 != Facing.faceToSide[i] ? 108 : 109;
    }

    @Override
    public int getRenderType() {
        return 16;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int i, EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = BlockPistonBase.determineOrientation(par1World, par2, par3, par4, (EntityPlayer)par5EntityLiving);
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
        if (!par1World.isRemote && !ignoreUpdates) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.isRemote && !ignoreUpdates) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        if (!par1World.isRemote && par1World.getBlockTileEntity(par2, par3, par4) == null && !ignoreUpdates) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    private void updatePistonState(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = BlockPistonBase.getOrientation(i);
        boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4, j);
        if (i == 7) {
            return;
        }
        if (flag && !BlockPistonBase.isExtended(i)) {
            if (BlockPistonBase.canExtend(par1World, par2, par3, par4, j)) {
                par1World.setBlockMetadata(par2, par3, par4, j | 8);
                par1World.playNoteAt(par2, par3, par4, 0, j);
            }
        } else if (!flag && BlockPistonBase.isExtended(i)) {
            par1World.setBlockMetadata(par2, par3, par4, j);
            par1World.playNoteAt(par2, par3, par4, 1, j);
        }
    }

    private boolean isIndirectlyPowered(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 != 0 && par1World.isBlockIndirectlyProvidingPowerTo(par2, par3 - 1, par4, 0)) {
            return true;
        }
        if (par5 != 1 && par1World.isBlockIndirectlyProvidingPowerTo(par2, par3 + 1, par4, 1)) {
            return true;
        }
        if (par5 != 2 && par1World.isBlockIndirectlyProvidingPowerTo(par2, par3, par4 - 1, 2)) {
            return true;
        }
        if (par5 != 3 && par1World.isBlockIndirectlyProvidingPowerTo(par2, par3, par4 + 1, 3)) {
            return true;
        }
        if (par5 != 5 && par1World.isBlockIndirectlyProvidingPowerTo(par2 + 1, par3, par4, 5)) {
            return true;
        }
        if (par5 != 4 && par1World.isBlockIndirectlyProvidingPowerTo(par2 - 1, par3, par4, 4)) {
            return true;
        }
        if (par1World.isBlockIndirectlyProvidingPowerTo(par2, par3, par4, 0)) {
            return true;
        }
        if (par1World.isBlockIndirectlyProvidingPowerTo(par2, par3 + 2, par4, 1)) {
            return true;
        }
        if (par1World.isBlockIndirectlyProvidingPowerTo(par2, par3 + 1, par4 - 1, 2)) {
            return true;
        }
        if (par1World.isBlockIndirectlyProvidingPowerTo(par2, par3 + 1, par4 + 1, 3)) {
            return true;
        }
        if (par1World.isBlockIndirectlyProvidingPowerTo(par2 - 1, par3 + 1, par4, 4)) {
            return true;
        }
        return par1World.isBlockIndirectlyProvidingPowerTo(par2 + 1, par3 + 1, par4, 5);
    }

    @Override
    public void powerBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
        ignoreUpdates = true;
        int i = par6;
        if (par5 == 0) {
            if (this.tryExtend(par1World, par2, par3, par4, i)) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 8);
                par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.out", 0.5f, par1World.rand.nextFloat() * 0.25f + 0.6f);
            } else {
                par1World.setBlockMetadata(par2, par3, par4, i);
            }
        } else if (par5 == 1) {
            TileEntity tileentity = par1World.getBlockTileEntity(par2 + Facing.offsetsXForSide[i], par3 + Facing.offsetsYForSide[i], par4 + Facing.offsetsZForSide[i]);
            if (tileentity != null && tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).clearPistonTileEntity();
            }
            par1World.setBlockAndMetadata(par2, par3, par4, Block.pistonMoving.blockID, i);
            par1World.setBlockTileEntity(par2, par3, par4, BlockPistonMoving.getTileEntity(this.blockID, i, i, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                int j = par2 + Facing.offsetsXForSide[i] * 2;
                int k = par3 + Facing.offsetsYForSide[i] * 2;
                int l = par4 + Facing.offsetsZForSide[i] * 2;
                int i1 = par1World.getBlockId(j, k, l);
                int j1 = par1World.getBlockMetadata(j, k, l);
                boolean flag = false;
                if (i1 == Block.pistonMoving.blockID && (tileentity1 = par1World.getBlockTileEntity(j, k, l)) != null && tileentity1 instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).getPistonOrientation() == i && tileentitypiston.isExtending()) {
                    tileentitypiston.clearPistonTileEntity();
                    i1 = tileentitypiston.getStoredBlockID();
                    j1 = tileentitypiston.getBlockMetadata();
                    flag = true;
                }
                if (!flag && i1 > 0 && BlockPistonBase.canPushBlock(i1, par1World, j, k, l, false) && (Block.blocksList[i1].getMobilityFlag() == 0 || i1 == Block.pistonBase.blockID || i1 == Block.pistonStickyBase.blockID)) {
                    par1World.setBlockAndMetadata(par2 += Facing.offsetsXForSide[i], par3 += Facing.offsetsYForSide[i], par4 += Facing.offsetsZForSide[i], Block.pistonMoving.blockID, j1);
                    par1World.setBlockTileEntity(par2, par3, par4, BlockPistonMoving.getTileEntity(i1, j1, i, false, false));
                    ignoreUpdates = false;
                    par1World.setBlockWithNotify(j, k, l, 0);
                    ignoreUpdates = true;
                } else if (!flag) {
                    ignoreUpdates = false;
                    par1World.setBlockWithNotify(par2 + Facing.offsetsXForSide[i], par3 + Facing.offsetsYForSide[i], par4 + Facing.offsetsZForSide[i], 0);
                    ignoreUpdates = true;
                }
            } else {
                ignoreUpdates = false;
                par1World.setBlockWithNotify(par2 + Facing.offsetsXForSide[i], par3 + Facing.offsetsYForSide[i], par4 + Facing.offsetsZForSide[i], 0);
                ignoreUpdates = true;
            }
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.in", 0.5f, par1World.rand.nextFloat() * 0.15f + 0.6f);
        }
        ignoreUpdates = false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (BlockPistonBase.isExtended(i)) {
            switch (BlockPistonBase.getOrientation(i)) {
                case 0: {
                    this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int getOrientation(int par0) {
        return par0 & 7;
    }

    public static boolean isExtended(int par0) {
        return (par0 & 8) != 0;
    }

    private static int determineOrientation(World par0World, int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        int i;
        if (MathHelper.abs((float)par4EntityPlayer.posX - (float)par1) < 2.0f && MathHelper.abs((float)par4EntityPlayer.posZ - (float)par3) < 2.0f) {
            double d = par4EntityPlayer.posY + 1.82 - (double)par4EntityPlayer.yOffset;
            if (d - (double)par2 > 2.0) {
                return 1;
            }
            if ((double)par2 - d > 0.0) {
                return 0;
            }
        }
        if ((i = MathHelper.floor_double((double)(par4EntityPlayer.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) == 0) {
            return 2;
        }
        if (i == 1) {
            return 5;
        }
        if (i == 2) {
            return 3;
        }
        return i != 3 ? 0 : 4;
    }

    private static boolean canPushBlock(int par0, World par1World, int par2, int par3, int par4, boolean par5) {
        if (par0 == Block.obsidian.blockID) {
            return false;
        }
        if (par0 == Block.pistonBase.blockID || par0 == Block.pistonStickyBase.blockID) {
            if (BlockPistonBase.isExtended(par1World.getBlockMetadata(par2, par3, par4))) {
                return false;
            }
        } else {
            if (Block.blocksList[par0].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[par0].getMobilityFlag() == 2) {
                return false;
            }
            if (!par5 && Block.blocksList[par0].getMobilityFlag() == 1) {
                return false;
            }
        }
        return !(Block.blocksList[par0] instanceof BlockContainer);
    }

    private static boolean canExtend(World par0World, int par1, int par2, int par3, int par4) {
        int i = par1 + Facing.offsetsXForSide[par4];
        int j = par2 + Facing.offsetsYForSide[par4];
        int k = par3 + Facing.offsetsZForSide[par4];
        for (int l = 0; l < 13; ++l) {
            if (j <= 0 || j >= 255) {
                return false;
            }
            int i1 = par0World.getBlockId(i, j, k);
            if (i1 == 0) break;
            if (!BlockPistonBase.canPushBlock(i1, par0World, i, j, k, true)) {
                return false;
            }
            if (Block.blocksList[i1].getMobilityFlag() == 1) break;
            if (l == 12) {
                return false;
            }
            i += Facing.offsetsXForSide[par4];
            j += Facing.offsetsYForSide[par4];
            k += Facing.offsetsZForSide[par4];
        }
        return true;
    }

    private boolean tryExtend(World par1World, int par2, int par3, int par4, int par5) {
        int i = par2 + Facing.offsetsXForSide[par5];
        int j = par3 + Facing.offsetsYForSide[par5];
        int k = par4 + Facing.offsetsZForSide[par5];
        for (int l = 0; l < 13; ++l) {
            if (j <= 0 || j >= 255) {
                return false;
            }
            int j1 = par1World.getBlockId(i, j, k);
            if (j1 == 0) break;
            if (!BlockPistonBase.canPushBlock(j1, par1World, i, j, k, true)) {
                return false;
            }
            if (Block.blocksList[j1].getMobilityFlag() == 1) {
                Block.blocksList[j1].dropBlockAsItem(par1World, i, j, k, par1World.getBlockMetadata(i, j, k), 0);
                par1World.setBlockWithNotify(i, j, k, 0);
                break;
            }
            if (l == 12) {
                return false;
            }
            i += Facing.offsetsXForSide[par5];
            j += Facing.offsetsYForSide[par5];
            k += Facing.offsetsZForSide[par5];
        }
        while (i != par2 || j != par3 || k != par4) {
            int i1 = i - Facing.offsetsXForSide[par5];
            int k1 = j - Facing.offsetsYForSide[par5];
            int l1 = k - Facing.offsetsZForSide[par5];
            int i2 = par1World.getBlockId(i1, k1, l1);
            int j2 = par1World.getBlockMetadata(i1, k1, l1);
            if (i2 == this.blockID && i1 == par2 && k1 == par3 && l1 == par4) {
                par1World.setBlockAndMetadata(i, j, k, Block.pistonMoving.blockID, par5 | (this.isSticky ? 8 : 0));
                par1World.setBlockTileEntity(i, j, k, BlockPistonMoving.getTileEntity(Block.pistonExtension.blockID, par5 | (this.isSticky ? 8 : 0), par5, true, false));
            } else {
                par1World.setBlockAndMetadata(i, j, k, Block.pistonMoving.blockID, j2);
                par1World.setBlockTileEntity(i, j, k, BlockPistonMoving.getTileEntity(i2, j2, par5, true, false));
            }
            i = i1;
            j = k1;
            k = l1;
        }
        return true;
    }
}

