/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockDirectional;
import net.minecraft.src.EntityIronGolem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntitySnowman;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class BlockPumpkin
extends BlockDirectional {
    private boolean blockType;

    protected BlockPumpkin(int par1, int par2, boolean par3) {
        super(par1, Material.pumpkin);
        this.blockIndexInTexture = par2;
        this.setTickRandomly(true);
        this.blockType = par3;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par1 == 1) {
            return this.blockIndexInTexture;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture;
        }
        int i = this.blockIndexInTexture + 1 + 16;
        if (this.blockType) {
            ++i;
        }
        if (par2 == 2 && par1 == 2) {
            return i;
        }
        if (par2 == 3 && par1 == 5) {
            return i;
        }
        if (par2 == 0 && par1 == 3) {
            return i;
        }
        if (par2 == 1 && par1 == 4) {
            return i;
        }
        return this.blockIndexInTexture + 16;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 1) {
            return this.blockIndexInTexture;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture;
        }
        if (par1 == 3) {
            return this.blockIndexInTexture + 1 + 16;
        }
        return this.blockIndexInTexture + 16;
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        if (par1World.getBlockId(par2, par3 - 1, par4) == Block.blockSnow.blockID && par1World.getBlockId(par2, par3 - 2, par4) == Block.blockSnow.blockID) {
            if (!par1World.isRemote) {
                par1World.setBlock(par2, par3, par4, 0);
                par1World.setBlock(par2, par3 - 1, par4, 0);
                par1World.setBlock(par2, par3 - 2, par4, 0);
                EntitySnowman entitysnowman = new EntitySnowman(par1World);
                entitysnowman.setLocationAndAngles((double)par2 + 0.5, (double)par3 - 1.95, (double)par4 + 0.5, 0.0f, 0.0f);
                par1World.spawnEntityInWorld(entitysnowman);
                par1World.notifyBlockChange(par2, par3, par4, 0);
                par1World.notifyBlockChange(par2, par3 - 1, par4, 0);
                par1World.notifyBlockChange(par2, par3 - 2, par4, 0);
            }
            for (int i = 0; i < 120; ++i) {
                par1World.spawnParticle("snowshovel", (double)par2 + par1World.rand.nextDouble(), (double)(par3 - 2) + par1World.rand.nextDouble() * 2.5, (double)par4 + par1World.rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        } else if (par1World.getBlockId(par2, par3 - 1, par4) == Block.blockSteel.blockID && par1World.getBlockId(par2, par3 - 2, par4) == Block.blockSteel.blockID) {
            boolean flag1;
            boolean flag = par1World.getBlockId(par2 - 1, par3 - 1, par4) == Block.blockSteel.blockID && par1World.getBlockId(par2 + 1, par3 - 1, par4) == Block.blockSteel.blockID;
            boolean bl = flag1 = par1World.getBlockId(par2, par3 - 1, par4 - 1) == Block.blockSteel.blockID && par1World.getBlockId(par2, par3 - 1, par4 + 1) == Block.blockSteel.blockID;
            if (flag || flag1) {
                par1World.setBlock(par2, par3, par4, 0);
                par1World.setBlock(par2, par3 - 1, par4, 0);
                par1World.setBlock(par2, par3 - 2, par4, 0);
                if (flag) {
                    par1World.setBlock(par2 - 1, par3 - 1, par4, 0);
                    par1World.setBlock(par2 + 1, par3 - 1, par4, 0);
                } else {
                    par1World.setBlock(par2, par3 - 1, par4 - 1, 0);
                    par1World.setBlock(par2, par3 - 1, par4 + 1, 0);
                }
                EntityIronGolem entityirongolem = new EntityIronGolem(par1World);
                entityirongolem.func_48115_b(true);
                entityirongolem.setLocationAndAngles((double)par2 + 0.5, (double)par3 - 1.95, (double)par4 + 0.5, 0.0f, 0.0f);
                par1World.spawnEntityInWorld(entityirongolem);
                for (int j = 0; j < 120; ++j) {
                    par1World.spawnParticle("snowballpoof", (double)par2 + par1World.rand.nextDouble(), (double)(par3 - 2) + par1World.rand.nextDouble() * 3.9, (double)par4 + par1World.rand.nextDouble(), 0.0, 0.0, 0.0);
                }
                par1World.notifyBlockChange(par2, par3, par4, 0);
                par1World.notifyBlockChange(par2, par3 - 1, par4, 0);
                par1World.notifyBlockChange(par2, par3 - 2, par4, 0);
                if (flag) {
                    par1World.notifyBlockChange(par2 - 1, par3 - 1, par4, 0);
                    par1World.notifyBlockChange(par2 + 1, par3 - 1, par4, 0);
                } else {
                    par1World.notifyBlockChange(par2, par3 - 1, par4 - 1, 0);
                    par1World.notifyBlockChange(par2, par3 - 1, par4 + 1, 0);
                }
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockId(par2, par3, par4);
        return (i == 0 || Block.blocksList[i].blockMaterial.isGroundCover()) && par1World.isBlockNormalCube(par2, par3 - 1, par4);
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
    }
}

