/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockDirectional;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class BlockRedstoneRepeater
extends BlockDirectional {
    public static final double[] repeaterTorchOffset = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] repeaterState = new int[]{1, 2, 3, 4};
    private final boolean isRepeaterPowered;

    protected BlockRedstoneRepeater(int par1, boolean par2) {
        super(par1, 6, Material.circuits);
        this.isRepeaterPowered = par2;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (!par1World.isBlockNormalCube(par2, par3 - 1, par4)) {
            return false;
        }
        return super.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        if (!par1World.isBlockNormalCube(par2, par3 - 1, par4)) {
            return false;
        }
        return super.canBlockStay(par1World, par2, par3, par4);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        boolean flag = this.ignoreTick(par1World, par2, par3, par4, i);
        if (this.isRepeaterPowered && !flag) {
            par1World.setBlockAndMetadataWithNotify(par2, par3, par4, Block.redstoneRepeaterIdle.blockID, i);
        } else if (!this.isRepeaterPowered) {
            par1World.setBlockAndMetadataWithNotify(par2, par3, par4, Block.redstoneRepeaterActive.blockID, i);
            if (!flag) {
                int j = (i & 0xC) >> 2;
                par1World.scheduleBlockUpdate(par2, par3, par4, Block.redstoneRepeaterActive.blockID, repeaterState[j] * 2);
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par1 == 0) {
            return !this.isRepeaterPowered ? 115 : 99;
        }
        if (par1 == 1) {
            return !this.isRepeaterPowered ? 131 : 147;
        }
        return 5;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par5 != 0 && par5 != 1;
    }

    @Override
    public int getRenderType() {
        return 15;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return this.getBlockTextureFromSideAndMetadata(par1, 0);
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        return this.isPoweringTo(par1World, par2, par3, par4, par5);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int i = BlockRedstoneRepeater.getDirection(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
        if (i == 0 && par5 == 3) {
            return true;
        }
        if (i == 1 && par5 == 4) {
            return true;
        }
        if (i == 2 && par5 == 2) {
            return true;
        }
        return i == 3 && par5 == 5;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        boolean flag = this.ignoreTick(par1World, par2, par3, par4, i);
        int j = (i & 0xC) >> 2;
        if (this.isRepeaterPowered && !flag) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, repeaterState[j] * 2);
        } else if (!this.isRepeaterPowered && flag) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, repeaterState[j] * 2);
        }
    }

    private boolean ignoreTick(World par1World, int par2, int par3, int par4, int par5) {
        int i = BlockRedstoneRepeater.getDirection(par5);
        switch (i) {
            case 0: {
                return par1World.isBlockIndirectlyProvidingPowerTo(par2, par3, par4 + 1, 3) || par1World.getBlockId(par2, par3, par4 + 1) == Block.redstoneWire.blockID && par1World.getBlockMetadata(par2, par3, par4 + 1) > 0;
            }
            case 2: {
                return par1World.isBlockIndirectlyProvidingPowerTo(par2, par3, par4 - 1, 2) || par1World.getBlockId(par2, par3, par4 - 1) == Block.redstoneWire.blockID && par1World.getBlockMetadata(par2, par3, par4 - 1) > 0;
            }
            case 3: {
                return par1World.isBlockIndirectlyProvidingPowerTo(par2 + 1, par3, par4, 5) || par1World.getBlockId(par2 + 1, par3, par4) == Block.redstoneWire.blockID && par1World.getBlockMetadata(par2 + 1, par3, par4) > 0;
            }
            case 1: {
                return par1World.isBlockIndirectlyProvidingPowerTo(par2 - 1, par3, par4, 4) || par1World.getBlockId(par2 - 1, par3, par4) == Block.redstoneWire.blockID && par1World.getBlockMetadata(par2 - 1, par3, par4) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = (i & 0xC) >> 2;
        j = j + 1 << 2 & 0xC;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, j | i & 3);
        return true;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = ((MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
        boolean flag = this.ignoreTick(par1World, par2, par3, par4, i);
        if (flag) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, 1);
        }
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
    }

    @Override
    public void onBlockDestroyedByPlayer(World par1World, int par2, int par3, int par4, int par5) {
        if (this.isRepeaterPowered) {
            par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
        }
        super.onBlockDestroyedByPlayer(par1World, par2, par3, par4, par5);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.redstoneRepeater.shiftedIndex;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = BlockRedstoneRepeater.getDirection(i);
        double d = (double)((float)par2 + 0.5f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)par3 + 0.4f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)par4 + 0.5f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
        double d3 = 0.0;
        double d4 = 0.0;
        if (par5Random.nextInt(2) == 0) {
            switch (j) {
                case 0: {
                    d4 = -0.3125;
                    break;
                }
                case 2: {
                    d4 = 0.3125;
                    break;
                }
                case 3: {
                    d3 = -0.3125;
                    break;
                }
                case 1: {
                    d3 = 0.3125;
                }
            }
        } else {
            int k = (i & 0xC) >> 2;
            switch (j) {
                case 0: {
                    d4 = repeaterTorchOffset[k];
                    break;
                }
                case 2: {
                    d4 = -repeaterTorchOffset[k];
                    break;
                }
                case 3: {
                    d3 = repeaterTorchOffset[k];
                    break;
                }
                case 1: {
                    d3 = -repeaterTorchOffset[k];
                }
            }
        }
        par1World.spawnParticle("reddust", d + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
    }
}

