/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Direction;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;
    private Set blocksNeedingUpdate = new HashSet();

    public BlockRedstoneWire(int par1, int par2) {
        super(par1, par2, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        return this.blockIndexInTexture;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 5;
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return 0x800000;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return par1World.isBlockNormalCube(par2, par3 - 1, par4) || par1World.getBlockId(par2, par3 - 1, par4) == Block.glowStone.blockID;
    }

    private void updateAndPropagateCurrentStrength(World par1World, int par2, int par3, int par4) {
        this.calculateCurrentChanges(par1World, par2, par3, par4, par2, par3, par4);
        ArrayList arraylist = new ArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (int i = 0; i < arraylist.size(); ++i) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i);
            par1World.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.blockID);
        }
    }

    private void calculateCurrentChanges(World par1World, int par2, int par3, int par4, int par5, int par6, int par7) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = 0;
        this.wiresProvidePower = false;
        boolean flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4);
        this.wiresProvidePower = true;
        if (flag) {
            j = 15;
        } else {
            for (int k = 0; k < 4; ++k) {
                int i1 = par2;
                int k1 = par4;
                if (k == 0) {
                    --i1;
                }
                if (k == 1) {
                    ++i1;
                }
                if (k == 2) {
                    --k1;
                }
                if (k == 3) {
                    ++k1;
                }
                if (i1 != par5 || par3 != par6 || k1 != par7) {
                    j = this.getMaxCurrentStrength(par1World, i1, par3, k1, j);
                }
                if (par1World.isBlockNormalCube(i1, par3, k1) && !par1World.isBlockNormalCube(par2, par3 + 1, par4)) {
                    if (i1 == par5 && par3 + 1 == par6 && k1 == par7) continue;
                    j = this.getMaxCurrentStrength(par1World, i1, par3 + 1, k1, j);
                    continue;
                }
                if (par1World.isBlockNormalCube(i1, par3, k1) || i1 == par5 && par3 - 1 == par6 && k1 == par7) continue;
                j = this.getMaxCurrentStrength(par1World, i1, par3 - 1, k1, j);
            }
            j = j > 0 ? --j : 0;
        }
        if (i != j) {
            par1World.editingBlocks = true;
            par1World.setBlockMetadataWithNotify(par2, par3, par4, j);
            par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
            par1World.editingBlocks = false;
            for (int l = 0; l < 4; ++l) {
                int j1 = par2;
                int l1 = par4;
                int i2 = par3 - 1;
                if (l == 0) {
                    --j1;
                }
                if (l == 1) {
                    ++j1;
                }
                if (l == 2) {
                    --l1;
                }
                if (l == 3) {
                    ++l1;
                }
                if (par1World.isBlockNormalCube(j1, par3, l1)) {
                    i2 += 2;
                }
                int j2 = 0;
                j2 = this.getMaxCurrentStrength(par1World, j1, par3, l1, -1);
                j = par1World.getBlockMetadata(par2, par3, par4);
                if (j > 0) {
                    --j;
                }
                if (j2 >= 0 && j2 != j) {
                    this.calculateCurrentChanges(par1World, j1, par3, l1, par2, par3, par4);
                }
                j2 = this.getMaxCurrentStrength(par1World, j1, i2, l1, -1);
                j = par1World.getBlockMetadata(par2, par3, par4);
                if (j > 0) {
                    --j;
                }
                if (j2 < 0 || j2 == j) continue;
                this.calculateCurrentChanges(par1World, j1, i2, l1, par2, par3, par4);
            }
            if (i < j || j == 0) {
                this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2 - 1, par3, par4));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2 + 1, par3, par4));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3 - 1, par4));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3 + 1, par4));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4 - 1));
                this.blocksNeedingUpdate.add(new ChunkPosition(par2, par3, par4 + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockId(par2, par3, par4) != this.blockID) {
            return;
        }
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        if (par1World.isRemote) {
            return;
        }
        this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
        par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3, par4);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3, par4);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 - 1);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 + 1);
        if (par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 + 1, par4);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 - 1, par4);
        }
        if (par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 + 1, par4);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 - 1, par4);
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 - 1);
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 + 1);
        }
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        super.onBlockRemoval(par1World, par2, par3, par4);
        if (par1World.isRemote) {
            return;
        }
        par1World.notifyBlocksOfNeighborChange(par2, par3 + 1, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3, par4);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3, par4);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 - 1);
        this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3, par4 + 1);
        if (par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 + 1, par4);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 - 1, par3 - 1, par4);
        }
        if (par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 + 1, par4);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2 + 1, par3 - 1, par4);
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 - 1);
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 + 1, par4 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(par1World, par2, par3 - 1, par4 + 1);
        }
    }

    private int getMaxCurrentStrength(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.getBlockId(par2, par3, par4) != this.blockID) {
            return par5;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (i > par5) {
            return i;
        }
        return par5;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        boolean flag = this.canPlaceBlockAt(par1World, par2, par3, par4);
        if (!flag) {
            this.dropBlockAsItem(par1World, par2, par3, par4, i, 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        } else {
            this.updateAndPropagateCurrentStrength(par1World, par2, par3, par4);
        }
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.redstone.shiftedIndex;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(par1World, par2, par3, par4, par5);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (par1IBlockAccess.getBlockMetadata(par2, par3, par4) == 0) {
            return false;
        }
        if (par5 == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 - 1, par3, par4, 1) || !par1IBlockAccess.isBlockNormalCube(par2 - 1, par3, par4) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 - 1, par3 - 1, par4, -1);
        boolean flag1 = BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 + 1, par3, par4, 3) || !par1IBlockAccess.isBlockNormalCube(par2 + 1, par3, par4) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 + 1, par3 - 1, par4, -1);
        boolean flag2 = BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3, par4 - 1, 2) || !par1IBlockAccess.isBlockNormalCube(par2, par3, par4 - 1) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3 - 1, par4 - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3, par4 + 1, 0) || !par1IBlockAccess.isBlockNormalCube(par2, par3, par4 + 1) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3 - 1, par4 + 1, -1);
        if (!par1IBlockAccess.isBlockNormalCube(par2, par3 + 1, par4)) {
            if (par1IBlockAccess.isBlockNormalCube(par2 - 1, par3, par4) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 - 1, par3 + 1, par4, -1)) {
                flag = true;
            }
            if (par1IBlockAccess.isBlockNormalCube(par2 + 1, par3, par4) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2 + 1, par3 + 1, par4, -1)) {
                flag1 = true;
            }
            if (par1IBlockAccess.isBlockNormalCube(par2, par3, par4 - 1) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3 + 1, par4 - 1, -1)) {
                flag2 = true;
            }
            if (par1IBlockAccess.isBlockNormalCube(par2, par3, par4 + 1) && BlockRedstoneWire.isPoweredOrRepeater(par1IBlockAccess, par2, par3 + 1, par4 + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || par5 < 2 || par5 > 5)) {
            return true;
        }
        if (par5 == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (par5 == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (par5 == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return par5 == 5 && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (i > 0) {
            double d = (double)par2 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)par3 + 0.0625f;
            double d2 = (double)par4 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            if (i == 0) {
                f1 = 0.0f;
            }
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            par1World.spawnParticle("reddust", d, d1, d2, f1, f2, f3);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, int par4) {
        int i = par0IBlockAccess.getBlockId(par1, par2, par3);
        if (i == Block.redstoneWire.blockID) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        if (i == Block.redstoneRepeaterIdle.blockID || i == Block.redstoneRepeaterActive.blockID) {
            int j = par0IBlockAccess.getBlockMetadata(par1, par2, par3);
            return par4 == (j & 3) || par4 == Direction.footInvisibleFaceRemap[j & 3];
        }
        return Block.blocksList[i].canProvidePower() && par4 != -1;
    }

    public static boolean isPoweredOrRepeater(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, int par4) {
        if (BlockRedstoneWire.isPowerProviderOrWire(par0IBlockAccess, par1, par2, par3, par4)) {
            return true;
        }
        int i = par0IBlockAccess.getBlockId(par1, par2, par3);
        if (i == Block.redstoneRepeaterActive.blockID) {
            int j = par0IBlockAccess.getBlockMetadata(par1, par2, par3);
            return par4 == (j & 3);
        }
        return false;
    }
}

