/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenBigTree;
import net.minecraft.src.WorldGenForest;
import net.minecraft.src.WorldGenHugeTrees;
import net.minecraft.src.WorldGenTaiga2;
import net.minecraft.src.WorldGenTrees;
import net.minecraft.src.WorldGenerator;

public class BlockSapling
extends BlockFlower {
    protected BlockSapling(int par1, int par2) {
        super(par1, par2);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isRemote) {
            return;
        }
        super.updateTick(par1World, par2, par3, par4, par5Random);
        if (par1World.getBlockLightValue(par2, par3 + 1, par4) >= 9 && par5Random.nextInt(7) == 0) {
            int i = par1World.getBlockMetadata(par2, par3, par4);
            if ((i & 8) == 0) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 8);
            } else {
                this.growTree(par1World, par2, par3, par4, par5Random);
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if ((par2 &= 3) == 1) {
            return 63;
        }
        if (par2 == 2) {
            return 79;
        }
        if (par2 == 3) {
            return 30;
        }
        return super.getBlockTextureFromSideAndMetadata(par1, par2);
    }

    public void growTree(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4) & 3;
        WorldGenerator obj = null;
        int j = 0;
        int k = 0;
        boolean flag = false;
        if (i == 1) {
            obj = new WorldGenTaiga2(true);
        } else if (i == 2) {
            obj = new WorldGenForest(true);
        } else if (i == 3) {
            for (j = 0; j >= -1; --j) {
                for (k = 0; k >= -1; --k) {
                    if (!this.func_50076_f(par1World, par2 + j, par3, par4 + k, 3) || !this.func_50076_f(par1World, par2 + j + 1, par3, par4 + k, 3) || !this.func_50076_f(par1World, par2 + j, par3, par4 + k + 1, 3) || !this.func_50076_f(par1World, par2 + j + 1, par3, par4 + k + 1, 3)) continue;
                    obj = new WorldGenHugeTrees(true, 10 + par5Random.nextInt(20), 3, 3);
                    flag = true;
                    break;
                }
                if (obj != null) break;
            }
            if (obj == null) {
                k = 0;
                j = 0;
                obj = new WorldGenTrees(true, 4 + par5Random.nextInt(7), 3, 3, false);
            }
        } else {
            obj = new WorldGenTrees(true);
            if (par5Random.nextInt(10) == 0) {
                obj = new WorldGenBigTree(true);
            }
        }
        if (flag) {
            par1World.setBlock(par2 + j, par3, par4 + k, 0);
            par1World.setBlock(par2 + j + 1, par3, par4 + k, 0);
            par1World.setBlock(par2 + j, par3, par4 + k + 1, 0);
            par1World.setBlock(par2 + j + 1, par3, par4 + k + 1, 0);
        } else {
            par1World.setBlock(par2, par3, par4, 0);
        }
        if (!((WorldGenerator)obj).generate(par1World, par5Random, par2 + j, par3, par4 + k)) {
            if (flag) {
                par1World.setBlockAndMetadata(par2 + j, par3, par4 + k, this.blockID, i);
                par1World.setBlockAndMetadata(par2 + j + 1, par3, par4 + k, this.blockID, i);
                par1World.setBlockAndMetadata(par2 + j, par3, par4 + k + 1, this.blockID, i);
                par1World.setBlockAndMetadata(par2 + j + 1, par3, par4 + k + 1, this.blockID, i);
            } else {
                par1World.setBlockAndMetadata(par2, par3, par4, this.blockID, i);
            }
        }
    }

    public boolean func_50076_f(World par1World, int par2, int par3, int par4, int par5) {
        return par1World.getBlockId(par2, par3, par4) == this.blockID && (par1World.getBlockMetadata(par2, par3, par4) & 3) == par5;
    }

    @Override
    protected int damageDropped(int par1) {
        return par1 & 3;
    }
}

