/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockSnow
extends Block {
    protected BlockSnow(int par1, int par2) {
        super(par1, par2, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4) & 7;
        if (i >= 3) {
            return AxisAlignedBB.getBoundingBoxFromPool((double)par2 + this.minX, (double)par3 + this.minY, (double)par4 + this.minZ, (double)par2 + this.maxX, (float)par3 + 0.5f, (double)par4 + this.maxZ);
        }
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 7;
        float f = (float)(2 * (1 + i)) / 16.0f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockId(par2, par3 - 1, par4);
        if (i == 0 || i != Block.leaves.blockID && !Block.blocksList[i].isOpaqueCube()) {
            return false;
        }
        return par1World.getBlockMaterial(par2, par3 - 1, par4).blocksMovement();
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        this.canSnowStay(par1World, par2, par3, par4);
    }

    private boolean canSnowStay(World par1World, int par2, int par3, int par4) {
        if (!this.canPlaceBlockAt(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        int i = Item.snowball.shiftedIndex;
        float f = 0.7f;
        double d = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(par1World, (double)par3 + d, (double)par4 + d1, (double)par5 + d2, new ItemStack(i, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        par1World.spawnEntityInWorld(entityitem);
        par1World.setBlockWithNotify(par3, par4, par5, 0);
        par2EntityPlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.snowball.shiftedIndex;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.getSavedLightValue(EnumSkyBlock.Block, par2, par3, par4) > 11) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 == 1) {
            return true;
        }
        return super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5);
    }
}

