/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockStationary
extends BlockFluid {
    protected BlockStationary(int par1, Material par2Material) {
        super(par1, par2Material);
        this.setTickRandomly(false);
        if (par2Material == Material.lava) {
            this.setTickRandomly(true);
        }
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.blockMaterial != Material.lava;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
        if (par1World.getBlockId(par2, par3, par4) == this.blockID) {
            this.setNotStationary(par1World, par2, par3, par4);
        }
    }

    private void setNotStationary(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        par1World.editingBlocks = true;
        par1World.setBlockAndMetadata(par2, par3, par4, this.blockID - 1, i);
        par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID - 1, this.tickRate());
        par1World.editingBlocks = false;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.blockMaterial == Material.lava) {
            int i = par5Random.nextInt(3);
            for (int j = 0; j < i; ++j) {
                int l = par1World.getBlockId(par2 += par5Random.nextInt(3) - 1, ++par3, par4 += par5Random.nextInt(3) - 1);
                if (l == 0) {
                    if (!this.isFlammable(par1World, par2 - 1, par3, par4) && !this.isFlammable(par1World, par2 + 1, par3, par4) && !this.isFlammable(par1World, par2, par3, par4 - 1) && !this.isFlammable(par1World, par2, par3, par4 + 1) && !this.isFlammable(par1World, par2, par3 - 1, par4) && !this.isFlammable(par1World, par2, par3 + 1, par4)) continue;
                    par1World.setBlockWithNotify(par2, par3, par4, Block.fire.blockID);
                    return;
                }
                if (!Block.blocksList[l].blockMaterial.blocksMovement()) continue;
                return;
            }
            if (i == 0) {
                int k = par2;
                int i1 = par4;
                for (int j1 = 0; j1 < 3; ++j1) {
                    par2 = k + par5Random.nextInt(3) - 1;
                    if (!par1World.isAirBlock(par2, par3 + 1, par4 = i1 + par5Random.nextInt(3) - 1) || !this.isFlammable(par1World, par2, par3, par4)) continue;
                    par1World.setBlockWithNotify(par2, par3 + 1, par4, Block.fire.blockID);
                }
            }
        }
    }

    private boolean isFlammable(World par1World, int par2, int par3, int par4) {
        return par1World.getBlockMaterial(par2, par3, par4).getCanBurn();
    }
}

