/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockStairs;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockTorch
extends Block {
    protected BlockTorch(int par1, int par2) {
        super(par1, par2, Material.circuits);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 2;
    }

    private boolean canPlaceTorchOn(World par1World, int par2, int par3, int par4) {
        int j;
        if (par1World.isBlockNormalCubeDefault(par2, par3, par4, true)) {
            return true;
        }
        int i = par1World.getBlockId(par2, par3, par4);
        if (i == Block.fence.blockID || i == Block.netherFence.blockID || i == Block.glass.blockID) {
            return true;
        }
        return Block.blocksList[i] != null && Block.blocksList[i] instanceof BlockStairs && (4 & (j = par1World.getBlockMetadata(par2, par3, par4))) != 0;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (par1World.isBlockNormalCubeDefault(par2 - 1, par3, par4, true)) {
            return true;
        }
        if (par1World.isBlockNormalCubeDefault(par2 + 1, par3, par4, true)) {
            return true;
        }
        if (par1World.isBlockNormalCubeDefault(par2, par3, par4 - 1, true)) {
            return true;
        }
        if (par1World.isBlockNormalCubeDefault(par2, par3, par4 + 1, true)) {
            return true;
        }
        return this.canPlaceTorchOn(par1World, par2, par3 - 1, par4);
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (par5 == 1 && this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
            i = 5;
        }
        if (par5 == 2 && par1World.isBlockNormalCubeDefault(par2, par3, par4 + 1, true)) {
            i = 4;
        }
        if (par5 == 3 && par1World.isBlockNormalCubeDefault(par2, par3, par4 - 1, true)) {
            i = 3;
        }
        if (par5 == 4 && par1World.isBlockNormalCubeDefault(par2 + 1, par3, par4, true)) {
            i = 2;
        }
        if (par5 == 5 && par1World.isBlockNormalCubeDefault(par2 - 1, par3, par4, true)) {
            i = 1;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.updateTick(par1World, par2, par3, par4, par5Random);
        if (par1World.getBlockMetadata(par2, par3, par4) == 0) {
            this.onBlockAdded(par1World, par2, par3, par4);
        }
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        if (par1World.isBlockNormalCubeDefault(par2 - 1, par3, par4, true)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 1);
        } else if (par1World.isBlockNormalCubeDefault(par2 + 1, par3, par4, true)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2);
        } else if (par1World.isBlockNormalCubeDefault(par2, par3, par4 - 1, true)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3);
        } else if (par1World.isBlockNormalCubeDefault(par2, par3, par4 + 1, true)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4);
        } else if (this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5);
        }
        this.dropTorchIfCantStay(par1World, par2, par3, par4);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (this.dropTorchIfCantStay(par1World, par2, par3, par4)) {
            int i = par1World.getBlockMetadata(par2, par3, par4);
            boolean flag = false;
            if (!par1World.isBlockNormalCubeDefault(par2 - 1, par3, par4, true) && i == 1) {
                flag = true;
            }
            if (!par1World.isBlockNormalCubeDefault(par2 + 1, par3, par4, true) && i == 2) {
                flag = true;
            }
            if (!par1World.isBlockNormalCubeDefault(par2, par3, par4 - 1, true) && i == 3) {
                flag = true;
            }
            if (!par1World.isBlockNormalCubeDefault(par2, par3, par4 + 1, true) && i == 4) {
                flag = true;
            }
            if (!this.canPlaceTorchOn(par1World, par2, par3 - 1, par4) && i == 5) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            }
        }
    }

    private boolean dropTorchIfCantStay(World par1World, int par2, int par3, int par4) {
        if (!this.canPlaceBlockAt(par1World, par2, par3, par4)) {
            if (par1World.getBlockId(par2, par3, par4) == this.blockID) {
                this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            }
            return false;
        }
        return true;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World par1World, int par2, int par3, int par4, Vec3D par5Vec3D, Vec3D par6Vec3D) {
        int i = par1World.getBlockMetadata(par2, par3, par4) & 7;
        float f = 0.15f;
        if (i == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (i == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (i == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (i == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.1f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
        return super.collisionRayTrace(par1World, par2, par3, par4, par5Vec3D, par6Vec3D);
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        double d = (float)par2 + 0.5f;
        double d1 = (float)par3 + 0.7f;
        double d2 = (float)par4 + 0.5f;
        double d3 = 0.22f;
        double d4 = 0.27f;
        if (i == 1) {
            par1World.spawnParticle("smoke", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (i == 2) {
            par1World.spawnParticle("smoke", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (i == 3) {
            par1World.spawnParticle("smoke", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (i == 4) {
            par1World.spawnParticle("smoke", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            par1World.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

