/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EnumOS1;
import net.minecraft.src.IsoImageBuffer;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.TerrainTextureManager;
import net.minecraft.src.ThreadRunIsoClient;
import net.minecraft.src.World;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;

public class CanvasIsomPreview
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    private int currentRender = 0;
    private int zoom = 2;
    private boolean showHelp = true;
    private World level;
    private File workDir;
    private boolean running = true;
    private List zonesToRender = Collections.synchronizedList(new LinkedList());
    private IsoImageBuffer[][] zoneMap = new IsoImageBuffer[64][64];
    private int field_1785_i;
    private int field_1784_j;
    private int field_1783_k;
    private int field_1782_l;

    public File getWorkingDirectory() {
        if (this.workDir == null) {
            this.workDir = this.getWorkingDirectory("minecraft");
        }
        return this.workDir;
    }

    public File getWorkingDirectory(String par1Str) {
        File file;
        String s = System.getProperty("user.home", ".");
        switch (CanvasIsomPreview.getPlatform()) {
            case linux: 
            case solaris: {
                file = new File(s, '.' + par1Str + '/');
                break;
            }
            case windows: {
                String s1 = System.getenv("APPDATA");
                if (s1 != null) {
                    file = new File(s1, "." + par1Str + '/');
                    break;
                }
                file = new File(s, '.' + par1Str + '/');
                break;
            }
            case macos: {
                file = new File(s, "Library/Application Support/" + par1Str);
                break;
            }
            default: {
                file = new File(s, par1Str + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS1 getPlatform() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS1.windows;
        }
        if (s.contains("mac")) {
            return EnumOS1.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS1.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS1.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS1.linux;
        }
        if (s.contains("unix")) {
            return EnumOS1.linux;
        }
        return EnumOS1.unknown;
    }

    public CanvasIsomPreview() {
        this.workDir = this.getWorkingDirectory();
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.zoneMap[i][j] = new IsoImageBuffer(null, i, j);
            }
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.setBackground(Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevel(String par1Str) {
        this.field_1784_j = 0;
        this.field_1785_i = 0;
        this.level = new World(new SaveHandler(new File(this.workDir, "saves"), par1Str, false), par1Str, new WorldSettings(new Random().nextLong(), 0, true, false, WorldType.DEFAULT));
        this.level.skylightSubtracted = 0;
        List list = this.zonesToRender;
        synchronized (list) {
            this.zonesToRender.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.zoneMap[i][j].init(this.level, i, j);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBrightness(int par1) {
        List list = this.zonesToRender;
        synchronized (list) {
            this.level.skylightSubtracted = par1;
            this.zonesToRender.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.zoneMap[i][j].init(this.level, i, j);
                }
            }
        }
    }

    public void start() {
        new ThreadRunIsoClient(this).start();
        for (int i = 0; i < 8; ++i) {
            new Thread(this).start();
        }
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsoImageBuffer getZone(int par1, int par2) {
        int i = par1 & 0x3F;
        int j = par2 & 0x3F;
        IsoImageBuffer isoimagebuffer = this.zoneMap[i][j];
        if (isoimagebuffer.x == par1 && isoimagebuffer.y == par2) {
            return isoimagebuffer;
        }
        List list = this.zonesToRender;
        synchronized (list) {
            this.zonesToRender.remove(isoimagebuffer);
        }
        isoimagebuffer.init(par1, par2);
        return isoimagebuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TerrainTextureManager terraintexturemanager = new TerrainTextureManager();
        while (this.running) {
            IsoImageBuffer isoimagebuffer = null;
            List list = this.zonesToRender;
            synchronized (list) {
                if (this.zonesToRender.size() > 0) {
                    isoimagebuffer = (IsoImageBuffer)this.zonesToRender.remove(0);
                }
            }
            if (isoimagebuffer != null) {
                if (this.currentRender - isoimagebuffer.lastVisible < 2) {
                    terraintexturemanager.render(isoimagebuffer);
                    this.repaint();
                } else {
                    isoimagebuffer.addedToRenderQueue = false;
                }
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedexception) {
                interruptedexception.printStackTrace();
            }
        }
    }

    @Override
    public void update(Graphics g) {
    }

    @Override
    public void paint(Graphics g) {
    }

    public void render() {
        BufferStrategy bufferstrategy = this.getBufferStrategy();
        if (bufferstrategy == null) {
            this.createBufferStrategy(2);
            return;
        }
        this.render((Graphics2D)bufferstrategy.getDrawGraphics());
        bufferstrategy.show();
    }

    public void render(Graphics2D par1Graphics2D) {
        ++this.currentRender;
        AffineTransform affinetransform = par1Graphics2D.getTransform();
        par1Graphics2D.setClip(0, 0, this.getWidth(), this.getHeight());
        par1Graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        par1Graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
        par1Graphics2D.scale(this.zoom, this.zoom);
        par1Graphics2D.translate(this.field_1785_i, this.field_1784_j);
        if (this.level != null) {
            ChunkCoordinates chunkcoordinates = this.level.getSpawnPoint();
            par1Graphics2D.translate(-(chunkcoordinates.posX + chunkcoordinates.posZ), -(-chunkcoordinates.posX + chunkcoordinates.posZ) + 64);
        }
        Rectangle rectangle = par1Graphics2D.getClipBounds();
        par1Graphics2D.setColor(new Color(-15724512));
        par1Graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int byte0 = 16;
        int byte1 = 3;
        int i = rectangle.x / byte0 / 2 - 2 - byte1;
        int j = (rectangle.x + rectangle.width) / byte0 / 2 + 1 + byte1;
        int k = rectangle.y / byte0 - 1 - byte1 * 2;
        int l = (rectangle.y + rectangle.height + 16 + 128) / byte0 + 1 + byte1 * 2;
        for (int i1 = k; i1 <= l; ++i1) {
            for (int k1 = i; k1 <= j; ++k1) {
                int l1 = k1 - (i1 >> 1);
                int i2 = k1 + (i1 + 1 >> 1);
                IsoImageBuffer isoimagebuffer = this.getZone(l1, i2);
                isoimagebuffer.lastVisible = this.currentRender;
                if (!isoimagebuffer.rendered) {
                    if (isoimagebuffer.addedToRenderQueue) continue;
                    isoimagebuffer.addedToRenderQueue = true;
                    this.zonesToRender.add(isoimagebuffer);
                    continue;
                }
                isoimagebuffer.addedToRenderQueue = false;
                if (isoimagebuffer.noContent) continue;
                int j2 = k1 * byte0 * 2 + (i1 & 1) * byte0;
                int k2 = i1 * byte0 - 128 - 16;
                par1Graphics2D.drawImage((Image)isoimagebuffer.image, j2, k2, null);
            }
        }
        if (this.showHelp) {
            par1Graphics2D.setTransform(affinetransform);
            int j1 = this.getHeight() - 32 - 4;
            par1Graphics2D.setColor(new Color(Integer.MIN_VALUE, true));
            par1Graphics2D.fillRect(4, this.getHeight() - 32 - 4, this.getWidth() - 8, 32);
            par1Graphics2D.setColor(Color.WHITE);
            String s = "F1 - F5: load levels   |   0-9: Set time of day   |   Space: return to spawn   |   Double click: zoom   |   Escape: hide this text";
            par1Graphics2D.drawString(s, this.getWidth() / 2 - par1Graphics2D.getFontMetrics().stringWidth(s) / 2, j1 + 20);
        }
        par1Graphics2D.dispose();
    }

    @Override
    public void mouseDragged(MouseEvent par1MouseEvent) {
        int i = par1MouseEvent.getX() / this.zoom;
        int j = par1MouseEvent.getY() / this.zoom;
        this.field_1785_i += i - this.field_1783_k;
        this.field_1784_j += j - this.field_1782_l;
        this.field_1783_k = i;
        this.field_1782_l = j;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseevent) {
    }

    @Override
    public void mouseClicked(MouseEvent par1MouseEvent) {
        if (par1MouseEvent.getClickCount() == 2) {
            this.zoom = 3 - this.zoom;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent par1MouseEvent) {
        int i = par1MouseEvent.getX() / this.zoom;
        int j = par1MouseEvent.getY() / this.zoom;
        this.field_1783_k = i;
        this.field_1782_l = j;
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    public void keyPressed(KeyEvent par1KeyEvent) {
        if (par1KeyEvent.getKeyCode() == 48) {
            this.setBrightness(11);
        }
        if (par1KeyEvent.getKeyCode() == 49) {
            this.setBrightness(10);
        }
        if (par1KeyEvent.getKeyCode() == 50) {
            this.setBrightness(9);
        }
        if (par1KeyEvent.getKeyCode() == 51) {
            this.setBrightness(7);
        }
        if (par1KeyEvent.getKeyCode() == 52) {
            this.setBrightness(6);
        }
        if (par1KeyEvent.getKeyCode() == 53) {
            this.setBrightness(5);
        }
        if (par1KeyEvent.getKeyCode() == 54) {
            this.setBrightness(3);
        }
        if (par1KeyEvent.getKeyCode() == 55) {
            this.setBrightness(2);
        }
        if (par1KeyEvent.getKeyCode() == 56) {
            this.setBrightness(1);
        }
        if (par1KeyEvent.getKeyCode() == 57) {
            this.setBrightness(0);
        }
        if (par1KeyEvent.getKeyCode() == 112) {
            this.loadLevel("World1");
        }
        if (par1KeyEvent.getKeyCode() == 113) {
            this.loadLevel("World2");
        }
        if (par1KeyEvent.getKeyCode() == 114) {
            this.loadLevel("World3");
        }
        if (par1KeyEvent.getKeyCode() == 115) {
            this.loadLevel("World4");
        }
        if (par1KeyEvent.getKeyCode() == 116) {
            this.loadLevel("World5");
        }
        if (par1KeyEvent.getKeyCode() == 32) {
            this.field_1784_j = 0;
            this.field_1785_i = 0;
        }
        if (par1KeyEvent.getKeyCode() == 27) {
            this.showHelp = !this.showHelp;
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
    }

    static boolean isRunning(CanvasIsomPreview par0CanvasIsomPreview) {
        return par0CanvasIsomPreview.running;
    }
}

