/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Entity;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.ExtendedBlockStorage;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NibbleArray;
import net.minecraft.src.Profiler;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public class Chunk {
    public static boolean isLit;
    private ExtendedBlockStorage[] storageArrays = new ExtendedBlockStorage[16];
    private byte[] blockBiomeArray = new byte[256];
    public int[] precipitationHeightMap = new int[256];
    public boolean[] updateSkylightColumns = new boolean[256];
    public boolean isChunkLoaded;
    public World worldObj;
    public int[] heightMap;
    public final int xPosition;
    public final int zPosition;
    private boolean isGapLightingUpdated = false;
    public Map chunkTileEntityMap = new HashMap();
    public List[] entityLists = new List[16];
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean hasEntities = false;
    public long lastSaveTime = 0L;
    public boolean field_50120_o = false;
    private int queuedLightChecks = 4096;
    boolean field_35846_u = false;

    public Chunk(World par1World, int par2, int par3) {
        this.worldObj = par1World;
        this.xPosition = par2;
        this.zPosition = par3;
        this.heightMap = new int[256];
        for (int i = 0; i < this.entityLists.length; ++i) {
            this.entityLists[i] = new ArrayList();
        }
        Arrays.fill(this.precipitationHeightMap, -999);
        Arrays.fill(this.blockBiomeArray, (byte)-1);
    }

    public Chunk(World par1World, byte[] par2ArrayOfByte, int par3, int par4) {
        this(par1World, par3, par4);
        int i = par2ArrayOfByte.length / 256;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < i; ++l) {
                    byte byte0 = par2ArrayOfByte[j << 11 | k << 7 | l];
                    if (byte0 == 0) continue;
                    int i1 = l >> 4;
                    if (this.storageArrays[i1] == null) {
                        this.storageArrays[i1] = new ExtendedBlockStorage(i1 << 4);
                    }
                    this.storageArrays[i1].setExtBlockID(j, l & 0xF, k, byte0);
                }
            }
        }
    }

    public boolean isAtLocation(int par1, int par2) {
        return par1 == this.xPosition && par2 == this.zPosition;
    }

    public int getHeightValue(int par1, int par2) {
        return this.heightMap[par2 << 4 | par1];
    }

    public int getTopFilledSegment() {
        for (int i = this.storageArrays.length - 1; i >= 0; --i) {
            if (this.storageArrays[i] == null) continue;
            return this.storageArrays[i].getYLocation();
        }
        return 0;
    }

    public ExtendedBlockStorage[] getBlockStorageArray() {
        return this.storageArrays;
    }

    public void generateHeightMap() {
        int i = this.getTopFilledSegment();
        for (int j = 0; j < 16; ++j) {
            block1: for (int k = 0; k < 16; ++k) {
                this.precipitationHeightMap[j + (k << 4)] = -999;
                for (int l = i + 16 - 1; l > 0; --l) {
                    int i1 = this.getBlockID(j, l - 1, k);
                    if (Block.lightOpacity[i1] == 0) continue;
                    this.heightMap[k << 4 | j] = l;
                    continue block1;
                }
            }
        }
        this.isModified = true;
    }

    public void generateSkylightMap() {
        int i = this.getTopFilledSegment();
        for (int j = 0; j < 16; ++j) {
            for (int l = 0; l < 16; ++l) {
                int j1;
                this.precipitationHeightMap[j + (l << 4)] = -999;
                for (j1 = i + 16 - 1; j1 > 0; --j1) {
                    if (this.getBlockLightOpacity(j, j1 - 1, l) == 0) continue;
                    this.heightMap[l << 4 | j] = j1;
                    break;
                }
                if (this.worldObj.worldProvider.hasNoSky) continue;
                j1 = 15;
                int k1 = i + 16 - 1;
                do {
                    ExtendedBlockStorage extendedblockstorage;
                    if ((j1 -= this.getBlockLightOpacity(j, k1, l)) <= 0 || (extendedblockstorage = this.storageArrays[k1 >> 4]) == null) continue;
                    extendedblockstorage.setExtSkylightValue(j, k1 & 0xF, l, j1);
                    this.worldObj.func_48464_p((this.xPosition << 4) + j, k1, (this.zPosition << 4) + l);
                } while (--k1 > 0 && j1 > 0);
            }
        }
        this.isModified = true;
        for (int k = 0; k < 16; ++k) {
            for (int i1 = 0; i1 < 16; ++i1) {
                this.propagateSkylightOcclusion(k, i1);
            }
        }
    }

    public void func_4143_d() {
    }

    private void propagateSkylightOcclusion(int par1, int par2) {
        this.updateSkylightColumns[par1 + par2 * 16] = true;
        this.isGapLightingUpdated = true;
    }

    private void updateSkylight_do() {
        Profiler.startSection("recheckGaps");
        if (this.worldObj.doChunksNearChunkExist(this.xPosition * 16 + 8, 0, this.zPosition * 16 + 8, 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.updateSkylightColumns[i + j * 16]) continue;
                    this.updateSkylightColumns[i + j * 16] = false;
                    int k = this.getHeightValue(i, j);
                    int l = this.xPosition * 16 + i;
                    int i1 = this.zPosition * 16 + j;
                    int j1 = this.worldObj.getHeightValue(l - 1, i1);
                    int k1 = this.worldObj.getHeightValue(l + 1, i1);
                    int l1 = this.worldObj.getHeightValue(l, i1 - 1);
                    int i2 = this.worldObj.getHeightValue(l, i1 + 1);
                    if (k1 < j1) {
                        j1 = k1;
                    }
                    if (l1 < j1) {
                        j1 = l1;
                    }
                    if (i2 < j1) {
                        j1 = i2;
                    }
                    this.checkSkylightNeighborHeight(l, i1, j1);
                    this.checkSkylightNeighborHeight(l - 1, i1, k);
                    this.checkSkylightNeighborHeight(l + 1, i1, k);
                    this.checkSkylightNeighborHeight(l, i1 - 1, k);
                    this.checkSkylightNeighborHeight(l, i1 + 1, k);
                }
            }
            this.isGapLightingUpdated = false;
        }
        Profiler.endSection();
    }

    private void checkSkylightNeighborHeight(int par1, int par2, int par3) {
        int i = this.worldObj.getHeightValue(par1, par2);
        if (i > par3) {
            this.updateSkylightNeighborHeight(par1, par2, par3, i + 1);
        } else if (i < par3) {
            this.updateSkylightNeighborHeight(par1, par2, i, par3 + 1);
        }
    }

    private void updateSkylightNeighborHeight(int par1, int par2, int par3, int par4) {
        if (par4 > par3 && this.worldObj.doChunksNearChunkExist(par1, 0, par2, 16)) {
            for (int i = par3; i < par4; ++i) {
                this.worldObj.updateLightByType(EnumSkyBlock.Sky, par1, i, par2);
            }
            this.isModified = true;
        }
    }

    private void relightBlock(int par1, int par2, int par3) {
        int j2;
        int l1;
        int k2;
        int i;
        int j = i = this.heightMap[par3 << 4 | par1] & 0xFF;
        if (par2 > i) {
            j = par2;
        }
        while (j > 0 && this.getBlockLightOpacity(par1, j - 1, par3) == 0) {
            --j;
        }
        if (j == i) {
            return;
        }
        this.worldObj.markBlocksDirtyVertical(par1, par3, j, i);
        this.heightMap[par3 << 4 | par1] = j;
        int k = this.xPosition * 16 + par1;
        int l = this.zPosition * 16 + par3;
        if (!this.worldObj.worldProvider.hasNoSky) {
            if (j < i) {
                for (int i1 = j; i1 < i; ++i1) {
                    ExtendedBlockStorage extendedblockstorage = this.storageArrays[i1 >> 4];
                    if (extendedblockstorage == null) continue;
                    extendedblockstorage.setExtSkylightValue(par1, i1 & 0xF, par3, 15);
                    this.worldObj.func_48464_p((this.xPosition << 4) + par1, i1, (this.zPosition << 4) + par3);
                }
            } else {
                for (int j1 = i; j1 < j; ++j1) {
                    ExtendedBlockStorage extendedblockstorage1 = this.storageArrays[j1 >> 4];
                    if (extendedblockstorage1 == null) continue;
                    extendedblockstorage1.setExtSkylightValue(par1, j1 & 0xF, par3, 0);
                    this.worldObj.func_48464_p((this.xPosition << 4) + par1, j1, (this.zPosition << 4) + par3);
                }
            }
            int k1 = 15;
            while (j > 0 && k1 > 0) {
                ExtendedBlockStorage extendedblockstorage2;
                int i2;
                if ((i2 = this.getBlockLightOpacity(par1, --j, par3)) == 0) {
                    i2 = 1;
                }
                if ((k1 -= i2) < 0) {
                    k1 = 0;
                }
                if ((extendedblockstorage2 = this.storageArrays[j >> 4]) == null) continue;
                extendedblockstorage2.setExtSkylightValue(par1, j & 0xF, par3, k1);
            }
        }
        if ((k2 = (l1 = this.heightMap[par3 << 4 | par1])) < (j2 = i)) {
            int l2 = j2;
            j2 = k2;
            k2 = l2;
        }
        if (!this.worldObj.worldProvider.hasNoSky) {
            this.updateSkylightNeighborHeight(k - 1, l, j2, k2);
            this.updateSkylightNeighborHeight(k + 1, l, j2, k2);
            this.updateSkylightNeighborHeight(k, l - 1, j2, k2);
            this.updateSkylightNeighborHeight(k, l + 1, j2, k2);
            this.updateSkylightNeighborHeight(k, l, j2, k2);
        }
        this.isModified = true;
    }

    public int getBlockLightOpacity(int par1, int par2, int par3) {
        return Block.lightOpacity[this.getBlockID(par1, par2, par3)];
    }

    public int getBlockID(int par1, int par2, int par3) {
        if (par2 >> 4 >= this.storageArrays.length) {
            return 0;
        }
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par2 >> 4];
        if (extendedblockstorage != null) {
            return extendedblockstorage.getExtBlockID(par1, par2 & 0xF, par3);
        }
        return 0;
    }

    public int getBlockMetadata(int par1, int par2, int par3) {
        if (par2 >> 4 >= this.storageArrays.length) {
            return 0;
        }
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par2 >> 4];
        if (extendedblockstorage != null) {
            return extendedblockstorage.getExtBlockMetadata(par1, par2 & 0xF, par3);
        }
        return 0;
    }

    public boolean setBlockID(int par1, int par2, int par3, int par4) {
        return this.setBlockIDWithMetadata(par1, par2, par3, par4, 0);
    }

    public boolean setBlockIDWithMetadata(int par1, int par2, int par3, int par4, int par5) {
        TileEntity tileentity1;
        int i = par3 << 4 | par1;
        if (par2 >= this.precipitationHeightMap[i] - 1) {
            this.precipitationHeightMap[i] = -999;
        }
        int j = this.heightMap[i];
        int k = this.getBlockID(par1, par2, par3);
        if (k == par4 && this.getBlockMetadata(par1, par2, par3) == par5) {
            return false;
        }
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par2 >> 4];
        boolean flag = false;
        if (extendedblockstorage == null) {
            if (par4 == 0) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(par2 >> 4 << 4);
            this.storageArrays[par2 >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = par2 >= j;
        }
        extendedblockstorage.setExtBlockID(par1, par2 & 0xF, par3, par4);
        int l = this.xPosition * 16 + par1;
        int i1 = this.zPosition * 16 + par3;
        if (k != 0) {
            if (!this.worldObj.isRemote) {
                Block.blocksList[k].onBlockRemoval(this.worldObj, l, par2, i1);
            } else if (Block.blocksList[k] instanceof BlockContainer && k != par4) {
                this.worldObj.removeBlockTileEntity(l, par2, i1);
            }
        }
        if (extendedblockstorage.getExtBlockID(par1, par2 & 0xF, par3) != par4) {
            return false;
        }
        extendedblockstorage.setExtBlockMetadata(par1, par2 & 0xF, par3, par5);
        if (flag) {
            this.generateSkylightMap();
        } else {
            if (Block.lightOpacity[par4 & 0xFFF] > 0) {
                if (par2 >= j) {
                    this.relightBlock(par1, par2 + 1, par3);
                }
            } else if (par2 == j - 1) {
                this.relightBlock(par1, par2, par3);
            }
            this.propagateSkylightOcclusion(par1, par3);
        }
        if (par4 != 0) {
            if (!this.worldObj.isRemote) {
                Block.blocksList[par4].onBlockAdded(this.worldObj, l, par2, i1);
            }
            if (Block.blocksList[par4] instanceof BlockContainer) {
                TileEntity tileentity = this.getChunkBlockTileEntity(par1, par2, par3);
                if (tileentity == null) {
                    tileentity = ((BlockContainer)Block.blocksList[par4]).getBlockEntity();
                    this.worldObj.setBlockTileEntity(l, par2, i1, tileentity);
                }
                if (tileentity != null) {
                    tileentity.updateContainingBlockInfo();
                }
            }
        } else if (k > 0 && Block.blocksList[k] instanceof BlockContainer && (tileentity1 = this.getChunkBlockTileEntity(par1, par2, par3)) != null) {
            tileentity1.updateContainingBlockInfo();
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockMetadata(int par1, int par2, int par3, int par4) {
        TileEntity tileentity;
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par2 >> 4];
        if (extendedblockstorage == null) {
            return false;
        }
        int i = extendedblockstorage.getExtBlockMetadata(par1, par2 & 0xF, par3);
        if (i == par4) {
            return false;
        }
        this.isModified = true;
        extendedblockstorage.setExtBlockMetadata(par1, par2 & 0xF, par3, par4);
        int j = extendedblockstorage.getExtBlockID(par1, par2 & 0xF, par3);
        if (j > 0 && Block.blocksList[j] instanceof BlockContainer && (tileentity = this.getChunkBlockTileEntity(par1, par2, par3)) != null) {
            tileentity.updateContainingBlockInfo();
            tileentity.blockMetadata = par4;
        }
        return true;
    }

    public int getSavedLightValue(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par3 >> 4];
        if (extendedblockstorage == null) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        if (par1EnumSkyBlock == EnumSkyBlock.Sky) {
            return extendedblockstorage.getExtSkylightValue(par2, par3 & 0xF, par4);
        }
        if (par1EnumSkyBlock == EnumSkyBlock.Block) {
            return extendedblockstorage.getExtBlocklightValue(par2, par3 & 0xF, par4);
        }
        return par1EnumSkyBlock.defaultLightValue;
    }

    public void setLightValue(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4, int par5) {
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par3 >> 4];
        if (extendedblockstorage == null) {
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(par3 >> 4 << 4);
            this.storageArrays[par3 >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            this.generateSkylightMap();
        }
        this.isModified = true;
        if (par1EnumSkyBlock == EnumSkyBlock.Sky) {
            if (!this.worldObj.worldProvider.hasNoSky) {
                extendedblockstorage.setExtSkylightValue(par2, par3 & 0xF, par4, par5);
            }
        } else if (par1EnumSkyBlock == EnumSkyBlock.Block) {
            extendedblockstorage.setExtBlocklightValue(par2, par3 & 0xF, par4, par5);
        } else {
            return;
        }
    }

    public int getBlockLightValue(int par1, int par2, int par3, int par4) {
        int j;
        int i;
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[par2 >> 4];
        if (extendedblockstorage == null) {
            if (!this.worldObj.worldProvider.hasNoSky && par4 < EnumSkyBlock.Sky.defaultLightValue) {
                return EnumSkyBlock.Sky.defaultLightValue - par4;
            }
            return 0;
        }
        int n = i = this.worldObj.worldProvider.hasNoSky ? 0 : extendedblockstorage.getExtSkylightValue(par1, par2 & 0xF, par3);
        if (i > 0) {
            isLit = true;
        }
        if ((j = extendedblockstorage.getExtBlocklightValue(par1, par2 & 0xF, par3)) > (i -= par4)) {
            i = j;
        }
        return i;
    }

    public void addEntity(Entity par1Entity) {
        int k;
        this.hasEntities = true;
        int i = MathHelper.floor_double(par1Entity.posX / 16.0);
        int j = MathHelper.floor_double(par1Entity.posZ / 16.0);
        if (i != this.xPosition || j != this.zPosition) {
            System.out.println("Wrong location! " + par1Entity);
            Thread.dumpStack();
        }
        if ((k = MathHelper.floor_double(par1Entity.posY / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.entityLists.length) {
            k = this.entityLists.length - 1;
        }
        par1Entity.addedToChunk = true;
        par1Entity.chunkCoordX = this.xPosition;
        par1Entity.chunkCoordY = k;
        par1Entity.chunkCoordZ = this.zPosition;
        this.entityLists[k].add(par1Entity);
    }

    public void removeEntity(Entity par1Entity) {
        this.removeEntityAtIndex(par1Entity, par1Entity.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity par1Entity, int par2) {
        if (par2 < 0) {
            par2 = 0;
        }
        if (par2 >= this.entityLists.length) {
            par2 = this.entityLists.length - 1;
        }
        this.entityLists[par2].remove(par1Entity);
    }

    public boolean canBlockSeeTheSky(int par1, int par2, int par3) {
        return par2 >= this.heightMap[par3 << 4 | par1];
    }

    public TileEntity getChunkBlockTileEntity(int par1, int par2, int par3) {
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        TileEntity tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        if (tileentity == null) {
            int i = this.getBlockID(par1, par2, par3);
            if (i <= 0 || !Block.blocksList[i].hasTileEntity()) {
                return null;
            }
            if (tileentity == null) {
                tileentity = ((BlockContainer)Block.blocksList[i]).getBlockEntity();
                this.worldObj.setBlockTileEntity(this.xPosition * 16 + par1, par2, this.zPosition * 16 + par3, tileentity);
            }
            tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        }
        if (tileentity != null && tileentity.isInvalid()) {
            this.chunkTileEntityMap.remove(chunkposition);
            return null;
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity par1TileEntity) {
        int i = par1TileEntity.xCoord - this.xPosition * 16;
        int j = par1TileEntity.yCoord;
        int k = par1TileEntity.zCoord - this.zPosition * 16;
        this.setChunkBlockTileEntity(i, j, k, par1TileEntity);
        if (this.isChunkLoaded) {
            this.worldObj.loadedTileEntityList.add(par1TileEntity);
        }
    }

    public void setChunkBlockTileEntity(int par1, int par2, int par3, TileEntity par4TileEntity) {
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        par4TileEntity.worldObj = this.worldObj;
        par4TileEntity.xCoord = this.xPosition * 16 + par1;
        par4TileEntity.yCoord = par2;
        par4TileEntity.zCoord = this.zPosition * 16 + par3;
        if (this.getBlockID(par1, par2, par3) == 0 || !(Block.blocksList[this.getBlockID(par1, par2, par3)] instanceof BlockContainer)) {
            return;
        }
        par4TileEntity.validate();
        this.chunkTileEntityMap.put(chunkposition, par4TileEntity);
    }

    public void removeChunkBlockTileEntity(int par1, int par2, int par3) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        if (this.isChunkLoaded && (tileentity = (TileEntity)this.chunkTileEntityMap.remove(chunkposition)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.addTileEntity(this.chunkTileEntityMap.values());
        for (int i = 0; i < this.entityLists.length; ++i) {
            this.worldObj.addLoadedEntities(this.entityLists[i]);
        }
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            this.worldObj.markTileEntityForDespawn(tileentity);
        }
        for (int i = 0; i < this.entityLists.length; ++i) {
            this.worldObj.unloadEntities(this.entityLists[i]);
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB, List par3List) {
        int i = MathHelper.floor_double((par2AxisAlignedBB.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((par2AxisAlignedBB.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entityLists.length) {
            j = this.entityLists.length - 1;
        }
        for (int k = i; k <= j; ++k) {
            List list = this.entityLists[k];
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity == par1Entity || !entity.boundingBox.intersectsWith(par2AxisAlignedBB)) continue;
                par3List.add(entity);
                Entity[] aentity = entity.getParts();
                if (aentity == null) continue;
                for (int i1 = 0; i1 < aentity.length; ++i1) {
                    Entity entity1 = aentity[i1];
                    if (entity1 == par1Entity || !entity1.boundingBox.intersectsWith(par2AxisAlignedBB)) continue;
                    par3List.add(entity1);
                }
            }
        }
    }

    public void getEntitiesOfTypeWithinAAAB(Class par1Class, AxisAlignedBB par2AxisAlignedBB, List par3List) {
        int i = MathHelper.floor_double((par2AxisAlignedBB.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((par2AxisAlignedBB.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        } else if (i >= this.entityLists.length) {
            i = this.entityLists.length - 1;
        }
        if (j >= this.entityLists.length) {
            j = this.entityLists.length - 1;
        } else if (j < 0) {
            j = 0;
        }
        for (int k = i; k <= j; ++k) {
            List list = this.entityLists[k];
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!par1Class.isAssignableFrom(entity.getClass()) || !entity.boundingBox.intersectsWith(par2AxisAlignedBB)) continue;
                par3List.add(entity);
            }
        }
    }

    public boolean needsSaving(boolean par1) {
        if (par1 ? this.hasEntities && this.worldObj.getWorldTime() != this.lastSaveTime : this.hasEntities && this.worldObj.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public Random getRandomWithSeed(long par1) {
        return new Random(this.worldObj.getSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ par1);
    }

    public boolean isEmpty() {
        return false;
    }

    public void removeUnknownBlocks() {
        for (ExtendedBlockStorage extendedblockstorage : this.storageArrays) {
            if (extendedblockstorage == null) continue;
            extendedblockstorage.func_48711_e();
        }
    }

    public void populateChunk(IChunkProvider par1IChunkProvider, IChunkProvider par2IChunkProvider, int par3, int par4) {
        if (!this.isTerrainPopulated && par1IChunkProvider.chunkExists(par3 + 1, par4 + 1) && par1IChunkProvider.chunkExists(par3, par4 + 1) && par1IChunkProvider.chunkExists(par3 + 1, par4)) {
            par1IChunkProvider.populate(par2IChunkProvider, par3, par4);
        }
        if (par1IChunkProvider.chunkExists(par3 - 1, par4) && !par1IChunkProvider.provideChunk((int)(par3 - 1), (int)par4).isTerrainPopulated && par1IChunkProvider.chunkExists(par3 - 1, par4 + 1) && par1IChunkProvider.chunkExists(par3, par4 + 1) && par1IChunkProvider.chunkExists(par3 - 1, par4 + 1)) {
            par1IChunkProvider.populate(par2IChunkProvider, par3 - 1, par4);
        }
        if (par1IChunkProvider.chunkExists(par3, par4 - 1) && !par1IChunkProvider.provideChunk((int)par3, (int)(par4 - 1)).isTerrainPopulated && par1IChunkProvider.chunkExists(par3 + 1, par4 - 1) && par1IChunkProvider.chunkExists(par3 + 1, par4 - 1) && par1IChunkProvider.chunkExists(par3 + 1, par4)) {
            par1IChunkProvider.populate(par2IChunkProvider, par3, par4 - 1);
        }
        if (par1IChunkProvider.chunkExists(par3 - 1, par4 - 1) && !par1IChunkProvider.provideChunk((int)(par3 - 1), (int)(par4 - 1)).isTerrainPopulated && par1IChunkProvider.chunkExists(par3, par4 - 1) && par1IChunkProvider.chunkExists(par3 - 1, par4)) {
            par1IChunkProvider.populate(par2IChunkProvider, par3 - 1, par4 - 1);
        }
    }

    public int getPrecipitationHeight(int par1, int par2) {
        int i = par1 | par2 << 4;
        int j = this.precipitationHeightMap[i];
        if (j == -999) {
            int k = this.getTopFilledSegment() + 15;
            j = -1;
            while (k > 0 && j == -1) {
                Material material;
                int l = this.getBlockID(par1, k, par2);
                Material material2 = material = l != 0 ? Block.blocksList[l].blockMaterial : Material.air;
                if (!material.blocksMovement() && !material.isLiquid()) {
                    --k;
                    continue;
                }
                j = k + 1;
            }
            this.precipitationHeightMap[i] = j;
        }
        return j;
    }

    public void updateSkylight() {
        if (this.isGapLightingUpdated && !this.worldObj.worldProvider.hasNoSky) {
            this.updateSkylight_do();
        }
    }

    public ChunkCoordIntPair getChunkCoordIntPair() {
        return new ChunkCoordIntPair(this.xPosition, this.zPosition);
    }

    public boolean getAreLevelsEmpty(int par1, int par2) {
        if (par1 < 0) {
            par1 = 0;
        }
        if (par2 >= 256) {
            par2 = 255;
        }
        for (int i = par1; i <= par2; i += 16) {
            ExtendedBlockStorage extendedblockstorage = this.storageArrays[i >> 4];
            if (extendedblockstorage == null || extendedblockstorage.getIsEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setStorageArrays(ExtendedBlockStorage[] par1ArrayOfExtendedBlockStorage) {
        this.storageArrays = par1ArrayOfExtendedBlockStorage;
    }

    public void func_48494_a(byte[] par1ArrayOfByte, int par2, int par3, boolean par4) {
        int i = 0;
        for (int j = 0; j < this.storageArrays.length; ++j) {
            if ((par2 & 1 << j) != 0) {
                if (this.storageArrays[j] == null) {
                    this.storageArrays[j] = new ExtendedBlockStorage(j << 4);
                }
                byte[] abyte0 = this.storageArrays[j].func_48692_g();
                System.arraycopy(par1ArrayOfByte, i, abyte0, 0, abyte0.length);
                i += abyte0.length;
                continue;
            }
            if (!par4 || this.storageArrays[j] == null) continue;
            this.storageArrays[j] = null;
        }
        for (int k = 0; k < this.storageArrays.length; ++k) {
            if ((par2 & 1 << k) == 0 || this.storageArrays[k] == null) continue;
            NibbleArray nibblearray = this.storageArrays[k].func_48697_j();
            System.arraycopy(par1ArrayOfByte, i, nibblearray.data, 0, nibblearray.data.length);
            i += nibblearray.data.length;
        }
        for (int l = 0; l < this.storageArrays.length; ++l) {
            if ((par2 & 1 << l) == 0 || this.storageArrays[l] == null) continue;
            NibbleArray nibblearray1 = this.storageArrays[l].getBlocklightArray();
            System.arraycopy(par1ArrayOfByte, i, nibblearray1.data, 0, nibblearray1.data.length);
            i += nibblearray1.data.length;
        }
        for (int i1 = 0; i1 < this.storageArrays.length; ++i1) {
            if ((par2 & 1 << i1) == 0 || this.storageArrays[i1] == null) continue;
            NibbleArray nibblearray2 = this.storageArrays[i1].getSkylightArray();
            System.arraycopy(par1ArrayOfByte, i, nibblearray2.data, 0, nibblearray2.data.length);
            i += nibblearray2.data.length;
        }
        for (int j1 = 0; j1 < this.storageArrays.length; ++j1) {
            if ((par3 & 1 << j1) != 0) {
                if (this.storageArrays[j1] == null) {
                    i += 2048;
                    continue;
                }
                NibbleArray nibblearray3 = this.storageArrays[j1].getBlockMSBArray();
                if (nibblearray3 == null) {
                    nibblearray3 = this.storageArrays[j1].createBlockMSBArray();
                }
                System.arraycopy(par1ArrayOfByte, i, nibblearray3.data, 0, nibblearray3.data.length);
                i += nibblearray3.data.length;
                continue;
            }
            if (!par4 || this.storageArrays[j1] == null || this.storageArrays[j1].getBlockMSBArray() == null) continue;
            this.storageArrays[j1].func_48715_h();
        }
        if (par4) {
            System.arraycopy(par1ArrayOfByte, i, this.blockBiomeArray, 0, this.blockBiomeArray.length);
            i += this.blockBiomeArray.length;
        }
        for (int k1 = 0; k1 < this.storageArrays.length; ++k1) {
            if (this.storageArrays[k1] == null || (par2 & 1 << k1) == 0) continue;
            this.storageArrays[k1].func_48708_d();
        }
        this.generateHeightMap();
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            tileentity.updateContainingBlockInfo();
        }
    }

    public BiomeGenBase func_48490_a(int par1, int par2, WorldChunkManager par3WorldChunkManager) {
        int i = this.blockBiomeArray[par2 << 4 | par1] & 0xFF;
        if (i == 255) {
            BiomeGenBase biomegenbase = par3WorldChunkManager.getBiomeGenAt((this.xPosition << 4) + par1, (this.zPosition << 4) + par2);
            i = biomegenbase.biomeID;
            this.blockBiomeArray[par2 << 4 | par1] = (byte)(i & 0xFF);
        }
        if (BiomeGenBase.biomeList[i] == null) {
            return BiomeGenBase.plains;
        }
        return BiomeGenBase.biomeList[i];
    }

    public byte[] getBiomeArray() {
        return this.blockBiomeArray;
    }

    public void setBiomeArray(byte[] par1ArrayOfByte) {
        this.blockBiomeArray = par1ArrayOfByte;
    }

    public void resetRelightChecks() {
        this.queuedLightChecks = 0;
    }

    public void enqueueRelightChecks() {
        for (int i = 0; i < 8; ++i) {
            if (this.queuedLightChecks >= 4096) {
                return;
            }
            int j = this.queuedLightChecks % 16;
            int k = this.queuedLightChecks / 16 % 16;
            int l = this.queuedLightChecks / 256;
            ++this.queuedLightChecks;
            int i1 = (this.xPosition << 4) + k;
            int j1 = (this.zPosition << 4) + l;
            for (int k1 = 0; k1 < 16; ++k1) {
                int l1 = (j << 4) + k1;
                if ((this.storageArrays[j] != null || k1 != 0 && k1 != 15 && k != 0 && k != 15 && l != 0 && l != 15) && (this.storageArrays[j] == null || this.storageArrays[j].getExtBlockID(k, k1, l) != 0)) continue;
                if (Block.lightValue[this.worldObj.getBlockId(i1, l1 - 1, j1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1, l1 - 1, j1);
                }
                if (Block.lightValue[this.worldObj.getBlockId(i1, l1 + 1, j1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1, l1 + 1, j1);
                }
                if (Block.lightValue[this.worldObj.getBlockId(i1 - 1, l1, j1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1 - 1, l1, j1);
                }
                if (Block.lightValue[this.worldObj.getBlockId(i1 + 1, l1, j1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1 + 1, l1, j1);
                }
                if (Block.lightValue[this.worldObj.getBlockId(i1, l1, j1 - 1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1, l1, j1 - 1);
                }
                if (Block.lightValue[this.worldObj.getBlockId(i1, l1, j1 + 1)] > 0) {
                    this.worldObj.updateAllLightTypes(i1, l1, j1 + 1);
                }
                this.worldObj.updateAllLightTypes(i1, l1, j1);
            }
        }
    }
}

