/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenVillage;
import net.minecraft.src.World;

public class ChunkProviderFlat
implements IChunkProvider {
    private World worldObj;
    private Random random;
    private final boolean useStructures;
    private MapGenVillage villageGen = new MapGenVillage(1);

    public ChunkProviderFlat(World par1World, long par2, boolean par4) {
        this.worldObj = par1World;
        this.useStructures = par4;
        this.random = new Random(par2);
    }

    private void generate(byte[] par1ArrayOfByte) {
        int i = par1ArrayOfByte.length / 256;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    if (l == 0) {
                        i1 = Block.bedrock.blockID;
                    } else if (l <= 2) {
                        i1 = Block.dirt.blockID;
                    } else if (l == 3) {
                        i1 = Block.grass.blockID;
                    }
                    par1ArrayOfByte[j << 11 | k << 7 | l] = (byte)i1;
                }
            }
        }
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        return this.provideChunk(par1, par2);
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        byte[] abyte0 = new byte[32768];
        this.generate(abyte0);
        Chunk chunk = new Chunk(this.worldObj, abyte0, par1, par2);
        if (this.useStructures) {
            this.villageGen.generate(this, this.worldObj, par1, par2, abyte0);
        }
        BiomeGenBase[] abiomegenbase = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte1 = chunk.getBiomeArray();
        for (int i = 0; i < abyte1.length; ++i) {
            abyte1[i] = (byte)abiomegenbase[i].biomeID;
        }
        chunk.generateSkylightMap();
        return chunk;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        this.random.setSeed(this.worldObj.getSeed());
        long l = this.random.nextLong() / 2L * 2L + 1L;
        long l1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)par2 * l + (long)par3 * l1 ^ this.worldObj.getSeed());
        if (this.useStructures) {
            this.villageGen.generateStructuresInChunk(this.worldObj, this.random, par2, par3);
        }
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "FlatLevelSource";
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.getBiomeGenForCoords(par2, par4);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.getSpawnableList(par1EnumCreatureType);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int i, int j) {
        return null;
    }
}

