/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotBrewingStandIngredient;
import net.minecraft.src.SlotBrewingStandPotion;
import net.minecraft.src.TileEntityBrewingStand;

public class ContainerBrewingStand
extends Container {
    private TileEntityBrewingStand tileBrewingStand;
    private int brewTime = 0;

    public ContainerBrewingStand(InventoryPlayer par1InventoryPlayer, TileEntityBrewingStand par2TileEntityBrewingStand) {
        this.tileBrewingStand = par2TileEntityBrewingStand;
        this.addSlot(new SlotBrewingStandPotion(this, par1InventoryPlayer.player, par2TileEntityBrewingStand, 0, 56, 46));
        this.addSlot(new SlotBrewingStandPotion(this, par1InventoryPlayer.player, par2TileEntityBrewingStand, 1, 79, 53));
        this.addSlot(new SlotBrewingStandPotion(this, par1InventoryPlayer.player, par2TileEntityBrewingStand, 2, 102, 46));
        this.addSlot(new SlotBrewingStandIngredient(this, par2TileEntityBrewingStand, 3, 79, 17));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(par1InventoryPlayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot(par1InventoryPlayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void updateCraftingResults() {
        super.updateCraftingResults();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.brewTime == this.tileBrewingStand.getBrewTime()) continue;
            icrafting.updateCraftingInventoryInfo(this, 0, this.tileBrewingStand.getBrewTime());
        }
        this.brewTime = this.tileBrewingStand.getBrewTime();
    }

    @Override
    public void updateProgressBar(int par1, int par2) {
        if (par1 == 0) {
            this.tileBrewingStand.setBrewTime(par2);
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        return this.tileBrewingStand.isUseableByPlayer(par1EntityPlayer);
    }

    @Override
    public ItemStack transferStackInSlot(int par1) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(par1);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (par1 >= 0 && par1 <= 2 || par1 == 3) {
                if (!this.mergeItemStack(itemstack1, 4, 40, true)) {
                    return null;
                }
                slot.func_48433_a(itemstack1, itemstack);
            } else if (par1 >= 4 && par1 < 31 ? !this.mergeItemStack(itemstack1, 31, 40, false) : (par1 >= 31 && par1 < 40 ? !this.mergeItemStack(itemstack1, 4, 31, false) : !this.mergeItemStack(itemstack1, 4, 40, false))) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

