/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.EnchantmentData;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotEnchantment;
import net.minecraft.src.SlotEnchantmentTable;
import net.minecraft.src.World;

public class ContainerEnchantment
extends Container {
    public IInventory tableInventory = new SlotEnchantmentTable(this, "Enchant", 1);
    private World worldPointer;
    private int posX;
    private int posY;
    private int posZ;
    private Random rand = new Random();
    public long nameSeed;
    public int[] enchantLevels = new int[3];

    public ContainerEnchantment(InventoryPlayer par1InventoryPlayer, World par2World, int par3, int par4, int par5) {
        this.worldPointer = par2World;
        this.posX = par3;
        this.posY = par4;
        this.posZ = par5;
        this.addSlot(new SlotEnchantment(this, this.tableInventory, 0, 25, 47));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(par1InventoryPlayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot(par1InventoryPlayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void updateCraftingResults() {
        super.updateCraftingResults();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            icrafting.updateCraftingInventoryInfo(this, 0, this.enchantLevels[0]);
            icrafting.updateCraftingInventoryInfo(this, 1, this.enchantLevels[1]);
            icrafting.updateCraftingInventoryInfo(this, 2, this.enchantLevels[2]);
        }
    }

    @Override
    public void updateProgressBar(int par1, int par2) {
        if (par1 >= 0 && par1 <= 2) {
            this.enchantLevels[par1] = par2;
        } else {
            super.updateProgressBar(par1, par2);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory par1IInventory) {
        if (par1IInventory == this.tableInventory) {
            ItemStack itemstack = par1IInventory.getStackInSlot(0);
            if (itemstack == null || !itemstack.isItemEnchantable()) {
                for (int i = 0; i < 3; ++i) {
                    this.enchantLevels[i] = 0;
                }
            } else {
                this.nameSeed = this.rand.nextLong();
                if (!this.worldPointer.isRemote) {
                    int j = 0;
                    for (int k = -1; k <= 1; ++k) {
                        for (int i1 = -1; i1 <= 1; ++i1) {
                            if (k == 0 && i1 == 0 || !this.worldPointer.isAirBlock(this.posX + i1, this.posY, this.posZ + k) || !this.worldPointer.isAirBlock(this.posX + i1, this.posY + 1, this.posZ + k)) continue;
                            if (this.worldPointer.getBlockId(this.posX + i1 * 2, this.posY, this.posZ + k * 2) == Block.bookShelf.blockID) {
                                ++j;
                            }
                            if (this.worldPointer.getBlockId(this.posX + i1 * 2, this.posY + 1, this.posZ + k * 2) == Block.bookShelf.blockID) {
                                ++j;
                            }
                            if (i1 == 0 || k == 0) continue;
                            if (this.worldPointer.getBlockId(this.posX + i1 * 2, this.posY, this.posZ + k) == Block.bookShelf.blockID) {
                                ++j;
                            }
                            if (this.worldPointer.getBlockId(this.posX + i1 * 2, this.posY + 1, this.posZ + k) == Block.bookShelf.blockID) {
                                ++j;
                            }
                            if (this.worldPointer.getBlockId(this.posX + i1, this.posY, this.posZ + k * 2) == Block.bookShelf.blockID) {
                                ++j;
                            }
                            if (this.worldPointer.getBlockId(this.posX + i1, this.posY + 1, this.posZ + k * 2) != Block.bookShelf.blockID) continue;
                            ++j;
                        }
                    }
                    for (int l = 0; l < 3; ++l) {
                        this.enchantLevels[l] = EnchantmentHelper.calcItemStackEnchantability(this.rand, l, j, itemstack);
                    }
                    this.updateCraftingResults();
                }
            }
        }
    }

    @Override
    public boolean enchantItem(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = this.tableInventory.getStackInSlot(0);
        if (this.enchantLevels[par2] > 0 && itemstack != null && (par1EntityPlayer.experienceLevel >= this.enchantLevels[par2] || par1EntityPlayer.capabilities.isCreativeMode)) {
            List list;
            if (!this.worldPointer.isRemote && (list = EnchantmentHelper.buildEnchantmentList(this.rand, itemstack, this.enchantLevels[par2])) != null) {
                par1EntityPlayer.removeExperience(this.enchantLevels[par2]);
                for (EnchantmentData enchantmentdata : list) {
                    itemstack.addEnchantment(enchantmentdata.enchantmentobj, enchantmentdata.enchantmentLevel);
                }
                this.onCraftMatrixChanged(this.tableInventory);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onCraftGuiClosed(EntityPlayer par1EntityPlayer) {
        super.onCraftGuiClosed(par1EntityPlayer);
        if (this.worldPointer.isRemote) {
            return;
        }
        ItemStack itemstack = this.tableInventory.getStackInSlotOnClosing(0);
        if (itemstack != null) {
            par1EntityPlayer.dropPlayerItem(itemstack);
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        if (this.worldPointer.getBlockId(this.posX, this.posY, this.posZ) != Block.enchantmentTable.blockID) {
            return false;
        }
        return par1EntityPlayer.getDistanceSq((double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5) <= 64.0;
    }

    @Override
    public ItemStack transferStackInSlot(int par1) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(par1);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (par1 == 0) {
                if (!this.mergeItemStack(itemstack1, 1, 37, true)) {
                    return null;
                }
            } else {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

