/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.ICrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotFurnace;
import net.minecraft.src.TileEntityFurnace;

public class ContainerFurnace
extends Container {
    private TileEntityFurnace furnace;
    private int lastCookTime = 0;
    private int lastBurnTime = 0;
    private int lastItemBurnTime = 0;

    public ContainerFurnace(InventoryPlayer par1InventoryPlayer, TileEntityFurnace par2TileEntityFurnace) {
        this.furnace = par2TileEntityFurnace;
        this.addSlot(new Slot(par2TileEntityFurnace, 0, 56, 17));
        this.addSlot(new Slot(par2TileEntityFurnace, 1, 56, 53));
        this.addSlot(new SlotFurnace(par1InventoryPlayer.player, par2TileEntityFurnace, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(par1InventoryPlayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot(par1InventoryPlayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void updateCraftingResults() {
        super.updateCraftingResults();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.lastCookTime != this.furnace.furnaceCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 0, this.furnace.furnaceCookTime);
            }
            if (this.lastBurnTime != this.furnace.furnaceBurnTime) {
                icrafting.updateCraftingInventoryInfo(this, 1, this.furnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.furnace.currentItemBurnTime) continue;
            icrafting.updateCraftingInventoryInfo(this, 2, this.furnace.currentItemBurnTime);
        }
        this.lastCookTime = this.furnace.furnaceCookTime;
        this.lastBurnTime = this.furnace.furnaceBurnTime;
        this.lastItemBurnTime = this.furnace.currentItemBurnTime;
    }

    @Override
    public void updateProgressBar(int par1, int par2) {
        if (par1 == 0) {
            this.furnace.furnaceCookTime = par2;
        }
        if (par1 == 1) {
            this.furnace.furnaceBurnTime = par2;
        }
        if (par1 == 2) {
            this.furnace.currentItemBurnTime = par2;
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        return this.furnace.isUseableByPlayer(par1EntityPlayer);
    }

    @Override
    public ItemStack transferStackInSlot(int par1) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(par1);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (par1 == 2) {
                if (!this.mergeItemStack(itemstack1, 3, 39, true)) {
                    return null;
                }
                slot.func_48433_a(itemstack1, itemstack);
            } else if (par1 == 1 || par1 == 0 ? !this.mergeItemStack(itemstack1, 3, 39, false) : (FurnaceRecipes.smelting().getSmeltingResult(itemstack1.getItem().shiftedIndex) != null ? !this.mergeItemStack(itemstack1, 0, 1, false) : (TileEntityFurnace.func_52005_b(itemstack1) ? !this.mergeItemStack(itemstack1, 1, 2, false) : (par1 >= 3 && par1 < 30 ? !this.mergeItemStack(itemstack1, 30, 39, false) : par1 >= 30 && par1 < 39 && !this.mergeItemStack(itemstack1, 3, 30, false))))) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

