/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet;
import net.minecraft.src.WatchableObject;

public class DataWatcher {
    private static final HashMap dataTypes = new HashMap();
    private final Map watchedObjects = new HashMap();
    private boolean objectChanged;

    public void addObject(int par1, Object par2Obj) {
        Integer integer = (Integer)dataTypes.get(par2Obj.getClass());
        if (integer == null) {
            throw new IllegalArgumentException("Unknown data type: " + par2Obj.getClass());
        }
        if (par1 > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + par1 + "! (Max is " + 31 + ")");
        }
        if (this.watchedObjects.containsKey(par1)) {
            throw new IllegalArgumentException("Duplicate id value for " + par1 + "!");
        }
        WatchableObject watchableobject = new WatchableObject(integer, par1, par2Obj);
        this.watchedObjects.put(par1, watchableobject);
    }

    public byte getWatchableObjectByte(int par1) {
        return (Byte)((WatchableObject)this.watchedObjects.get(par1)).getObject();
    }

    public short getWatchableObjectShort(int par1) {
        return (Short)((WatchableObject)this.watchedObjects.get(par1)).getObject();
    }

    public int getWatchableObjectInt(int par1) {
        return (Integer)((WatchableObject)this.watchedObjects.get(par1)).getObject();
    }

    public String getWatchableObjectString(int par1) {
        return (String)((WatchableObject)this.watchedObjects.get(par1)).getObject();
    }

    public void updateObject(int par1, Object par2Obj) {
        WatchableObject watchableobject = (WatchableObject)this.watchedObjects.get(par1);
        if (!par2Obj.equals(watchableobject.getObject())) {
            watchableobject.setObject(par2Obj);
            watchableobject.setWatching(true);
            this.objectChanged = true;
        }
    }

    public static void writeObjectsInListToStream(List par0List, DataOutputStream par1DataOutputStream) throws IOException {
        if (par0List != null) {
            for (WatchableObject watchableobject : par0List) {
                DataWatcher.writeWatchableObject(par1DataOutputStream, watchableobject);
            }
        }
        par1DataOutputStream.writeByte(127);
    }

    public void writeWatchableObjects(DataOutputStream par1DataOutputStream) throws IOException {
        for (WatchableObject watchableobject : this.watchedObjects.values()) {
            DataWatcher.writeWatchableObject(par1DataOutputStream, watchableobject);
        }
        par1DataOutputStream.writeByte(127);
    }

    private static void writeWatchableObject(DataOutputStream par0DataOutputStream, WatchableObject par1WatchableObject) throws IOException {
        int i = (par1WatchableObject.getObjectType() << 5 | par1WatchableObject.getDataValueId() & 0x1F) & 0xFF;
        par0DataOutputStream.writeByte(i);
        switch (par1WatchableObject.getObjectType()) {
            case 0: {
                par0DataOutputStream.writeByte(((Byte)par1WatchableObject.getObject()).byteValue());
                break;
            }
            case 1: {
                par0DataOutputStream.writeShort(((Short)par1WatchableObject.getObject()).shortValue());
                break;
            }
            case 2: {
                par0DataOutputStream.writeInt((Integer)par1WatchableObject.getObject());
                break;
            }
            case 3: {
                par0DataOutputStream.writeFloat(((Float)par1WatchableObject.getObject()).floatValue());
                break;
            }
            case 4: {
                Packet.writeString((String)par1WatchableObject.getObject(), par0DataOutputStream);
                break;
            }
            case 5: {
                ItemStack itemstack = (ItemStack)par1WatchableObject.getObject();
                par0DataOutputStream.writeShort(itemstack.getItem().shiftedIndex);
                par0DataOutputStream.writeByte(itemstack.stackSize);
                par0DataOutputStream.writeShort(itemstack.getItemDamage());
                break;
            }
            case 6: {
                ChunkCoordinates chunkcoordinates = (ChunkCoordinates)par1WatchableObject.getObject();
                par0DataOutputStream.writeInt(chunkcoordinates.posX);
                par0DataOutputStream.writeInt(chunkcoordinates.posY);
                par0DataOutputStream.writeInt(chunkcoordinates.posZ);
            }
        }
    }

    public static List readWatchableObjects(DataInputStream par0DataInputStream) throws IOException {
        ArrayList<WatchableObject> arraylist = null;
        byte byte0 = par0DataInputStream.readByte();
        while (byte0 != 127) {
            if (arraylist == null) {
                arraylist = new ArrayList<WatchableObject>();
            }
            int i = (byte0 & 0xE0) >> 5;
            int j = byte0 & 0x1F;
            WatchableObject watchableobject = null;
            switch (i) {
                case 0: {
                    watchableobject = new WatchableObject(i, j, par0DataInputStream.readByte());
                    break;
                }
                case 1: {
                    watchableobject = new WatchableObject(i, j, par0DataInputStream.readShort());
                    break;
                }
                case 2: {
                    watchableobject = new WatchableObject(i, j, par0DataInputStream.readInt());
                    break;
                }
                case 3: {
                    watchableobject = new WatchableObject(i, j, Float.valueOf(par0DataInputStream.readFloat()));
                    break;
                }
                case 4: {
                    watchableobject = new WatchableObject(i, j, Packet.readString(par0DataInputStream, 64));
                    break;
                }
                case 5: {
                    short word0 = par0DataInputStream.readShort();
                    byte byte1 = par0DataInputStream.readByte();
                    short word1 = par0DataInputStream.readShort();
                    watchableobject = new WatchableObject(i, j, new ItemStack(word0, (int)byte1, (int)word1));
                    break;
                }
                case 6: {
                    int k = par0DataInputStream.readInt();
                    int l = par0DataInputStream.readInt();
                    int i1 = par0DataInputStream.readInt();
                    watchableobject = new WatchableObject(i, j, new ChunkCoordinates(k, l, i1));
                }
            }
            arraylist.add(watchableobject);
            byte0 = par0DataInputStream.readByte();
        }
        return arraylist;
    }

    public void updateWatchedObjectsFromList(List par1List) {
        for (WatchableObject watchableobject : par1List) {
            WatchableObject watchableobject1 = (WatchableObject)this.watchedObjects.get(watchableobject.getDataValueId());
            if (watchableobject1 == null) continue;
            watchableobject1.setObject(watchableobject.getObject());
        }
    }

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
        dataTypes.put(ItemStack.class, 5);
        dataTypes.put(ChunkCoordinates.class, 6);
    }
}

