/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ActiveRenderInfo;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityFX;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();

    public EffectRenderer(World par1World, RenderEngine par2RenderEngine) {
        if (par1World != null) {
            this.worldObj = par1World;
        }
        this.renderer = par2RenderEngine;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i] = new ArrayList();
        }
    }

    public void addEffect(EntityFX par1EntityFX) {
        int i = par1EntityFX.getFXLayer();
        if (this.fxLayers[i].size() >= 4000) {
            this.fxLayers[i].remove(0);
        }
        this.fxLayers[i].add(par1EntityFX);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.fxLayers[i].size(); ++j) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i].get(j);
                entityfx.onUpdate();
                if (!entityfx.isDead) continue;
                this.fxLayers[i].remove(j--);
            }
        }
    }

    public void renderParticles(Entity par1Entity, float par2) {
        float f = ActiveRenderInfo.rotationX;
        float f1 = ActiveRenderInfo.rotationZ;
        float f2 = ActiveRenderInfo.rotationYZ;
        float f3 = ActiveRenderInfo.rotationXY;
        float f4 = ActiveRenderInfo.rotationXZ;
        EntityFX.interpPosX = par1Entity.lastTickPosX + (par1Entity.posX - par1Entity.lastTickPosX) * (double)par2;
        EntityFX.interpPosY = par1Entity.lastTickPosY + (par1Entity.posY - par1Entity.lastTickPosY) * (double)par2;
        EntityFX.interpPosZ = par1Entity.lastTickPosZ + (par1Entity.posZ - par1Entity.lastTickPosZ) * (double)par2;
        for (int i = 0; i < 3; ++i) {
            if (this.fxLayers[i].size() == 0) continue;
            int j = 0;
            if (i == 0) {
                j = this.renderer.getTexture("/particles.png");
            }
            if (i == 1) {
                j = this.renderer.getTexture("/terrain.png");
            }
            if (i == 2) {
                j = this.renderer.getTexture("/gui/items.png");
            }
            GL11.glBindTexture((int)3553, (int)j);
            Tessellator tessellator = Tessellator.instance;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.startDrawingQuads();
            for (int k = 0; k < this.fxLayers[i].size(); ++k) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i].get(k);
                tessellator.setBrightness(entityfx.getBrightnessForRender(par2));
                entityfx.renderParticle(tessellator, par2, f, f4, f1, f2, f3);
            }
            tessellator.draw();
        }
    }

    public void func_1187_b(Entity par1Entity, float par2) {
        float f = MathHelper.cos(par1Entity.rotationYaw * 0.01745329f);
        float f1 = MathHelper.sin(par1Entity.rotationYaw * 0.01745329f);
        float f2 = -f1 * MathHelper.sin(par1Entity.rotationPitch * 0.01745329f);
        float f3 = f * MathHelper.sin(par1Entity.rotationPitch * 0.01745329f);
        float f4 = MathHelper.cos(par1Entity.rotationPitch * 0.01745329f);
        int byte0 = 3;
        if (this.fxLayers[byte0].size() == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.fxLayers[byte0].size(); ++i) {
            EntityFX entityfx = (EntityFX)this.fxLayers[byte0].get(i);
            tessellator.setBrightness(entityfx.getBrightnessForRender(par2));
            entityfx.renderParticle(tessellator, par2, f, f4, f1, f2, f3);
        }
    }

    public void clearEffects(World par1World) {
        this.worldObj = par1World;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i].clear();
        }
    }

    public void addBlockDestroyEffects(int par1, int par2, int par3, int par4, int par5) {
        if (par4 == 0) {
            return;
        }
        Block block = Block.blocksList[par4];
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d = (double)par1 + ((double)j + 0.5) / (double)i;
                    double d1 = (double)par2 + ((double)k + 0.5) / (double)i;
                    double d2 = (double)par3 + ((double)l + 0.5) / (double)i;
                    int i1 = this.rand.nextInt(6);
                    this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, d - (double)par1 - 0.5, d1 - (double)par2 - 0.5, d2 - (double)par3 - 0.5, block, i1, par5).func_4041_a(par1, par2, par3));
                }
            }
        }
    }

    public void addBlockHitEffects(int par1, int par2, int par3, int par4) {
        int i = this.worldObj.getBlockId(par1, par2, par3);
        if (i == 0) {
            return;
        }
        Block block = Block.blocksList[i];
        float f = 0.1f;
        double d = (double)par1 + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f * 2.0f)) + (double)f + block.minX;
        double d1 = (double)par2 + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f * 2.0f)) + (double)f + block.minY;
        double d2 = (double)par3 + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f * 2.0f)) + (double)f + block.minZ;
        if (par4 == 0) {
            d1 = (double)par2 + block.minY - (double)f;
        }
        if (par4 == 1) {
            d1 = (double)par2 + block.maxY + (double)f;
        }
        if (par4 == 2) {
            d2 = (double)par3 + block.minZ - (double)f;
        }
        if (par4 == 3) {
            d2 = (double)par3 + block.maxZ + (double)f;
        }
        if (par4 == 4) {
            d = (double)par1 + block.minX - (double)f;
        }
        if (par4 == 5) {
            d = (double)par1 + block.maxX + (double)f;
        }
        this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, 0.0, 0.0, 0.0, block, par4, this.worldObj.getBlockMetadata(par1, par2, par3)).func_4041_a(par1, par2, par3).multiplyVelocity(0.2f).func_405_d(0.6f));
    }

    public String getStatistics() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

