/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.EnchantmentArrowDamage;
import net.minecraft.src.EnchantmentArrowFire;
import net.minecraft.src.EnchantmentArrowInfinite;
import net.minecraft.src.EnchantmentArrowKnockback;
import net.minecraft.src.EnchantmentDamage;
import net.minecraft.src.EnchantmentDigging;
import net.minecraft.src.EnchantmentDurability;
import net.minecraft.src.EnchantmentFireAspect;
import net.minecraft.src.EnchantmentKnockback;
import net.minecraft.src.EnchantmentLootBonus;
import net.minecraft.src.EnchantmentOxygen;
import net.minecraft.src.EnchantmentProtection;
import net.minecraft.src.EnchantmentUntouching;
import net.minecraft.src.EnchantmentWaterWorker;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EnumEnchantmentType;
import net.minecraft.src.StatCollector;

public abstract class Enchantment {
    public static final Enchantment[] enchantmentsList = new Enchantment[256];
    public static final Enchantment protection = new EnchantmentProtection(0, 10, 0);
    public static final Enchantment fireProtection = new EnchantmentProtection(1, 5, 1);
    public static final Enchantment featherFalling = new EnchantmentProtection(2, 5, 2);
    public static final Enchantment blastProtection = new EnchantmentProtection(3, 2, 3);
    public static final Enchantment projectileProtection = new EnchantmentProtection(4, 5, 4);
    public static final Enchantment respiration = new EnchantmentOxygen(5, 2);
    public static final Enchantment aquaAffinity = new EnchantmentWaterWorker(6, 2);
    public static final Enchantment sharpness = new EnchantmentDamage(16, 10, 0);
    public static final Enchantment smite = new EnchantmentDamage(17, 5, 1);
    public static final Enchantment baneOfArthropods = new EnchantmentDamage(18, 5, 2);
    public static final Enchantment knockback = new EnchantmentKnockback(19, 5);
    public static final Enchantment fireAspect = new EnchantmentFireAspect(20, 2);
    public static final Enchantment looting;
    public static final Enchantment efficiency;
    public static final Enchantment silkTouch;
    public static final Enchantment unbreaking;
    public static final Enchantment fortune;
    public static final Enchantment power;
    public static final Enchantment punch;
    public static final Enchantment flame;
    public static final Enchantment infinity;
    public final int effectId;
    private final int weight;
    public EnumEnchantmentType type;
    protected String name;

    protected Enchantment(int par1, int par2, EnumEnchantmentType par3EnumEnchantmentType) {
        this.effectId = par1;
        this.weight = par2;
        this.type = par3EnumEnchantmentType;
        if (enchantmentsList[par1] != null) {
            throw new IllegalArgumentException("Duplicate enchantment id!");
        }
        Enchantment.enchantmentsList[par1] = this;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinEnchantability(int par1) {
        return 1 + par1 * 10;
    }

    public int getMaxEnchantability(int par1) {
        return this.getMinEnchantability(par1) + 5;
    }

    public int calcModifierDamage(int par1, DamageSource par2DamageSource) {
        return 0;
    }

    public int calcModifierLiving(int par1, EntityLiving par2EntityLiving) {
        return 0;
    }

    public boolean canApplyTogether(Enchantment par1Enchantment) {
        return this != par1Enchantment;
    }

    public Enchantment setName(String par1Str) {
        this.name = par1Str;
        return this;
    }

    public String getName() {
        return "enchantment." + this.name;
    }

    public String getTranslatedName(int par1) {
        String s = StatCollector.translateToLocal(this.getName());
        return s + " " + StatCollector.translateToLocal("enchantment.level." + par1);
    }

    static {
        efficiency = new EnchantmentDigging(32, 10);
        silkTouch = new EnchantmentUntouching(33, 1);
        unbreaking = new EnchantmentDurability(34, 5);
        power = new EnchantmentArrowDamage(48, 10);
        punch = new EnchantmentArrowKnockback(49, 2);
        flame = new EnchantmentArrowFire(50, 2);
        infinity = new EnchantmentArrowInfinite(51, 1);
        looting = new EnchantmentLootBonus(21, 2, EnumEnchantmentType.weapon);
        fortune = new EnchantmentLootBonus(35, 2, EnumEnchantmentType.digger);
    }
}

