/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Enchantment;
import net.minecraft.src.EnchantmentData;
import net.minecraft.src.EnchantmentModifierDamage;
import net.minecraft.src.EnchantmentModifierLiving;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.IEnchantmentModifier;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.WeightedRandom;

public class EnchantmentHelper {
    private static final Random enchantmentRand = new Random();
    private static final EnchantmentModifierDamage enchantmentModifierDamage = new EnchantmentModifierDamage(null);
    private static final EnchantmentModifierLiving enchantmentModifierLiving = new EnchantmentModifierLiving(null);

    public static int getEnchantmentLevel(int par0, ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        NBTTagList nbttaglist = par1ItemStack.getEnchantmentTagList();
        if (nbttaglist == null) {
            return 0;
        }
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            short word0 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("id");
            short word1 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("lvl");
            if (word0 != par0) continue;
            return word1;
        }
        return 0;
    }

    private static int getMaxEnchantmentLevel(int par0, ItemStack[] par1ArrayOfItemStack) {
        int i = 0;
        for (ItemStack itemstack : par1ArrayOfItemStack) {
            int l = EnchantmentHelper.getEnchantmentLevel(par0, itemstack);
            if (l <= i) continue;
            i = l;
        }
        return i;
    }

    private static void applyEnchantmentModifier(IEnchantmentModifier par0IEnchantmentModifier, ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return;
        }
        NBTTagList nbttaglist = par1ItemStack.getEnchantmentTagList();
        if (nbttaglist == null) {
            return;
        }
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            short word0 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("id");
            short word1 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("lvl");
            if (Enchantment.enchantmentsList[word0] == null) continue;
            par0IEnchantmentModifier.calculateModifier(Enchantment.enchantmentsList[word0], word1);
        }
    }

    private static void applyEnchantmentModifierArray(IEnchantmentModifier par0IEnchantmentModifier, ItemStack[] par1ArrayOfItemStack) {
        for (ItemStack itemstack : par1ArrayOfItemStack) {
            EnchantmentHelper.applyEnchantmentModifier(par0IEnchantmentModifier, itemstack);
        }
    }

    public static int getEnchantmentModifierDamage(InventoryPlayer par0InventoryPlayer, DamageSource par1DamageSource) {
        EnchantmentHelper.enchantmentModifierDamage.damageModifier = 0;
        EnchantmentHelper.enchantmentModifierDamage.damageSource = par1DamageSource;
        EnchantmentHelper.applyEnchantmentModifierArray(enchantmentModifierDamage, par0InventoryPlayer.armorInventory);
        if (EnchantmentHelper.enchantmentModifierDamage.damageModifier > 25) {
            EnchantmentHelper.enchantmentModifierDamage.damageModifier = 25;
        }
        return (EnchantmentHelper.enchantmentModifierDamage.damageModifier + 1 >> 1) + enchantmentRand.nextInt((EnchantmentHelper.enchantmentModifierDamage.damageModifier >> 1) + 1);
    }

    public static int getEnchantmentModifierLiving(InventoryPlayer par0InventoryPlayer, EntityLiving par1EntityLiving) {
        EnchantmentHelper.enchantmentModifierLiving.livingModifier = 0;
        EnchantmentHelper.enchantmentModifierLiving.entityLiving = par1EntityLiving;
        EnchantmentHelper.applyEnchantmentModifier(enchantmentModifierLiving, par0InventoryPlayer.getCurrentItem());
        if (EnchantmentHelper.enchantmentModifierLiving.livingModifier > 0) {
            return 1 + enchantmentRand.nextInt(EnchantmentHelper.enchantmentModifierLiving.livingModifier);
        }
        return 0;
    }

    public static int getKnockbackModifier(InventoryPlayer par0InventoryPlayer, EntityLiving par1EntityLiving) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.knockback.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static int getFireAspectModifier(InventoryPlayer par0InventoryPlayer, EntityLiving par1EntityLiving) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.fireAspect.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static int getRespiration(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantment.respiration.effectId, par0InventoryPlayer.armorInventory);
    }

    public static int getEfficiencyModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.efficiency.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static int getUnbreakingModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.unbreaking.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static boolean getSilkTouchModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.silkTouch.effectId, par0InventoryPlayer.getCurrentItem()) > 0;
    }

    public static int getFortuneModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.fortune.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static int getLootingModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantment.looting.effectId, par0InventoryPlayer.getCurrentItem());
    }

    public static boolean getAquaAffinityModifier(InventoryPlayer par0InventoryPlayer) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantment.aquaAffinity.effectId, par0InventoryPlayer.armorInventory) > 0;
    }

    public static int calcItemStackEnchantability(Random par0Random, int par1, int par2, ItemStack par3ItemStack) {
        Item item = par3ItemStack.getItem();
        int i = item.getItemEnchantability();
        if (i <= 0) {
            return 0;
        }
        if (par2 > 30) {
            par2 = 30;
        }
        par2 = 1 + (par2 >> 1) + par0Random.nextInt(par2 + 1);
        int j = par0Random.nextInt(5) + par2;
        if (par1 == 0) {
            return (j >> 1) + 1;
        }
        if (par1 == 1) {
            return j * 2 / 3 + 1;
        }
        return j;
    }

    public static void func_48441_a(Random par0Random, ItemStack par1ItemStack, int par2) {
        List list = EnchantmentHelper.buildEnchantmentList(par0Random, par1ItemStack, par2);
        if (list != null) {
            for (EnchantmentData enchantmentdata : list) {
                par1ItemStack.addEnchantment(enchantmentdata.enchantmentobj, enchantmentdata.enchantmentLevel);
            }
        }
    }

    public static List buildEnchantmentList(Random par0Random, ItemStack par1ItemStack, int par2) {
        EnchantmentData enchantmentdata;
        Item item = par1ItemStack.getItem();
        int i = item.getItemEnchantability();
        if (i <= 0) {
            return null;
        }
        i = 1 + par0Random.nextInt((i >> 1) + 1) + par0Random.nextInt((i >> 1) + 1);
        int j = i + par2;
        float f = (par0Random.nextFloat() + par0Random.nextFloat() - 1.0f) * 0.25f;
        int k = (int)((float)j * (1.0f + f) + 0.5f);
        ArrayList<EnchantmentData> arraylist = null;
        Map map = EnchantmentHelper.mapEnchantmentData(k, par1ItemStack);
        if (map != null && !map.isEmpty() && (enchantmentdata = (EnchantmentData)WeightedRandom.getRandomItem(par0Random, map.values())) != null) {
            arraylist = new ArrayList<EnchantmentData>();
            arraylist.add(enchantmentdata);
            for (int l = k >> 1; par0Random.nextInt(50) <= l; l >>= 1) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer integer = (Integer)iterator.next();
                    boolean flag = true;
                    for (EnchantmentData enchantmentdata2 : arraylist) {
                        if (enchantmentdata2.enchantmentobj.canApplyTogether(Enchantment.enchantmentsList[integer])) continue;
                        flag = false;
                        break;
                    }
                    if (flag) continue;
                    iterator.remove();
                }
                if (map.isEmpty()) continue;
                EnchantmentData enchantmentdata1 = (EnchantmentData)WeightedRandom.getRandomItem(par0Random, map.values());
                arraylist.add(enchantmentdata1);
            }
        }
        return arraylist;
    }

    public static Map mapEnchantmentData(int par0, ItemStack par1ItemStack) {
        Item item = par1ItemStack.getItem();
        HashMap<Integer, EnchantmentData> hashmap = null;
        for (Enchantment enchantment : Enchantment.enchantmentsList) {
            if (enchantment == null || !enchantment.type.canEnchantItem(item)) continue;
            for (int k = enchantment.getMinLevel(); k <= enchantment.getMaxLevel(); ++k) {
                if (par0 < enchantment.getMinEnchantability(k) || par0 > enchantment.getMaxEnchantability(k)) continue;
                if (hashmap == null) {
                    hashmap = new HashMap<Integer, EnchantmentData>();
                }
                hashmap.put(enchantment.effectId, new EnchantmentData(enchantment, k));
            }
        }
        return hashmap;
    }
}

