/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.DamageSource;
import net.minecraft.src.DataWatcher;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagDouble;
import net.minecraft.src.NBTTagFloat;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Profiler;
import net.minecraft.src.StepSound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class Entity {
    private static int nextEntityID = 0;
    public int entityId;
    public double renderDistanceWeight = 1.0;
    public boolean preventEntitySpawning = false;
    public Entity riddenByEntity;
    public Entity ridingEntity;
    public World worldObj;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean isCollidedHorizontally;
    public boolean isCollidedVertically;
    public boolean isCollided = false;
    public boolean velocityChanged = false;
    protected boolean isInWeb;
    public boolean field_9293_aM = true;
    public boolean isDead = false;
    public float yOffset = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified = 0.0f;
    public float distanceWalkedModified = 0.0f;
    public float fallDistance = 0.0f;
    private int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float ySize = 0.0f;
    public float stepHeight = 0.0f;
    public boolean noClip = false;
    public float entityCollisionReduction = 0.0f;
    protected Random rand;
    public int ticksExisted = 0;
    public int fireResistance = 1;
    private int fire = 0;
    protected boolean inWater = false;
    public int heartsLife = 0;
    private boolean firstUpdate = true;
    public String skinUrl;
    public String cloakUrl;
    protected boolean isImmuneToFire = false;
    protected DataWatcher dataWatcher;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isAirBorne;

    public Entity(World par1World) {
        this.entityId = nextEntityID++;
        this.rand = new Random();
        this.dataWatcher = new DataWatcher();
        this.worldObj = par1World;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataWatcher.addObject(0, (byte)0);
        this.dataWatcher.addObject(1, (short)300);
        this.entityInit();
    }

    protected abstract void entityInit();

    public DataWatcher getDataWatcher() {
        return this.dataWatcher;
    }

    public boolean equals(Object par1Obj) {
        if (par1Obj instanceof Entity) {
            return ((Entity)par1Obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void preparePlayerToSpawn() {
        if (this.worldObj == null) {
            return;
        }
        while (!(this.posY <= 0.0)) {
            this.setPosition(this.posX, this.posY, this.posZ);
            if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0) break;
            this.posY += 1.0;
        }
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.rotationPitch = 0.0f;
    }

    public void setDead() {
        this.isDead = true;
    }

    protected void setSize(float par1, float par2) {
        this.width = par1;
        this.height = par2;
    }

    protected void setRotation(float par1, float par2) {
        this.rotationYaw = par1 % 360.0f;
        this.rotationPitch = par2 % 360.0f;
    }

    public void setPosition(double par1, double par3, double par5) {
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.boundingBox.setBounds(par1 - (double)f, par3 - (double)this.yOffset + (double)this.ySize, par5 - (double)f, par1 + (double)f, par3 - (double)this.yOffset + (double)this.ySize + (double)f1, par5 + (double)f);
    }

    public void setAngles(float par1, float par2) {
        float f = this.rotationPitch;
        float f1 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)par1 * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)par2 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.prevRotationPitch += this.rotationPitch - f;
        this.prevRotationYaw += this.rotationYaw - f1;
    }

    public void onUpdate() {
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        int k;
        int j;
        int i;
        int j1;
        Profiler.startSection("entityBaseTick");
        if (this.ridingEntity != null && this.ridingEntity.isDead) {
            this.ridingEntity = null;
        }
        ++this.ticksExisted;
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.isSprinting() && !this.isInWater() && (j1 = this.worldObj.getBlockId(i = MathHelper.floor_double(this.posX), j = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), k = MathHelper.floor_double(this.posZ))) > 0) {
            this.worldObj.spawnParticle("tilecrack_" + j1, this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.boundingBox.minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, -this.motionX * 4.0, 1.5, -this.motionZ * 4.0);
        }
        if (this.handleWaterMovement()) {
            if (!this.inWater && !this.firstUpdate) {
                float f = MathHelper.sqrt_double(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.worldObj.playSoundAtEntity(this, "random.splash", f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int l = 0;
                while ((float)l < 1.0f + this.width * 20.0f) {
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f2, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++l;
                }
                int i1 = 0;
                while ((float)i1 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++i1;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fire = 0;
        } else {
            this.inWater = false;
        }
        if (this.worldObj.isRemote) {
            this.fire = 0;
        } else if (this.fire > 0) {
            if (this.isImmuneToFire) {
                this.fire -= 4;
                if (this.fire < 0) {
                    this.fire = 0;
                }
            } else {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(DamageSource.onFire, 1);
                }
                --this.fire;
            }
        }
        if (this.handleLavaMovement()) {
            this.setOnFireFromLava();
            this.fallDistance *= 0.5f;
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.isRemote) {
            this.setFlag(0, this.fire > 0);
            this.setFlag(2, this.ridingEntity != null);
        }
        this.firstUpdate = false;
        Profiler.endSection();
    }

    protected void setOnFireFromLava() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(DamageSource.lava, 4);
            this.setFire(15);
        }
    }

    public void setFire(int par1) {
        int i = par1 * 20;
        if (this.fire < i) {
            this.fire = i;
        }
    }

    public void extinguish() {
        this.fire = 0;
    }

    protected void kill() {
        this.setDead();
    }

    public boolean isOffsetPositionInLiquid(double par1, double par3, double par5) {
        AxisAlignedBB axisalignedbb = this.boundingBox.getOffsetBoundingBox(par1, par3, par5);
        List list = this.worldObj.getCollidingBoundingBoxes(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.isAnyLiquid(axisalignedbb);
    }

    public void moveEntity(double par1, double par3, double par5) {
        int i4;
        int l3;
        int k3;
        int i2;
        int k1;
        int i1;
        boolean flag;
        if (this.noClip) {
            this.boundingBox.offset(par1, par3, par5);
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
            return;
        }
        Profiler.startSection("move");
        this.ySize *= 0.4f;
        double d = this.posX;
        double d1 = this.posZ;
        if (this.isInWeb) {
            this.isInWeb = false;
            par1 *= 0.25;
            par3 *= (double)0.05f;
            par5 *= 0.25;
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        double d2 = par1;
        double d3 = par3;
        double d4 = par5;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        boolean bl = flag = this.onGround && this.isSneaking() && this instanceof EntityPlayer;
        if (flag) {
            double d5 = 0.05;
            while (par1 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(par1, -1.0, 0.0)).size() == 0) {
                par1 = par1 < d5 && par1 >= -d5 ? 0.0 : (par1 > 0.0 ? (par1 -= d5) : (par1 += d5));
                d2 = par1;
            }
            while (par5 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(0.0, -1.0, par5)).size() == 0) {
                par5 = par5 < d5 && par5 >= -d5 ? 0.0 : (par5 > 0.0 ? (par5 -= d5) : (par5 += d5));
                d4 = par5;
            }
            while (par1 != 0.0 && par5 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(par1, -1.0, par5)).size() == 0) {
                par1 = par1 < d5 && par1 >= -d5 ? 0.0 : (par1 > 0.0 ? (par1 -= d5) : (par1 += d5));
                par5 = par5 < d5 && par5 >= -d5 ? 0.0 : (par5 > 0.0 ? (par5 -= d5) : (par5 += d5));
                d2 = par1;
                d4 = par5;
            }
        }
        List list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(par1, par3, par5));
        for (int i = 0; i < list.size(); ++i) {
            par3 = ((AxisAlignedBB)list.get(i)).calculateYOffset(this.boundingBox, par3);
        }
        this.boundingBox.offset(0.0, par3, 0.0);
        if (!this.field_9293_aM && d3 != par3) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        boolean flag1 = this.onGround || d3 != par3 && d3 < 0.0;
        for (int j = 0; j < list.size(); ++j) {
            par1 = ((AxisAlignedBB)list.get(j)).calculateXOffset(this.boundingBox, par1);
        }
        this.boundingBox.offset(par1, 0.0, 0.0);
        if (!this.field_9293_aM && d2 != par1) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        for (int k = 0; k < list.size(); ++k) {
            par5 = ((AxisAlignedBB)list.get(k)).calculateZOffset(this.boundingBox, par5);
        }
        this.boundingBox.offset(0.0, 0.0, par5);
        if (!this.field_9293_aM && d4 != par5) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        if (this.stepHeight > 0.0f && flag1 && (flag || this.ySize < 0.05f) && (d2 != par1 || d4 != par5)) {
            double d6 = par1;
            double d8 = par3;
            double d10 = par5;
            par1 = d2;
            par3 = this.stepHeight;
            par5 = d4;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.copy();
            this.boundingBox.setBB(axisalignedbb);
            List list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(par1, par3, par5));
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                par3 = ((AxisAlignedBB)list1.get(j2)).calculateYOffset(this.boundingBox, par3);
            }
            this.boundingBox.offset(0.0, par3, 0.0);
            if (!this.field_9293_aM && d3 != par3) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            for (int k2 = 0; k2 < list1.size(); ++k2) {
                par1 = ((AxisAlignedBB)list1.get(k2)).calculateXOffset(this.boundingBox, par1);
            }
            this.boundingBox.offset(par1, 0.0, 0.0);
            if (!this.field_9293_aM && d2 != par1) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            for (int l2 = 0; l2 < list1.size(); ++l2) {
                par5 = ((AxisAlignedBB)list1.get(l2)).calculateZOffset(this.boundingBox, par5);
            }
            this.boundingBox.offset(0.0, 0.0, par5);
            if (!this.field_9293_aM && d4 != par5) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            if (!this.field_9293_aM && d3 != par3) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            } else {
                par3 = -this.stepHeight;
                for (int i3 = 0; i3 < list1.size(); ++i3) {
                    par3 = ((AxisAlignedBB)list1.get(i3)).calculateYOffset(this.boundingBox, par3);
                }
                this.boundingBox.offset(0.0, par3, 0.0);
            }
            if (d6 * d6 + d10 * d10 >= par1 * par1 + par5 * par5) {
                par1 = d6;
                par3 = d8;
                par5 = d10;
                this.boundingBox.setBB(axisalignedbb1);
            } else {
                double d11 = this.boundingBox.minY - (double)((int)this.boundingBox.minY);
                if (d11 > 0.0) {
                    this.ySize = (float)((double)this.ySize + (d11 + 0.01));
                }
            }
        }
        Profiler.endSection();
        Profiler.startSection("rest");
        this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
        this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
        this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        this.isCollidedHorizontally = d2 != par1 || d4 != par5;
        this.isCollidedVertically = d3 != par3;
        this.onGround = d3 != par3 && d3 < 0.0;
        this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
        this.updateFallState(par3, this.onGround);
        if (d2 != par1) {
            this.motionX = 0.0;
        }
        if (d3 != par3) {
            this.motionY = 0.0;
        }
        if (d4 != par5) {
            this.motionZ = 0.0;
        }
        double d7 = this.posX - d;
        double d9 = this.posZ - d1;
        if (this.canTriggerWalking() && !flag && this.ridingEntity == null) {
            int l1;
            int j1;
            this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt_double(d7 * d7 + d9 * d9) * 0.6);
            int l = MathHelper.floor_double(this.posX);
            int j3 = this.worldObj.getBlockId(l, j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), l1 = MathHelper.floor_double(this.posZ));
            if (j3 == 0 && this.worldObj.getBlockId(l, j1 - 1, l1) == Block.fence.blockID) {
                j3 = this.worldObj.getBlockId(l, j1 - 1, l1);
            }
            if (this.distanceWalkedModified > (float)this.nextStepDistance && j3 > 0) {
                this.nextStepDistance = (int)this.distanceWalkedModified + 1;
                this.playStepSound(l, j1, l1, j3);
                Block.blocksList[j3].onEntityWalking(this.worldObj, l, j1, l1, this);
            }
        }
        if (this.worldObj.checkChunksExist(i1 = MathHelper.floor_double(this.boundingBox.minX + 0.001), k1 = MathHelper.floor_double(this.boundingBox.minY + 0.001), i2 = MathHelper.floor_double(this.boundingBox.minZ + 0.001), k3 = MathHelper.floor_double(this.boundingBox.maxX - 0.001), l3 = MathHelper.floor_double(this.boundingBox.maxY - 0.001), i4 = MathHelper.floor_double(this.boundingBox.maxZ - 0.001))) {
            for (int j4 = i1; j4 <= k3; ++j4) {
                for (int k4 = k1; k4 <= l3; ++k4) {
                    for (int l4 = i2; l4 <= i4; ++l4) {
                        int i5 = this.worldObj.getBlockId(j4, k4, l4);
                        if (i5 <= 0) continue;
                        Block.blocksList[i5].onEntityCollidedWithBlock(this.worldObj, j4, k4, l4, this);
                    }
                }
            }
        }
        boolean flag2 = this.isWet();
        if (this.worldObj.isBoundingBoxBurning(this.boundingBox.contract(0.001, 0.001, 0.001))) {
            this.dealFireDamage(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.setFire(8);
                }
            }
        } else if (this.fire <= 0) {
            this.fire = -this.fireResistance;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.fireResistance;
        }
        Profiler.endSection();
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        StepSound stepsound = Block.blocksList[par4].stepSound;
        if (this.worldObj.getBlockId(par1, par2 + 1, par3) == Block.snow.blockID) {
            stepsound = Block.snow.stepSound;
            this.worldObj.playSoundAtEntity(this, stepsound.getStepSound(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
        } else if (!Block.blocksList[par4].blockMaterial.isLiquid()) {
            this.worldObj.playSoundAtEntity(this, stepsound.getStepSound(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
        }
    }

    protected boolean canTriggerWalking() {
        return true;
    }

    protected void updateFallState(double par1, boolean par3) {
        if (par3) {
            if (this.fallDistance > 0.0f) {
                if (this instanceof EntityLiving) {
                    int k;
                    int j;
                    int i = MathHelper.floor_double(this.posX);
                    int l = this.worldObj.getBlockId(i, j = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), k = MathHelper.floor_double(this.posZ));
                    if (l == 0 && this.worldObj.getBlockId(i, j - 1, k) == Block.fence.blockID) {
                        l = this.worldObj.getBlockId(i, j - 1, k);
                    }
                    if (l > 0) {
                        Block.blocksList[l].onFallenUpon(this.worldObj, i, j, k, this, this.fallDistance);
                    }
                }
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (par1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - par1);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    protected void dealFireDamage(int par1) {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(DamageSource.inFire, par1);
        }
    }

    public final boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    protected void fall(float par1) {
        if (this.riddenByEntity != null) {
            this.riddenByEntity.fall(par1);
        }
    }

    public boolean isWet() {
        return this.inWater || this.worldObj.canLightningStrikeAt(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0).contract(0.001, 0.001, 0.001), Material.water, this);
    }

    public boolean isInsideOfMaterial(Material par1Material) {
        int k;
        int j;
        double d = this.posY + (double)this.getEyeHeight();
        int i = MathHelper.floor_double(this.posX);
        int l = this.worldObj.getBlockId(i, j = MathHelper.floor_float(MathHelper.floor_double(d)), k = MathHelper.floor_double(this.posZ));
        if (l != 0 && Block.blocksList[l].blockMaterial == par1Material) {
            float f = BlockFluid.getFluidHeightPercent(this.worldObj.getBlockMetadata(i, j, k)) - 0.1111111f;
            float f1 = (float)(j + 1) - f;
            return d < (double)f1;
        }
        return false;
    }

    public float getEyeHeight() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand(-0.1f, -0.4f, -0.1f), Material.lava);
    }

    public void moveFlying(float par1, float par2, float par3) {
        float f = MathHelper.sqrt_float(par1 * par1 + par2 * par2);
        if (f < 0.01f) {
            return;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        f = par3 / f;
        float f1 = MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f);
        float f2 = MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f);
        this.motionX += (double)((par1 *= f) * f2 - (par2 *= f) * f1);
        this.motionZ += (double)(par2 * f2 + par1 * f1);
    }

    public int getBrightnessForRender(float par1) {
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.blockExists(i, 0, j = MathHelper.floor_double(this.posZ))) {
            double d = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
            int k = MathHelper.floor_double(this.posY - (double)this.yOffset + d);
            return this.worldObj.getLightBrightnessForSkyBlocks(i, k, j, 0);
        }
        return 0;
    }

    public float getBrightness(float par1) {
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.blockExists(i, 0, j = MathHelper.floor_double(this.posZ))) {
            double d = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
            int k = MathHelper.floor_double(this.posY - (double)this.yOffset + d);
            return this.worldObj.getLightBrightness(i, k, j);
        }
        return 0.0f;
    }

    public void setWorld(World par1World) {
        this.worldObj = par1World;
    }

    public void setPositionAndRotation(double par1, double par3, double par5, float par7, float par8) {
        this.prevPosX = this.posX = par1;
        this.prevPosY = this.posY = par3;
        this.prevPosZ = this.posZ = par5;
        this.prevRotationYaw = this.rotationYaw = par7;
        this.prevRotationPitch = this.rotationPitch = par8;
        this.ySize = 0.0f;
        double d = this.prevRotationYaw - par7;
        if (d < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (d >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(par7, par8);
    }

    public void setLocationAndAngles(double par1, double par3, double par5, float par7, float par8) {
        this.prevPosX = this.posX = par1;
        this.lastTickPosX = this.posX;
        this.prevPosY = this.posY = par3 + (double)this.yOffset;
        this.lastTickPosY = this.posY;
        this.prevPosZ = this.posZ = par5;
        this.lastTickPosZ = this.posZ;
        this.rotationYaw = par7;
        this.rotationPitch = par8;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity par1Entity) {
        float f = (float)(this.posX - par1Entity.posX);
        float f1 = (float)(this.posY - par1Entity.posY);
        float f2 = (float)(this.posZ - par1Entity.posZ);
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }

    public double getDistanceSq(double par1, double par3, double par5) {
        double d = this.posX - par1;
        double d1 = this.posY - par3;
        double d2 = this.posZ - par5;
        return d * d + d1 * d1 + d2 * d2;
    }

    public double getDistance(double par1, double par3, double par5) {
        double d = this.posX - par1;
        double d1 = this.posY - par3;
        double d2 = this.posZ - par5;
        return MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
    }

    public double getDistanceSqToEntity(Entity par1Entity) {
        double d = this.posX - par1Entity.posX;
        double d1 = this.posY - par1Entity.posY;
        double d2 = this.posZ - par1Entity.posZ;
        return d * d + d1 * d1 + d2 * d2;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    public void applyEntityCollision(Entity par1Entity) {
        if (par1Entity.riddenByEntity == this || par1Entity.ridingEntity == this) {
            return;
        }
        double d = par1Entity.posX - this.posX;
        double d1 = par1Entity.posZ - this.posZ;
        double d2 = MathHelper.abs_max(d, d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity(-(d *= (double)(1.0f - this.entityCollisionReduction)), 0.0, -(d1 *= (double)(1.0f - this.entityCollisionReduction)));
            par1Entity.addVelocity(d, 0.0, d1);
        }
    }

    public void addVelocity(double par1, double par3, double par5) {
        this.motionX += par1;
        this.motionY += par3;
        this.motionZ += par5;
        this.isAirBorne = true;
    }

    protected void setBeenAttacked() {
        this.velocityChanged = true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        this.setBeenAttacked();
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity entity, int i) {
    }

    public boolean isInRangeToRenderVec3D(Vec3D par1Vec3D) {
        double d = this.posX - par1Vec3D.xCoord;
        double d1 = this.posY - par1Vec3D.yCoord;
        double d2 = this.posZ - par1Vec3D.zCoord;
        double d3 = d * d + d1 * d1 + d2 * d2;
        return this.isInRangeToRenderDist(d3);
    }

    public boolean isInRangeToRenderDist(double par1) {
        double d = this.boundingBox.getAverageEdgeLength();
        return par1 < (d *= 64.0 * this.renderDistanceWeight) * d;
    }

    public String getTexture() {
        return null;
    }

    public boolean addEntityID(NBTTagCompound par1NBTTagCompound) {
        String s = this.getEntityString();
        if (this.isDead || s == null) {
            return false;
        }
        par1NBTTagCompound.setString("id", s);
        this.writeToNBT(par1NBTTagCompound);
        return true;
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setTag("Pos", this.newDoubleNBTList(new double[]{this.posX, this.posY + (double)this.ySize, this.posZ}));
        par1NBTTagCompound.setTag("Motion", this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        par1NBTTagCompound.setTag("Rotation", this.newFloatNBTList(new float[]{this.rotationYaw, this.rotationPitch}));
        par1NBTTagCompound.setFloat("FallDistance", this.fallDistance);
        par1NBTTagCompound.setShort("Fire", (short)this.fire);
        par1NBTTagCompound.setShort("Air", (short)this.getAir());
        par1NBTTagCompound.setBoolean("OnGround", this.onGround);
        this.writeEntityToNBT(par1NBTTagCompound);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Pos");
        NBTTagList nbttaglist1 = par1NBTTagCompound.getTagList("Motion");
        NBTTagList nbttaglist2 = par1NBTTagCompound.getTagList("Rotation");
        this.motionX = ((NBTTagDouble)nbttaglist1.tagAt((int)0)).data;
        this.motionY = ((NBTTagDouble)nbttaglist1.tagAt((int)1)).data;
        this.motionZ = ((NBTTagDouble)nbttaglist1.tagAt((int)2)).data;
        if (Math.abs(this.motionX) > 10.0) {
            this.motionX = 0.0;
        }
        if (Math.abs(this.motionY) > 10.0) {
            this.motionY = 0.0;
        }
        if (Math.abs(this.motionZ) > 10.0) {
            this.motionZ = 0.0;
        }
        this.lastTickPosX = this.posX = ((NBTTagDouble)nbttaglist.tagAt((int)0)).data;
        this.prevPosX = this.posX;
        this.lastTickPosY = this.posY = ((NBTTagDouble)nbttaglist.tagAt((int)1)).data;
        this.prevPosY = this.posY;
        this.lastTickPosZ = this.posZ = ((NBTTagDouble)nbttaglist.tagAt((int)2)).data;
        this.prevPosZ = this.posZ;
        this.prevRotationYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.tagAt((int)0)).data;
        this.prevRotationPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.tagAt((int)1)).data;
        this.fallDistance = par1NBTTagCompound.getFloat("FallDistance");
        this.fire = par1NBTTagCompound.getShort("Fire");
        this.setAir(par1NBTTagCompound.getShort("Air"));
        this.onGround = par1NBTTagCompound.getBoolean("OnGround");
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        this.readEntityFromNBT(par1NBTTagCompound);
    }

    protected final String getEntityString() {
        return EntityList.getEntityString(this);
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double[] par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d : par1ArrayOfDouble) {
            nbttaglist.appendTag(new NBTTagDouble(null, d));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float[] par1ArrayOfFloat) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float f : par1ArrayOfFloat) {
            nbttaglist.appendTag(new NBTTagFloat(null, f));
        }
        return nbttaglist;
    }

    public float getShadowSize() {
        return this.height / 2.0f;
    }

    public EntityItem dropItem(int par1, int par2) {
        return this.dropItemWithOffset(par1, par2, 0.0f);
    }

    public EntityItem dropItemWithOffset(int par1, int par2, float par3) {
        return this.entityDropItem(new ItemStack(par1, par2, 0), par3);
    }

    public EntityItem entityDropItem(ItemStack par1ItemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)par2, this.posZ, par1ItemStack);
        entityitem.delayBeforeCanPickup = 10;
        this.worldObj.spawnEntityInWorld(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.width * 0.8f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.width * 0.8f;
            int j = MathHelper.floor_double(this.posX + (double)f);
            if (!this.worldObj.isBlockNormalCube(j, k = MathHelper.floor_double(this.posY + (double)this.getEyeHeight() + (double)f1), l = MathHelper.floor_double(this.posZ + (double)f2))) continue;
            return true;
        }
        return false;
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        return false;
    }

    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return null;
    }

    public void updateRidden() {
        if (this.ridingEntity.isDead) {
            this.ridingEntity = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.onUpdate();
        if (this.ridingEntity == null) {
            return;
        }
        this.ridingEntity.updateRiderPosition();
        this.entityRiderYawDelta += (double)(this.ridingEntity.rotationYaw - this.ridingEntity.prevRotationYaw);
        this.entityRiderPitchDelta += (double)(this.ridingEntity.rotationPitch - this.ridingEntity.prevRotationPitch);
        while (this.entityRiderYawDelta >= 180.0) {
            this.entityRiderYawDelta -= 360.0;
        }
        while (this.entityRiderYawDelta < -180.0) {
            this.entityRiderYawDelta += 360.0;
        }
        while (this.entityRiderPitchDelta >= 180.0) {
            this.entityRiderPitchDelta -= 360.0;
        }
        while (this.entityRiderPitchDelta < -180.0) {
            this.entityRiderPitchDelta += 360.0;
        }
        double d = this.entityRiderYawDelta * 0.5;
        double d1 = this.entityRiderPitchDelta * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d1 > (double)f) {
            d1 = f;
        }
        if (d1 < (double)(-f)) {
            d1 = -f;
        }
        this.entityRiderYawDelta -= d;
        this.entityRiderPitchDelta -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    public void updateRiderPosition() {
        this.riddenByEntity.setPosition(this.posX, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ);
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public void mountEntity(Entity par1Entity) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (par1Entity == null) {
            if (this.ridingEntity != null) {
                this.setLocationAndAngles(this.ridingEntity.posX, this.ridingEntity.boundingBox.minY + (double)this.ridingEntity.height, this.ridingEntity.posZ, this.rotationYaw, this.rotationPitch);
                this.ridingEntity.riddenByEntity = null;
            }
            this.ridingEntity = null;
            return;
        }
        if (this.ridingEntity == par1Entity) {
            this.ridingEntity.riddenByEntity = null;
            this.ridingEntity = null;
            this.setLocationAndAngles(par1Entity.posX, par1Entity.boundingBox.minY + (double)par1Entity.height, par1Entity.posZ, this.rotationYaw, this.rotationPitch);
            return;
        }
        if (this.ridingEntity != null) {
            this.ridingEntity.riddenByEntity = null;
        }
        if (par1Entity.riddenByEntity != null) {
            par1Entity.riddenByEntity.ridingEntity = null;
        }
        this.ridingEntity = par1Entity;
        par1Entity.riddenByEntity = this;
    }

    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.setPosition(par1, par3, par5);
        this.setRotation(par7, par8);
        List list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.contract(0.03125, 0.0, 0.03125));
        if (list.size() > 0) {
            double d = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                AxisAlignedBB axisalignedbb = (AxisAlignedBB)list.get(i);
                if (!(axisalignedbb.maxY > d)) continue;
                d = axisalignedbb.maxY;
            }
            this.setPosition(par1, par3 += d - this.boundingBox.minY, par5);
        }
    }

    public float getCollisionBorderSize() {
        return 0.1f;
    }

    public Vec3D getLookVec() {
        return null;
    }

    public void setInPortal() {
    }

    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
    }

    public void handleHealthUpdate(byte byte0) {
    }

    public void performHurtAnimation() {
    }

    public void updateCloak() {
    }

    public void outfitWithItem(int i, int j, int k) {
    }

    public boolean isBurning() {
        return this.fire > 0 || this.getFlag(0);
    }

    public boolean isRiding() {
        return this.ridingEntity != null || this.getFlag(2);
    }

    public boolean isSneaking() {
        return this.getFlag(1);
    }

    public void setSneaking(boolean par1) {
        this.setFlag(1, par1);
    }

    public boolean isSprinting() {
        return this.getFlag(3);
    }

    public void setSprinting(boolean par1) {
        this.setFlag(3, par1);
    }

    public boolean isEating() {
        return this.getFlag(4);
    }

    public void setEating(boolean par1) {
        this.setFlag(4, par1);
    }

    protected boolean getFlag(int par1) {
        return (this.dataWatcher.getWatchableObjectByte(0) & 1 << par1) != 0;
    }

    protected void setFlag(int par1, boolean par2) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(0);
        if (par2) {
            this.dataWatcher.updateObject(0, (byte)(byte0 | 1 << par1));
        } else {
            this.dataWatcher.updateObject(0, (byte)(byte0 & ~(1 << par1)));
        }
    }

    public int getAir() {
        return this.dataWatcher.getWatchableObjectShort(1);
    }

    public void setAir(int par1) {
        this.dataWatcher.updateObject(1, (short)par1);
    }

    public void onStruckByLightning(EntityLightningBolt par1EntityLightningBolt) {
        this.dealFireDamage(5);
        ++this.fire;
        if (this.fire == 0) {
            this.setFire(8);
        }
    }

    public void onKillEntity(EntityLiving entityliving) {
    }

    protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int i = MathHelper.floor_double(par1);
        int j = MathHelper.floor_double(par3);
        int k = MathHelper.floor_double(par5);
        double d = par1 - (double)i;
        double d1 = par3 - (double)j;
        double d2 = par5 - (double)k;
        if (this.worldObj.isBlockNormalCube(i, j, k)) {
            boolean flag = !this.worldObj.isBlockNormalCube(i - 1, j, k);
            boolean flag1 = !this.worldObj.isBlockNormalCube(i + 1, j, k);
            boolean flag2 = !this.worldObj.isBlockNormalCube(i, j - 1, k);
            boolean flag3 = !this.worldObj.isBlockNormalCube(i, j + 1, k);
            boolean flag4 = !this.worldObj.isBlockNormalCube(i, j, k - 1);
            boolean flag5 = !this.worldObj.isBlockNormalCube(i, j, k + 1);
            int byte0 = -1;
            double d3 = 9999.0;
            if (flag && d < d3) {
                d3 = d;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d < d3) {
                d3 = 1.0 - d;
                byte0 = 1;
            }
            if (flag2 && d1 < d3) {
                d3 = d1;
                byte0 = 2;
            }
            if (flag3 && 1.0 - d1 < d3) {
                d3 = 1.0 - d1;
                byte0 = 3;
            }
            if (flag4 && d2 < d3) {
                d3 = d2;
                byte0 = 4;
            }
            if (flag5 && 1.0 - d2 < d3) {
                double d4 = 1.0 - d2;
                byte0 = 5;
            }
            float f = this.rand.nextFloat() * 0.2f + 0.1f;
            if (byte0 == 0) {
                this.motionX = -f;
            }
            if (byte0 == 1) {
                this.motionX = f;
            }
            if (byte0 == 2) {
                this.motionY = -f;
            }
            if (byte0 == 3) {
                this.motionY = f;
            }
            if (byte0 == 4) {
                this.motionZ = -f;
            }
            if (byte0 == 5) {
                this.motionZ = f;
            }
            return true;
        }
        return false;
    }

    public void setInWeb() {
        this.isInWeb = true;
        this.fallDistance = 0.0f;
    }

    public Entity[] getParts() {
        return null;
    }

    public boolean isEntityEqual(Entity par1Entity) {
        return this == par1Entity;
    }

    public void func_48079_f(float f) {
    }

    public boolean canAttackWithItem() {
        return true;
    }
}

