/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityLiving;

public class EntityAICreeperSwell
extends EntityAIBase {
    EntityCreeper swellingCreeper;
    EntityLiving creeperAttackTarget;

    public EntityAICreeperSwell(EntityCreeper par1EntityCreeper) {
        this.swellingCreeper = par1EntityCreeper;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        EntityLiving entityliving = this.swellingCreeper.getAttackTarget();
        return this.swellingCreeper.getCreeperState() > 0 || entityliving != null && this.swellingCreeper.getDistanceSqToEntity(entityliving) < 9.0;
    }

    @Override
    public void startExecuting() {
        this.swellingCreeper.getNavigator().clearPathEntity();
        this.creeperAttackTarget = this.swellingCreeper.getAttackTarget();
    }

    @Override
    public void resetTask() {
        this.creeperAttackTarget = null;
    }

    @Override
    public void updateTask() {
        if (this.creeperAttackTarget == null) {
            this.swellingCreeper.setCreeperState(-1);
            return;
        }
        if (this.swellingCreeper.getDistanceSqToEntity(this.creeperAttackTarget) > 49.0) {
            this.swellingCreeper.setCreeperState(-1);
            return;
        }
        if (!this.swellingCreeper.getEntitySenses().canSee(this.creeperAttackTarget)) {
            this.swellingCreeper.setCreeperState(-1);
            return;
        }
        this.swellingCreeper.setCreeperState(1);
    }
}

