/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathNavigate;
import net.minecraft.src.PathPoint;

public abstract class EntityAIDoorInteract
extends EntityAIBase {
    protected EntityLiving theEntity;
    protected int entityPosX;
    protected int entityPosY;
    protected int entityPosZ;
    protected BlockDoor targetDoor;
    boolean field_48319_f;
    float field_48320_g;
    float field_48326_h;

    public EntityAIDoorInteract(EntityLiving par1EntityLiving) {
        this.theEntity = par1EntityLiving;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.theEntity.isCollidedHorizontally) {
            return false;
        }
        PathNavigate pathnavigate = this.theEntity.getNavigator();
        PathEntity pathentity = pathnavigate.getPath();
        if (pathentity == null || pathentity.isFinished() || !pathnavigate.getCanBreakDoors()) {
            return false;
        }
        for (int i = 0; i < Math.min(pathentity.getCurrentPathIndex() + 2, pathentity.getCurrentPathLength()); ++i) {
            PathPoint pathpoint = pathentity.getPathPointFromIndex(i);
            this.entityPosX = pathpoint.xCoord;
            this.entityPosY = pathpoint.yCoord + 1;
            this.entityPosZ = pathpoint.zCoord;
            if (this.theEntity.getDistanceSq(this.entityPosX, this.theEntity.posY, this.entityPosZ) > 2.25) continue;
            this.targetDoor = this.func_48318_a(this.entityPosX, this.entityPosY, this.entityPosZ);
            if (this.targetDoor == null) continue;
            return true;
        }
        this.entityPosX = MathHelper.floor_double(this.theEntity.posX);
        this.entityPosY = MathHelper.floor_double(this.theEntity.posY + 1.0);
        this.entityPosZ = MathHelper.floor_double(this.theEntity.posZ);
        this.targetDoor = this.func_48318_a(this.entityPosX, this.entityPosY, this.entityPosZ);
        return this.targetDoor != null;
    }

    @Override
    public boolean continueExecuting() {
        return !this.field_48319_f;
    }

    @Override
    public void startExecuting() {
        this.field_48319_f = false;
        this.field_48320_g = (float)((double)((float)this.entityPosX + 0.5f) - this.theEntity.posX);
        this.field_48326_h = (float)((double)((float)this.entityPosZ + 0.5f) - this.theEntity.posZ);
    }

    @Override
    public void updateTask() {
        float f = (float)((double)((float)this.entityPosX + 0.5f) - this.theEntity.posX);
        float f1 = (float)((double)((float)this.entityPosZ + 0.5f) - this.theEntity.posZ);
        float f2 = this.field_48320_g * f + this.field_48326_h * f1;
        if (f2 < 0.0f) {
            this.field_48319_f = true;
        }
    }

    private BlockDoor func_48318_a(int par1, int par2, int par3) {
        int i = this.theEntity.worldObj.getBlockId(par1, par2, par3);
        if (i != Block.doorWood.blockID) {
            return null;
        }
        BlockDoor blockdoor = (BlockDoor)Block.blocksList[i];
        return blockdoor;
    }
}

