/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityAIFleeSun
extends EntityAIBase {
    private EntityCreature theCreature;
    private double shelterX;
    private double shelterY;
    private double shelterZ;
    private float field_48299_e;
    private World theWorld;

    public EntityAIFleeSun(EntityCreature par1EntityCreature, float par2) {
        this.theCreature = par1EntityCreature;
        this.field_48299_e = par2;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (!this.theWorld.isDaytime()) {
            return false;
        }
        if (!this.theCreature.isBurning()) {
            return false;
        }
        if (!this.theWorld.canBlockSeeTheSky(MathHelper.floor_double(this.theCreature.posX), (int)this.theCreature.boundingBox.minY, MathHelper.floor_double(this.theCreature.posZ))) {
            return false;
        }
        Vec3D vec3d = this.findPossibleShelter();
        if (vec3d == null) {
            return false;
        }
        this.shelterX = vec3d.xCoord;
        this.shelterY = vec3d.yCoord;
        this.shelterZ = vec3d.zCoord;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return !this.theCreature.getNavigator().noPath();
    }

    @Override
    public void startExecuting() {
        this.theCreature.getNavigator().tryMoveToXYZ(this.shelterX, this.shelterY, this.shelterZ, this.field_48299_e);
    }

    private Vec3D findPossibleShelter() {
        Random random = this.theCreature.getRNG();
        for (int i = 0; i < 10; ++i) {
            int l;
            int k;
            int j = MathHelper.floor_double(this.theCreature.posX + (double)random.nextInt(20) - 10.0);
            if (this.theWorld.canBlockSeeTheSky(j, k = MathHelper.floor_double(this.theCreature.boundingBox.minY + (double)random.nextInt(6) - 3.0), l = MathHelper.floor_double(this.theCreature.posZ + (double)random.nextInt(20) - 10.0)) || !(this.theCreature.getBlockPathWeight(j, k, l) < 0.0f)) continue;
            return Vec3D.createVector(j, k, l);
        }
        return null;
    }
}

