/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityTameable;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;

public abstract class EntityAITarget
extends EntityAIBase {
    protected EntityLiving taskOwner;
    protected float targetDistance;
    protected boolean field_48380_e;
    private boolean field_48383_a;
    private int field_48381_b = 0;
    private int field_48377_f = 0;
    private int field_48378_g = 0;

    public EntityAITarget(EntityLiving par1EntityLiving, float par2, boolean par3) {
        this(par1EntityLiving, par2, par3, false);
    }

    public EntityAITarget(EntityLiving par1EntityLiving, float par2, boolean par3, boolean par4) {
        this.taskOwner = par1EntityLiving;
        this.targetDistance = par2;
        this.field_48380_e = par3;
        this.field_48383_a = par4;
    }

    @Override
    public boolean continueExecuting() {
        EntityLiving entityliving = this.taskOwner.getAttackTarget();
        if (entityliving == null) {
            return false;
        }
        if (!entityliving.isEntityAlive()) {
            return false;
        }
        if (this.taskOwner.getDistanceSqToEntity(entityliving) > (double)(this.targetDistance * this.targetDistance)) {
            return false;
        }
        if (this.field_48380_e) {
            if (!this.taskOwner.getEntitySenses().canSee(entityliving)) {
                if (++this.field_48378_g > 60) {
                    return false;
                }
            } else {
                this.field_48378_g = 0;
            }
        }
        return true;
    }

    @Override
    public void startExecuting() {
        this.field_48381_b = 0;
        this.field_48377_f = 0;
        this.field_48378_g = 0;
    }

    @Override
    public void resetTask() {
        this.taskOwner.setAttackTarget(null);
    }

    protected boolean func_48376_a(EntityLiving par1EntityLiving, boolean par2) {
        if (par1EntityLiving == null) {
            return false;
        }
        if (par1EntityLiving == this.taskOwner) {
            return false;
        }
        if (!par1EntityLiving.isEntityAlive()) {
            return false;
        }
        if (par1EntityLiving.boundingBox.maxY <= this.taskOwner.boundingBox.minY || par1EntityLiving.boundingBox.minY >= this.taskOwner.boundingBox.maxY) {
            return false;
        }
        if (!this.taskOwner.func_48100_a(par1EntityLiving.getClass())) {
            return false;
        }
        if (this.taskOwner instanceof EntityTameable && ((EntityTameable)this.taskOwner).isTamed()) {
            if (par1EntityLiving instanceof EntityTameable && ((EntityTameable)par1EntityLiving).isTamed()) {
                return false;
            }
            if (par1EntityLiving == ((EntityTameable)this.taskOwner).getOwner()) {
                return false;
            }
        } else if (par1EntityLiving instanceof EntityPlayer && !par2 && ((EntityPlayer)par1EntityLiving).capabilities.disableDamage) {
            return false;
        }
        if (!this.taskOwner.isWithinHomeDistance(MathHelper.floor_double(par1EntityLiving.posX), MathHelper.floor_double(par1EntityLiving.posY), MathHelper.floor_double(par1EntityLiving.posZ))) {
            return false;
        }
        if (this.field_48380_e && !this.taskOwner.getEntitySenses().canSee(par1EntityLiving)) {
            return false;
        }
        if (this.field_48383_a) {
            if (--this.field_48377_f <= 0) {
                this.field_48381_b = 0;
            }
            if (this.field_48381_b == 0) {
                int n = this.field_48381_b = this.func_48375_a(par1EntityLiving) ? 1 : 2;
            }
            if (this.field_48381_b == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean func_48375_a(EntityLiving par1EntityLiving) {
        int j;
        this.field_48377_f = 10 + this.taskOwner.getRNG().nextInt(5);
        PathEntity pathentity = this.taskOwner.getNavigator().func_48679_a(par1EntityLiving);
        if (pathentity == null) {
            return false;
        }
        PathPoint pathpoint = pathentity.getFinalPathPoint();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.xCoord - MathHelper.floor_double(par1EntityLiving.posX);
        return (double)(i * i + (j = pathpoint.zCoord - MathHelper.floor_double(par1EntityLiving.posZ)) * j) <= 2.25;
    }
}

