/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityVillager;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Village;
import net.minecraft.src.World;

public class EntityAIVillagerMate
extends EntityAIBase {
    private EntityVillager villagerObj;
    private EntityVillager mate;
    private World worldObj;
    private int matingTimeout = 0;
    Village villageObj;

    public EntityAIVillagerMate(EntityVillager par1EntityVillager) {
        this.villagerObj = par1EntityVillager;
        this.worldObj = par1EntityVillager.worldObj;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        if (this.villagerObj.getGrowingAge() != 0) {
            return false;
        }
        if (this.villagerObj.getRNG().nextInt(500) != 0) {
            return false;
        }
        this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double(this.villagerObj.posX), MathHelper.floor_double(this.villagerObj.posY), MathHelper.floor_double(this.villagerObj.posZ), 0);
        if (this.villageObj == null) {
            return false;
        }
        if (!this.checkSufficientDoorsPresentForNewVillager()) {
            return false;
        }
        Entity entity = this.worldObj.findNearestEntityWithinAABB(EntityVillager.class, this.villagerObj.boundingBox.expand(8.0, 3.0, 8.0), this.villagerObj);
        if (entity == null) {
            return false;
        }
        this.mate = (EntityVillager)entity;
        return this.mate.getGrowingAge() == 0;
    }

    @Override
    public void startExecuting() {
        this.matingTimeout = 300;
        this.villagerObj.setIsMatingFlag(true);
    }

    @Override
    public void resetTask() {
        this.villageObj = null;
        this.mate = null;
        this.villagerObj.setIsMatingFlag(false);
    }

    @Override
    public boolean continueExecuting() {
        return this.matingTimeout >= 0 && this.checkSufficientDoorsPresentForNewVillager() && this.villagerObj.getGrowingAge() == 0;
    }

    @Override
    public void updateTask() {
        --this.matingTimeout;
        this.villagerObj.getLookHelper().setLookPositionWithEntity(this.mate, 10.0f, 30.0f);
        if (this.villagerObj.getDistanceSqToEntity(this.mate) > 2.25) {
            this.villagerObj.getNavigator().func_48667_a(this.mate, 0.25f);
        } else if (this.matingTimeout == 0 && this.mate.getIsMatingFlag()) {
            this.giveBirth();
        }
        if (this.villagerObj.getRNG().nextInt(35) == 0) {
            this.spawnHeartParticles(this.villagerObj);
        }
    }

    private boolean checkSufficientDoorsPresentForNewVillager() {
        int i = (int)((double)this.villageObj.getNumVillageDoors() * 0.35);
        return this.villageObj.getNumVillagers() < i;
    }

    private void giveBirth() {
        EntityVillager entityvillager = new EntityVillager(this.worldObj);
        this.mate.setGrowingAge(6000);
        this.villagerObj.setGrowingAge(6000);
        entityvillager.setGrowingAge(-24000);
        entityvillager.setProfession(this.villagerObj.getRNG().nextInt(5));
        entityvillager.setLocationAndAngles(this.villagerObj.posX, this.villagerObj.posY, this.villagerObj.posZ, 0.0f, 0.0f);
        this.worldObj.spawnEntityInWorld(entityvillager);
        this.spawnHeartParticles(entityvillager);
    }

    private void spawnHeartParticles(EntityLiving par1EntityLiving) {
        Random random = par1EntityLiving.getRNG();
        for (int i = 0; i < 5; ++i) {
            double d = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            this.worldObj.spawnParticle("heart", par1EntityLiving.posX + (double)(random.nextFloat() * par1EntityLiving.width * 2.0f) - (double)par1EntityLiving.width, par1EntityLiving.posY + 1.0 + (double)(random.nextFloat() * par1EntityLiving.height), par1EntityLiving.posZ + (double)(random.nextFloat() * par1EntityLiving.width * 2.0f) - (double)par1EntityLiving.width, d, d1, d2);
        }
    }
}

